/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.FormatFileWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.FileUtil;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class Db2FormatFileWriter
implements FormatFileWriter {
    private boolean useFullFilepath;
    private Map<String, String> codePageMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);

    public Db2FormatFileWriter() {
        this.codePageMap.put("UTF-8", "1208");
        this.codePageMap.put("UTF-16", "1200");
        this.codePageMap.put("UTF-16BE", "1200");
        this.codePageMap.put("UTF-16LE", "1200");
        this.codePageMap.put("ISO-8859-1", "819");
        this.codePageMap.put("ISO-8859-15", "923");
        this.codePageMap.put("ISO-8859-6", "1089");
        this.codePageMap.put("ISO-8859-5", "915");
        this.codePageMap.put("US-ASCII", "437");
    }

    @Override
    public void setUseFullFilepath(boolean bl) {
        this.useFullFilepath = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFormatFile(DataExporter dataExporter, RowDataConverter rowDataConverter) {
        ResultInfo resultInfo = rowDataConverter.getResultInfo();
        WbFile wbFile = new WbFile(dataExporter.getFullOutputFilename());
        String string = wbFile.getParent();
        String string2 = wbFile.getFileName();
        String string3 = this.useFullFilepath ? wbFile.getFullPath() : wbFile.getName();
        WbFile wbFile2 = new WbFile(string, string2 + ".clp");
        PrintWriter printWriter = null;
        try {
            String string4;
            String string5;
            printWriter = new PrintWriter(new FileWriter(wbFile2));
            printWriter.println("-- use db2 -tf " + wbFile2.getName() + " to run this file");
            printWriter.println("IMPORT FROM " + string3 + " OF DEL");
            int n = resultInfo.getColumnCount();
            boolean bl = false;
            boolean bl2 = dataExporter.getWriteClobAsFile();
            for (int i = 0; i < n; ++i) {
                int n2 = resultInfo.getColumnType(i);
                string5 = resultInfo.getDbmsTypeName(i);
                if (!SqlUtil.isBlobType(n2) && (!bl2 || !SqlUtil.isClobType(n2, string5, this.getDbSettings(dataExporter)))) continue;
                bl = true;
                break;
            }
            if (bl) {
                printWriter.println("  LOBS FROM . ");
            }
            printWriter.println("  MODIFIED BY coldel" + this.convertDelimiter(dataExporter.getTextDelimiter()));
            String string6 = dataExporter.getTextQuoteChar();
            if (string6 != null) {
                printWriter.println("              chardel" + this.convertDelimiter(string6));
            }
            String string7 = dataExporter.getDecimalSymbol();
            printWriter.println("              decpt=" + (string7 == null ? "." : string7));
            string5 = this.convertEncodingToCodePage(dataExporter.getEncoding());
            if (string5 != null) {
                printWriter.println("              codepage=" + string5);
            }
            if ((string4 = dataExporter.getTimestampFormat()) != null) {
                printWriter.println("              timestampformat=\"" + this.convertJavaDateFormatToDB2(string4) + "\"");
            }
            if ((string4 = dataExporter.getDateFormat()) != null) {
                printWriter.println("              dateformat=\"" + this.convertJavaDateFormatToDB2(string4) + "\"");
            }
            printWriter.print("  METHOD P(");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    printWriter.print(", ");
                }
                printWriter.print(NumberStringCache.getNumberString(i + 1));
            }
            printWriter.println(")");
            printWriter.print("  INSERT INTO ");
            String string8 = dataExporter.getTableNameToUse();
            printWriter.println(string8);
            printWriter.println(";");
        }
        catch (IOException iOException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error opening outputfile", iOException);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(printWriter);
                throw throwable;
            }
            FileUtil.closeQuietely(printWriter);
        }
        FileUtil.closeQuietely(printWriter);
    }

    private DbSettings getDbSettings(DataExporter dataExporter) {
        if (dataExporter == null) {
            return null;
        }
        WbConnection wbConnection = dataExporter.getConnection();
        if (wbConnection == null) {
            return null;
        }
        return wbConnection.getDbSettings();
    }

    private String convertDelimiter(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("\\t")) {
            return "X09";
        }
        if (string.equals("\"")) {
            return "\"\"";
        }
        if (string.equals("'")) {
            return "''";
        }
        char c = string.charAt(0);
        if (c < ' ') {
            String string2 = Integer.toHexString(c);
            if (string2.length() == 1) {
                return "X0" + string2;
            }
            return "X" + string2;
        }
        return string;
    }

    private String convertJavaDateFormatToDB2(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replace("HH", "HH");
        string2 = string2.replace("hh", "TTHH");
        string2 = string2.replace("mm", "MM");
        string2 = string2.replace("yy", "YY");
        string2 = string2.replace("dd", "DD");
        string2 = string2.replace("ss", "SS");
        return string2;
    }

    private String convertEncodingToCodePage(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.codePageMap.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string2.startsWith("IBM")) {
            string2 = string.replaceAll("^IBM-?", "");
        }
        if (string2.toLowerCase().startsWith("windows")) {
            string2 = string.replaceAll("(?i)^windows-?", "");
        }
        return string2;
    }
}

