/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class Db2ProcedureReader
extends JdbcProcedureReader {
    private boolean forceJDBC = false;

    public Db2ProcedureReader(WbConnection wbConnection, String string) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        DataStore dataStore;
        if (this.useJDBC()) {
            return super.getProcedures(string, string2, string3);
        }
        string = DbMetadata.cleanupWildcards(string);
        string2 = DbMetadata.cleanupWildcards(string2);
        string3 = DbMetadata.cleanupWildcards(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = this.getSQL(string2, string3);
        try {
            LogMgr.logMetadataSql(new CallerInfo(){}, "procedures", string4, new Object[0]);
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(string4);
            DataStore dataStore2 = this.fillProcedureListDataStore(resultSet);
            if (this.connection.getDbSettings().showProcedureParameters()) {
                this.updateDisplayNames(dataStore2);
            }
            dataStore = dataStore2;
        }
        catch (Exception exception) {
            DataStore dataStore3;
            try {
                this.forceJDBC = true;
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedures", string4, new Object[0]);
                dataStore3 = super.getProcedures(string, string2, string3);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeStatement(statement);
            return dataStore3;
        }
        JdbcUtils.closeStatement(statement);
        return dataStore;
    }

    private void updateDisplayNames(DataStore dataStore) {
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            ProcedureDefinition procedureDefinition = (ProcedureDefinition)dataStore.getRow(i).getUserObject();
            procedureDefinition.readParameters(this.connection);
            this.updateDisplayName(procedureDefinition);
            if (procedureDefinition.getDisplayName() == null) continue;
            dataStore.setValue(i, 0, (Object)procedureDefinition.getDisplayName());
        }
    }

    private void updateDisplayName(ProcedureDefinition procedureDefinition) {
        List<String> list = procedureDefinition.getParameterTypes();
        if (list.size() > 0) {
            String string = procedureDefinition.getProcedureName() + "(" + StringUtil.listToString(list, ',') + ")";
            procedureDefinition.setDisplayName(string);
        }
    }

    private String getSQL(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (DBID.DB2_ISERIES.isDB(this.connection)) {
            stringBuilder.append("SELECT '' as PROCEDURE_CAT,  \n      ROUTINE_SCHEMA  as PROCEDURE_SCHEM, \n      ROUTINE_NAME as PROCEDURE_NAME, \n      LONG_COMMENT AS REMARKS, \n      CASE  \n        WHEN ROUTINE_TYPE = 'FUNCTION' THEN 2  \n        WHEN ROUTINE_TYPE = 'PROCEDURE' THEN 1  \n        ELSE 0  \n      END as PROCEDURE_TYPE, \n      specific_name \nFROM qsys2" + this.connection.getMetadata().getCatalogSeparator() + "sysroutines \nWHERE function_origin <> ('B')");
            SqlUtil.appendAndCondition(stringBuilder, "ROUTINE_SCHEMA", string, this.connection);
            SqlUtil.appendAndCondition(stringBuilder, "ROUTINE_NAME", string2, this.connection);
        } else if (DBID.DB2_ZOS.isDB(this.connection)) {
            stringBuilder.append("SELECT '' as PROCEDURE_CAT,  \n       schema as PROCEDURE_SCHEM, \n       name as PROCEDURE_NAME, \n       remarks, \n       CASE  \n         WHEN routinetype = 'F' THEN 2  \n         ELSE 1  \n       END as PROCEDURE_TYPE, \n       NULL as SPECIFIC_NAME \nFROM SYSIBM.SYSROUTINES \nWHERE routinetype in ('F', 'P') \n  AND origin in ('Q', 'U') \n");
            SqlUtil.appendAndCondition(stringBuilder, "schema", string, this.connection);
            SqlUtil.appendAndCondition(stringBuilder, "name", string2, this.connection);
        } else {
            stringBuilder.append("SELECT '' as PROCEDURE_CAT,  \n       routineschema as PROCEDURE_SCHEM, \n       routinename as PROCEDURE_NAME, \n       remarks, \n       CASE  \n         WHEN routinetype = 'F' THEN 2  \n         ELSE 1  \n       END as PROCEDURE_TYPE, \n       SPECIFICNAME as SPECIFIC_NAME \nFROM syscat.routines \nWHERE routinetype in ('F', 'P') \n  AND origin in ('Q', 'U') \n");
            SqlUtil.appendAndCondition(stringBuilder, "routineschema", string, this.connection);
            SqlUtil.appendAndCondition(stringBuilder, "routinename", string2, this.connection);
        }
        return stringBuilder.toString();
    }

    @Override
    public void readProcedureParameters(ProcedureDefinition procedureDefinition) throws SQLException {
        super.readProcedureParameters(procedureDefinition);
        this.updateDisplayName(procedureDefinition);
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        if (procedureDefinition.isFunction() && this.useSQLFunctionsProc()) {
            return this.getFunctionParameters(procedureDefinition);
        }
        return super.getProcedureColumns(procedureDefinition);
    }

    public DataStore getFunctionParameters(ProcedureDefinition procedureDefinition) throws SQLException {
        DataStore dataStore = this.createProcColsDataStore();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.connection.getDbSettings().getProperty("functionparams.procschema", "SYSIBM");
        String string2 = this.connection.getDbSettings().getProperty("functionparams.options", "UNDERSCORE=0");
        String string3 = "call " + string + ".SQLFUNCTIONCOLS(?, ?, ?, '%', '" + string2 + "')";
        LogMgr.logMetadataSql(new CallerInfo(){}, "function parameters", string3, new Object[0]);
        try {
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, procedureDefinition.getCatalog());
            preparedStatement.setString(2, procedureDefinition.getSchema());
            preparedStatement.setString(3, procedureDefinition.getProcedureName());
            resultSet = preparedStatement.executeQuery();
            int n = JdbcUtils.getColumnIndex(resultSet, "SPECIFIC_NAME");
            if (n < 0) {
                n = JdbcUtils.getColumnIndex(resultSet, "SPECIFICNAME");
            }
            String string4 = procedureDefinition.getSpecificName();
            while (resultSet.next()) {
                String string5;
                String string6 = string5 = n > -1 ? resultSet.getString(n) : null;
                if (!StringUtil.equalString(string5, string4)) continue;
                this.processProcedureColumnResultRow(dataStore, resultSet, true);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "function parameters", string3, new Object[0]);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.closeResult(resultSet);
        return dataStore;
    }

    private boolean useJDBC() {
        return this.forceJDBC || this.connection.getDbSettings().getBoolProperty("procedurereader.use.jdbc", false);
    }

    private boolean useSQLFunctionsProc() {
        return this.connection.getDbSettings().getBoolProperty("functionparams.fixretrieval", true);
    }
}

