/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.ibm.Db2Variable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class Db2iVariableReader
implements ObjectListExtender {
    public static final String TYPE = "VARIABLE";

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList(TYPE);
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return TYPE.equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public DbObject getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<Db2Variable> list = this.getVariables(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isNonEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject instanceof Db2Variable) {
            return this.getSource(wbConnection, (Db2Variable)dbObject);
        }
        DbObject dbObject2 = this.getObjectDefinition(wbConnection, dbObject);
        if (dbObject2 != null) {
            return this.getSource(wbConnection, (Db2Variable)dbObject2);
        }
        return null;
    }

    private String getSource(WbConnection wbConnection, Db2Variable db2Variable) {
        try {
            return db2Variable.getSource(wbConnection).toString();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded(TYPE, stringArray)) {
            return false;
        }
        List<Db2Variable> list = this.getVariables(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (Db2Variable db2Variable : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)db2Variable.getSchema());
            dataStore.setValue(n, 0, (Object)db2Variable.getObjectName());
            dataStore.setValue(n, 1, (Object)db2Variable.getObjectType());
            dataStore.setValue(n, 4, (Object)db2Variable.getComment());
            dataStore.getRow(n).setUserObject(db2Variable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Db2Variable> getVariables(WbConnection wbConnection, String string, String string2) {
        String string3 = "SELECT variable_schema, variable_name, \n       case \n         when data_type in ('SMALLINT', 'INTEGER', 'INT', 'BIGINT') then data_type\n         when data_type in ('DECIMAL', 'DEC', 'NUMERIC', 'NUM') then data_type||'('||length||','||numeric_scale||')'\n         when data_type in ('FLOAT', 'DECFLOAT') then data_type||'('||numeric_precision||')'\n         else data_type||'('||length||')'\n       end as data_type,\n       ccsid, \n       default, \n       long_comment\nfrom qsys2" + wbConnection.getMetadata().getCatalogSeparator() + "sysvariables";
        ArrayList<Db2Variable> arrayList = new ArrayList<Db2Variable>();
        boolean bl = false;
        if (StringUtil.isNonBlank(string)) {
            string3 = string3 + "\nwhere ";
            bl = true;
            string3 = string.indexOf(37) > -1 ? string3 + "variable_schema LIKE '" + string + "' " : string3 + "variable_schema = '" + string + "' ";
        }
        if (StringUtil.isNonBlank(string2)) {
            string3 = bl ? string3 + "\n  AND " : string3 + "\nWHERE ";
            string3 = string2.indexOf(37) > -1 ? string3 + "variable_name LIKE '" + string2 + "' " : string3 + "variable_name = '" + string2 + "' ";
        }
        string3 = string3 + " ORDER BY variable_schema, variable_name ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "variables", string3, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("variable_schema");
                String string5 = resultSet.getString("variable_name");
                String string6 = resultSet.getString("long_comment");
                String string7 = resultSet.getString("data_type");
                String string8 = resultSet.getString("default");
                int n = resultSet.getInt("ccsid");
                Db2Variable db2Variable = new Db2Variable(string4, string5, string7);
                db2Variable.setCcsid(n);
                db2Variable.setDefaultValue(string8);
                db2Variable.setComment(string6);
                arrayList.add(db2Variable);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "variables", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }
}

