/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import workbench.db.ColumnIdentifier;
import workbench.db.importer.AbstractImportFileParser;
import workbench.db.importer.ImportFileColumn;
import workbench.db.importer.ParsingInterruptedException;
import workbench.interfaces.ImportFileParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public abstract class AbstractXmlDataFileParser
extends AbstractImportFileParser
implements ImportFileParser {
    protected SAXParser saxParser;
    protected Object[] currentRow;
    protected int currentRowNumber = 1;
    protected final List<String> missingColumns = new ArrayList<String>();
    protected String nullString;

    public AbstractXmlDataFileParser() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            sAXParserFactory.setValidating(false);
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error creating XML parser", exception);
        }
    }

    public AbstractXmlDataFileParser(File file) {
        this();
        this.inputFile = file;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String string) {
        this.nullString = StringUtil.trimToNull(string);
    }

    @Override
    public String getColumns() {
        return StringUtil.listToString((Collection)this.importColumns, ',', false);
    }

    @Override
    public String getLastRecord() {
        return null;
    }

    @Override
    public Map<Integer, Object> getInputColumnValues(Collection<Integer> collection) {
        return null;
    }

    public void setColumns(String string) throws SQLException {
        if (StringUtil.isNonBlank(string)) {
            WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(string, ",");
            ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
            while (wbStringTokenizer.hasMoreTokens()) {
                String string2 = wbStringTokenizer.nextToken();
                if (StringUtil.isBlank(string2) || (string2 = string2.trim()).length() == 0) continue;
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2);
                arrayList.add(columnIdentifier);
            }
            this.setColumns(arrayList);
        }
    }

    @Override
    public void setColumns(List<ColumnIdentifier> list) throws SQLException {
        if (CollectionUtil.isNonEmpty(list)) {
            this.importColumns = ImportFileColumn.createList();
            for (int i = 0; i < list.size(); ++i) {
                ColumnIdentifier columnIdentifier = list.get(i);
                if (columnIdentifier.getColumnName().equals("$wb_skip$")) continue;
                ImportFileColumn importFileColumn = new ImportFileColumn(columnIdentifier);
                importFileColumn.setTargetIndex(i);
                this.importColumns.add(importFileColumn);
            }
        } else {
            this.importColumns = null;
        }
    }

    private boolean doIncludeCurrentRow() {
        if (this.currentRow == null) {
            return false;
        }
        for (int i = 0; i < this.currentRow.length; ++i) {
            String string;
            Object object = this.currentRow[i];
            if (object == null || !this.isColumnFiltered(i, string = object.toString())) continue;
            return false;
        }
        return true;
    }

    protected void clearRowData() {
        if (this.currentRow != null) {
            Arrays.fill(this.currentRow, null);
        }
    }

    protected void sendRowData() throws SAXException, Exception {
        block7: {
            if (this.receiver != null) {
                try {
                    if (this.doIncludeCurrentRow()) {
                        this.receiver.processRow(this.currentRow);
                    }
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when sending row data to receiver", exception);
                    if (this.abortOnError) {
                        this.hasErrors = true;
                        throw exception;
                    }
                    this.hasWarnings = true;
                    if (this.errorHandler == null) break block7;
                    int n = this.errorHandler.getActionOnError(this.currentRowNumber + 1, null, null, ExceptionUtil.getDisplay(exception, false));
                    if (n == 3) {
                        throw exception;
                    }
                    if (n != 2) break block7;
                    this.abortOnError = false;
                }
            }
        }
        if (this.cancelImport) {
            throw new ParsingInterruptedException();
        }
    }

    public List<String> getMissingColumns() {
        return this.missingColumns;
    }
}

