/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.CycleErrorException;
import workbench.db.importer.TableDependencySorter;
import workbench.db.importer.TablenameResolver;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ImportFileLister {
    private List<WbFile> toProcess;
    private List<TableIdentifier> tables;
    private WbConnection dbConn;
    private TablenameResolver resolver;
    private boolean ignoreSchema;
    private WbFile sourceDir;
    private boolean checkDependencies;
    private String extension;

    public ImportFileLister(WbConnection wbConnection, File file2, String string) {
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException(file2 + " is not a directory");
        }
        if (StringUtil.isEmptyString(string)) {
            throw new IllegalArgumentException("Extension may not be empty");
        }
        this.toProcess = new ArrayList<WbFile>();
        this.dbConn = wbConnection;
        this.sourceDir = new WbFile(file2);
        this.extension = string.toLowerCase();
        FileFilter fileFilter = file -> {
            if (file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            if (string == null) {
                return false;
            }
            return string.toLowerCase().endsWith(this.extension);
        };
        Object[] objectArray = this.sourceDir.listFiles(fileFilter);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if (((File)object).length() > 0L) {
                this.toProcess.add(new WbFile((File)object));
                continue;
            }
            LogMgr.logWarning(new CallerInfo(){}, "Ignoring empty file: " + ((File)object).getAbsolutePath());
        }
        this.cleanupLobFiles();
    }

    public ImportFileLister(WbConnection wbConnection, File file, List<String> list) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        this.toProcess = new ArrayList<WbFile>();
        this.dbConn = wbConnection;
        this.sourceDir = new WbFile(file);
        for (String string : list) {
            WbFile wbFile = new WbFile(string);
            if (!wbFile.isAbsolute()) {
                wbFile = new WbFile(file, string);
            }
            if (!wbFile.exists()) {
                LogMgr.logWarning(new CallerInfo(){}, "Ignoring non existing file: " + wbFile.getAbsolutePath());
                continue;
            }
            if (wbFile.length() > 0L) {
                this.toProcess.add(new WbFile(wbFile));
                continue;
            }
            LogMgr.logWarning(new CallerInfo(){}, "Ignoring empty file: " + wbFile.getAbsolutePath());
        }
        this.cleanupLobFiles();
    }

    public ImportFileLister(WbConnection wbConnection, List<WbFile> list) {
        this.toProcess = new ArrayList<WbFile>();
        this.dbConn = wbConnection;
        this.sourceDir = new WbFile(list.get(0).getAbsoluteFile().getParentFile());
        for (WbFile wbFile : list) {
            if (wbFile.length() > 0L) {
                this.toProcess.add(wbFile);
                continue;
            }
            LogMgr.logWarning(new CallerInfo(){}, "Ignoring empty file: " + wbFile.getAbsolutePath());
        }
        this.cleanupLobFiles();
    }

    public ImportFileLister(WbConnection wbConnection, String string) {
        this.dbConn = wbConnection;
        this.toProcess = FileUtil.listFiles(string, null);
        this.cleanupLobFiles();
    }

    public int getFileCount() {
        return this.toProcess.size();
    }

    private void cleanupLobFiles() {
        Iterator<WbFile> iterator = this.toProcess.iterator();
        while (iterator.hasNext()) {
            WbFile wbFile;
            WbFile wbFile2 = iterator.next();
            String string = wbFile2.getFileName();
            if (!string.endsWith("_lobs") || !this.toProcess.contains(wbFile = new WbFile(wbFile2.getParent(), wbFile2.getName().replace("_lobs", "")))) continue;
            LogMgr.logDebug(new CallerInfo(){}, "Ignoring lob file: " + wbFile2.getFullPath());
            iterator.remove();
        }
    }

    public void setCheckDependencies(boolean bl) {
        this.checkDependencies = bl;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setTableNameResolver(TablenameResolver tablenameResolver) {
        this.resolver = tablenameResolver;
    }

    public boolean containsFiles() {
        return this.toProcess != null && this.toProcess.size() > 0;
    }

    public String getDirectory() {
        if (this.sourceDir == null) {
            return null;
        }
        return this.sourceDir.getFullPath();
    }

    public void ignoreFiles(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Iterator<WbFile> iterator = this.toProcess.iterator();
        TreeSet<WbFile> treeSet = new TreeSet<WbFile>();
        while (iterator.hasNext()) {
            WbFile wbFile = iterator.next();
            String string = wbFile.getName();
            for (String string2 : list) {
                if (!string.contains(string2)) continue;
                LogMgr.logDebug(new CallerInfo(){}, "Ignoring file: " + wbFile.getFullPath());
                treeSet.add(wbFile);
            }
        }
        this.toProcess.removeAll(treeSet);
    }

    public void setIgnoreSchema(boolean bl) {
        this.ignoreSchema = bl;
    }

    public List<TableIdentifier> getTableList() {
        if (this.tables == null) {
            return null;
        }
        return Collections.unmodifiableList(this.tables);
    }

    public List<WbFile> getFiles() throws CycleErrorException {
        if (this.checkDependencies) {
            return this.getSortedList();
        }
        return this.toProcess;
    }

    public TableIdentifier getTableForFile(WbFile wbFile) {
        String string = this.resolver.getTableName(wbFile);
        TableIdentifier tableIdentifier = new TableIdentifier(string);
        if (this.ignoreSchema) {
            tableIdentifier.setSchema(null);
            tableIdentifier.setCatalog(null);
        }
        return tableIdentifier;
    }

    protected List<WbFile> getSortedList() throws CycleErrorException {
        Serializable serializable;
        TreeMap<String, WbFile> treeMap = new TreeMap<String, WbFile>(CaseInsensitiveComparator.INSTANCE);
        this.tables = new ArrayList<TableIdentifier>();
        for (WbFile object2 : this.toProcess) {
            serializable = this.getTableForFile(object2);
            this.tables.add((TableIdentifier)serializable);
            treeMap.put(((TableIdentifier)serializable).getTableExpression(), object2);
        }
        TableDependencySorter tableDependencySorter = new TableDependencySorter(this.dbConn);
        List<TableIdentifier> list = tableDependencySorter.sortForInsert(this.tables);
        if (tableDependencySorter.hasErrors()) {
            throw new CycleErrorException(tableDependencySorter.getErrorTables().get(0));
        }
        serializable = new ArrayList();
        for (TableIdentifier tableIdentifier : list) {
            WbFile wbFile = (WbFile)treeMap.get(tableIdentifier.getTableName());
            if (wbFile == null) {
                wbFile = (WbFile)treeMap.get(tableIdentifier.getTableExpression(this.dbConn));
            }
            if (wbFile == null) continue;
            serializable.add(wbFile);
        }
        return serializable;
    }
}

