/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.importer.AbstractImportFileParser;
import workbench.db.importer.ImportFileColumn;
import workbench.db.importer.SpreadsheetReader;
import workbench.db.importer.TableDependencySorter;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.TabularDataParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SpreadsheetFileParser
extends AbstractImportFileParser
implements TabularDataParser,
ScriptGenerationMonitor {
    private File baseDir;
    private boolean withHeader = true;
    private boolean emptyStringIsNull;
    private boolean illegalDateIsNull;
    private boolean checkDependencies;
    private boolean ignoreOwner;
    private boolean readDatesAsStrings;
    private boolean recalcFormulas = true;
    private String nullString;
    private int currentRow;
    private int sheetIndex;
    private String sheetName;
    private SpreadsheetReader reader;
    protected List<Object> dataRowValues;
    private TableDependencySorter tableSorter;
    private boolean tableNameSpecified;

    public SpreadsheetFileParser() {
        this.converter.setCheckBuiltInFormats(false);
        this.converter.setDefaultTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.converter.setDefaultDateFormat("yyyy-MM-dd");
    }

    @Override
    public void setTableName(String string) {
        super.setTableName(string);
        this.tableNameSpecified = StringUtil.isNonBlank(string);
    }

    public void setRecalcFormulas(boolean bl) {
        this.recalcFormulas = bl;
    }

    public void setReadDatesAsStrings(boolean bl) {
        this.readDatesAsStrings = bl;
    }

    public void setIgnoreOwner(boolean bl) {
        this.ignoreOwner = bl;
    }

    public void setCheckDependencies(boolean bl) {
        this.checkDependencies = bl;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }

    public void setIllegalDateIsNull(boolean bl) {
        this.illegalDateIsNull = bl;
    }

    public boolean getContainsHeader() {
        return this.withHeader;
    }

    public void setSheetIndex(int n) {
        this.sheetIndex = n;
        this.sheetName = null;
    }

    public void setSheetName(String string) {
        this.sheetName = string;
        this.sheetIndex = -1;
    }

    @Override
    public void setContainsHeader(boolean bl) {
        this.withHeader = bl;
    }

    @Override
    public void setColumns(List<ColumnIdentifier> list) throws SQLException {
        this.setColumns(list, null);
    }

    @Override
    public void setInputFile(File file) {
        super.setInputFile(file);
        if (this.reader != null) {
            this.reader.done();
            this.reader = null;
        }
    }

    @Override
    public void setColumns(List<ColumnIdentifier> list, List<ColumnIdentifier> list2) throws SQLException {
        TableDefinition tableDefinition = this.getTargetTable();
        List<ColumnIdentifier> list3 = null;
        list3 = tableDefinition == null ? new ArrayList<ColumnIdentifier>(list) : tableDefinition.getColumns();
        this.importColumns = ImportFileColumn.createList();
        int n = 0;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        try {
            for (ColumnIdentifier object : list) {
                Object object2;
                boolean bl = object.getColumnName().equalsIgnoreCase("$wb_skip$");
                if (!bl && !list2.isEmpty()) {
                    bl = !list2.contains(object);
                }
                int n2 = list3.indexOf(object);
                if (!bl && n2 < 0) {
                    if (this.abortOnError && !this.ignoreMissingColumns) {
                        object2 = ResourceMgr.getFormattedString("ErrImportColumnNotFound", object.getColumnName(), this.getSourceFilename(), this.tableName);
                        this.messages.append((CharSequence)object2);
                        this.messages.appendNewLine();
                        this.hasErrors = true;
                        throw new SQLException((String)object2);
                    }
                    object2 = ResourceMgr.getFormattedString("ErrImportColumnIgnored", object.getColumnName(), this.getSourceFilename(), this.tableName);
                    LogMgr.logWarning(new CallerInfo(){}, (CharSequence)object2);
                    this.hasWarnings = true;
                    this.messages.append((CharSequence)object2);
                    this.messages.appendNewLine();
                    bl = true;
                }
                if (bl) {
                    object2 = new ImportFileColumn(object);
                    ((ImportFileColumn)object2).setTargetIndex(-1);
                    this.importColumns.add(object2);
                    continue;
                }
                object2 = list3.get(n2);
                ImportFileColumn importFileColumn = new ImportFileColumn((ColumnIdentifier)object2);
                importFileColumn.setTargetIndex(n);
                this.importColumns.add(importFileColumn);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            this.hasErrors = true;
            throw sQLException;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when setting column definition", exception);
            this.importColumns = null;
        }
        if (n == 0) {
            String string = ResourceMgr.getFormattedString("ErrImportNoColumns", this.tableName, this.getSourceFilename());
            this.hasErrors = true;
            this.messages.append(string);
            this.messages.appendNewLine();
            this.importColumns = null;
            String string2 = "No column in table " + tableDefinition + " matched the columns in the file: " + this.getSourceFilename();
            LogMgr.logError(new CallerInfo(){}, string2, null);
            throw new SQLException(string2);
        }
    }

    @Override
    public Map<Integer, Object> getInputColumnValues(Collection<Integer> collection) {
        if (this.dataRowValues == null) {
            return null;
        }
        if (collection == null) {
            return null;
        }
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>(collection.size());
        for (Integer n : collection) {
            if (n <= 0 || n > this.dataRowValues.size()) continue;
            hashMap.put(n, this.dataRowValues.get(n - 1));
        }
        return hashMap;
    }

    @Override
    public String getLastRecord() {
        if (this.currentRow < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        List<Object> list = this.reader.getRowValues(this.currentRow);
        boolean bl = true;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        for (Object object : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = null;
            string = object instanceof Date ? simpleDateFormat.format((Date)object) : (object instanceof Timestamp ? simpleDateFormat2.format((Timestamp)object) : (object != null ? object.toString() : ""));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSourceFilename() {
        if (this.inputFile == null) {
            return "";
        }
        String string = this.inputFile.getAbsolutePath();
        if (this.reader == null) {
            return string;
        }
        String string2 = this.sheetName;
        if (string2 == null && this.sheetIndex > -1) {
            List<String> list = this.reader.getSheets();
            string2 = this.sheetIndex < list.size() ? list.get(this.sheetIndex) : Integer.toString(this.sheetIndex);
        }
        string = string + ":" + string2;
        return string;
    }

    private void createReader() throws IOException {
        if (this.reader == null) {
            this.reader = SpreadsheetReader.Factory.createReader(this.inputFile, this.sheetIndex, this.sheetName);
            this.reader.setEmptyStringIsNull(this.emptyStringIsNull);
            this.reader.setReturnDatesAsString(this.readDatesAsStrings);
            this.reader.enableRecalcOnLoad(this.recalcFormulas);
            if (this.sheetIndex < 0 && StringUtil.isNonBlank(this.sheetName)) {
                this.reader.setActiveWorksheet(this.sheetName);
            }
            this.reader.load();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.tableSorter != null) {
            this.tableSorter.cancel();
        }
    }

    private List<Integer> getSheets() {
        List<String> list = this.reader.getSheets();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        if (this.checkDependencies) {
            TableIdentifier tableIdentifier;
            if (this.rowMonitor != null) {
                this.rowMonitor.saveCurrentType("spreadsheet-deps");
                this.rowMonitor.setMonitorType(7);
            }
            LogMgr.logDebug(new CallerInfo(){}, "Evaluating tables to import");
            this.tableSorter = new TableDependencySorter(this.connection);
            this.tableSorter.setProgressMonitor(this);
            ArrayList<TableIdentifier> arrayList2 = new ArrayList<TableIdentifier>(list.size());
            for (String object2 : list) {
                DbObjectFinder n;
                TableIdentifier tableIdentifier2;
                tableIdentifier = new TableIdentifier(object2);
                if (this.cancelImport) break;
                if (this.ignoreOwner) {
                    tableIdentifier.setSchema(null);
                    tableIdentifier.setCatalog(null);
                }
                if ((tableIdentifier2 = (n = new DbObjectFinder(this.connection)).findObject(tableIdentifier)) != null) {
                    arrayList2.add(tableIdentifier2);
                    continue;
                }
                LogMgr.logWarning(new CallerInfo(){}, "Could not find table " + object2);
            }
            List<TableIdentifier> list2 = this.tableSorter.sortForInsert(arrayList2);
            LogMgr.logDebug(new CallerInfo(){}, "Using insert sequence: " + list2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                tableIdentifier = (TableIdentifier)iterator.next();
                int n = this.findSheet(tableIdentifier, list);
                arrayList.add(n);
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
                this.rowMonitor.restoreType("spreadsheet-deps");
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(i);
            }
        }
        this.tableSorter = null;
        return arrayList;
    }

    private int findSheet(TableIdentifier tableIdentifier, List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            TableIdentifier tableIdentifier2 = new TableIdentifier(list.get(i));
            if (this.ignoreOwner) {
                tableIdentifier2.setSchema(null);
                tableIdentifier2.setCatalog(null);
            }
            if (!tableIdentifier2.compareNames(tableIdentifier)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processOneFile() throws Exception {
        if (this.inputFile.isAbsolute()) {
            this.baseDir = this.inputFile.getParentFile();
        }
        if (this.baseDir == null) {
            this.baseDir = new File(".");
        }
        this.createReader();
        this.reader.setNullString(this.nullString);
        try {
            if (this.sheetIndex != -1 || this.sheetName != null) {
                if (this.sheetName != null) {
                    this.reader.setActiveWorksheet(this.sheetName);
                } else if (this.sheetIndex > -1) {
                    this.reader.setActiveWorksheet(this.sheetIndex);
                }
                this.processOneSheet();
            } else {
                this.receiver.beginMultiTable();
                List<Integer> list = this.getSheets();
                List<String> list2 = this.reader.getSheets();
                for (Integer n : list) {
                    TableIdentifier tableIdentifier;
                    DbObjectFinder dbObjectFinder;
                    this.sheetIndex = n;
                    this.sheetName = list2.get(this.sheetIndex);
                    this.importColumns = null;
                    if (!this.tableNameSpecified) {
                        this.tableName = this.sheetName;
                        this.targetTable = null;
                    }
                    if ((dbObjectFinder = new DbObjectFinder(this.connection)).tableExists(tableIdentifier = this.createTargetTableId())) {
                        this.reader.setActiveWorksheet(this.sheetIndex);
                        this.processOneSheet();
                        continue;
                    }
                    String string = ResourceMgr.getFormattedString("ErrImportSheetIgnored", this.sheetName);
                    this.messages.append(string);
                    this.messages.appendNewLine();
                    this.hasWarnings = true;
                    LogMgr.logWarning(new CallerInfo(){}, "Ignoring table " + this.tableName + " because it was not found in the target database.");
                }
            }
        }
        finally {
            this.done();
        }
    }

    protected void processOneSheet() throws Exception {
        if (this.withHeader && this.importColumns == null) {
            this.setupFileColumns(null);
        }
        if (!this.withHeader && this.importColumns == null) {
            this.setColumns(this.getTargetTable().getColumns(), null);
        }
        if (CollectionUtil.isEmpty(this.importColumns)) {
            throw new Exception("Cannot import file without a column definition");
        }
        List<ColumnIdentifier> list = this.getColumnsToImport();
        try {
            this.receiver.setTargetTable(this.targetTable != null ? this.targetTable.getTable() : null, list, this.inputFile);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error setting target table", exception);
            throw exception;
        }
        Object[] objectArray = new Object[list.size()];
        int n = this.withHeader ? 1 : 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = this.importColumns.size();
        this.converter.setIllegalDateIsNull(this.illegalDateIsNull);
        long l = this.reader.getRowCount();
        this.currentRow = n;
        while ((long)this.currentRow < l) {
            Arrays.fill(objectArray, null);
            if (this.cancelImport) break;
            boolean bl2 = this.receiver.shouldProcessNextRow();
            if (!bl2) {
                this.receiver.nextRowSkipped();
            } else {
                ++n2;
                this.dataRowValues = this.reader.getRowValues(this.currentRow);
                if (this.dataRowValues.isEmpty()) {
                    this.receiver.nextRowSkipped();
                } else if (this.dataRowValues.size() < objectArray.length) {
                    String string = ResourceMgr.getFormattedString("ErrImpIgnoreShortRow", this.currentRow, this.dataRowValues.size(), objectArray.length);
                    this.messages.append(string);
                    this.messages.appendNewLine();
                } else {
                    int n4 = -1;
                    for (int i = 0; i < n3; ++i) {
                        ImportFileColumn importFileColumn = (ImportFileColumn)this.importColumns.get(i);
                        if (importFileColumn == null || (n4 = importFileColumn.getTargetIndex()) == -1) continue;
                        if (i >= this.dataRowValues.size()) {
                            if (n2 != 1) continue;
                            LogMgr.logWarning(new CallerInfo(){}, "Ignoring column with index=" + (i + 1) + " because the import file has fewer columns");
                            continue;
                        }
                        Object object = this.dataRowValues.get(i);
                        String string = object != null ? object.toString() : null;
                        ColumnIdentifier columnIdentifier = importFileColumn.getColumn();
                        int n5 = columnIdentifier.getDataType();
                        bl = true;
                        try {
                            if (this.isColumnFiltered(i, string)) {
                                bl = false;
                                break;
                            }
                            if (this.valueModifier != null) {
                                object = this.valueModifier.modifyValue(columnIdentifier, string);
                            }
                            if (SqlUtil.isCharacterType(n5)) {
                                if (this.emptyStringIsNull && StringUtil.isEmptyString(string)) {
                                    object = null;
                                }
                                objectArray[n4] = object;
                                continue;
                            }
                            objectArray[n4] = this.converter.convertValue(object, n5);
                            continue;
                        }
                        catch (Exception exception) {
                            if (n4 != -1) {
                                objectArray[n4] = null;
                            }
                            String string2 = ResourceMgr.getString("ErrConvertError");
                            string2 = string2.replace("%row%", Integer.toString(n2));
                            string2 = string2.replace("%column%", importFileColumn == null ? "n/a" : importFileColumn.getColumn().getColumnName());
                            string2 = string2.replace("%value%", string == null ? "(NULL)" : string);
                            string2 = string2.replace("%msg%", exception.getClass().getName() + ": " + ExceptionUtil.getDisplay(exception, false));
                            string2 = string2.replace("%type%", SqlUtil.getTypeName(n5));
                            string2 = string2.replace("%error%", exception.getMessage());
                            this.messages.append(string2);
                            this.messages.appendNewLine();
                            if (this.abortOnError) {
                                this.hasErrors = true;
                                this.cancelImport = true;
                                throw exception;
                            }
                            this.hasWarnings = true;
                            LogMgr.logWarning(new CallerInfo(){}, string2, exception);
                            if (this.errorHandler != null) {
                                int n6 = this.errorHandler.getActionOnError(n2, importFileColumn.getColumn().getColumnName(), string == null ? "(NULL)" : string, ExceptionUtil.getDisplay(exception, false));
                                if (n6 == 3) {
                                    throw exception;
                                }
                                if (n6 == 2) {
                                    this.abortOnError = false;
                                }
                            }
                            this.receiver.recordRejected(this.getLastRecord(), n2, exception);
                            bl = false;
                        }
                    }
                    if (this.cancelImport) break;
                    if (this.ignoreAllNullRows && this.isOnlyNull(objectArray)) {
                        this.receiver.nextRowSkipped();
                    } else {
                        try {
                            if (bl) {
                                this.receiver.processRow(objectArray);
                            }
                        }
                        catch (Exception exception) {
                            if (this.cancelImport) {
                                LogMgr.logDebug(new CallerInfo(){}, "Error sending line " + n2, exception);
                            }
                            this.hasErrors = true;
                            this.cancelImport = true;
                            LogMgr.logError(new CallerInfo(){}, "Error sending line " + n2, exception);
                            throw exception;
                        }
                    }
                }
            }
            ++this.currentRow;
        }
        this.filesProcessed.add(this.inputFile);
        if (!this.cancelImport) {
            this.receiver.tableImportFinished();
        }
    }

    @Override
    public void done() {
        if (this.reader != null) {
            this.reader.done();
            this.reader = null;
        }
    }

    @Override
    public List<ColumnIdentifier> getColumnsFromFile() {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        try {
            this.createReader();
            List<String> list = this.reader.getHeaderColumns();
            for (String string : list) {
                arrayList.add(new ColumnIdentifier(string));
            }
            this.messages.append(this.reader.getMessages());
        }
        catch (Exception exception) {
            this.hasErrors = true;
            LogMgr.logError(new CallerInfo(){}, "Error when reading columns", exception);
        }
        return arrayList;
    }

    @Override
    public void checkTargetTable() throws SQLException {
        TableDefinition tableDefinition = this.getTargetTable();
        if (tableDefinition == null || tableDefinition.getColumns().isEmpty()) {
            TableIdentifier tableIdentifier = this.createTargetTableId();
            String string = ResourceMgr.getFormattedString("ErrTargetTableNotFound", tableIdentifier.getTableExpression());
            this.messages.append(string);
            this.messages.appendNewLine();
            this.importColumns = null;
            this.hasErrors = true;
            throw new SQLException("Table " + tableIdentifier.getTableExpression() + " not found!");
        }
    }

    @Override
    public void setupFileColumns(List<ColumnIdentifier> list) throws SQLException, IOException {
        List<ColumnIdentifier> list2 = null;
        if (this.withHeader) {
            list2 = this.getColumnsFromFile();
        } else {
            TableDefinition tableDefinition = this.getTargetTable();
            list2 = tableDefinition.getColumns();
        }
        this.setColumns(list2, list);
    }

    public int getColumnCount() {
        return this.importColumns.size();
    }

    List<ImportFileColumn> getImportColumns() {
        return this.importColumns;
    }

    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
        if (this.reader != null) {
            this.reader.setEmptyStringIsNull(bl);
        }
    }

    @Override
    public void setCurrentObject(String string, int n, int n2) {
        if (this.rowMonitor != null) {
            String string2 = ResourceMgr.getFormattedString("MsgCalcDependencies", string);
            this.rowMonitor.setCurrentObject(string2, n, n2);
        }
    }
}

