/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.importer.AbstractImportFileParser;
import workbench.db.importer.ImportFileColumn;
import workbench.db.importer.StreamImporter;
import workbench.db.importer.TextImportOptions;
import workbench.interfaces.TabularDataParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.CsvLineParser;
import workbench.util.CsvLineReader;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.FixedLengthLineParser;
import workbench.util.LineParser;
import workbench.util.QuoteEscapeType;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class TextFileParser
extends AbstractImportFileParser
implements TextImportOptions,
TabularDataParser {
    public static final String DEFAULT_DELIMITER = "\t";
    private File baseDir;
    private String delimiter = "\t";
    private String quoteChar;
    private boolean decodeUnicode;
    private boolean enableMultiLineMode;
    private boolean withHeader = true;
    private boolean emptyStringIsNull;
    private boolean alwaysQuoted;
    private boolean illegalDateIsNull;
    private Pattern lineFilter;
    private boolean fixedWidthImport;
    private String currentLine;
    private QuoteEscapeType quoteEscape;
    private StreamImporter streamImporter;
    private String nullString;

    public TextFileParser() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.import.text.dateformat.checkbuiltin", false);
        this.converter.setCheckBuiltInFormats(bl);
    }

    public TextFileParser(File file) {
        this();
        this.inputFile = file;
    }

    @Override
    public String getNullString() {
        return this.nullString;
    }

    @Override
    public void setNullString(String string) {
        this.nullString = string;
    }

    public void setEnableMultilineRecords(boolean bl) {
        this.enableMultiLineMode = bl;
    }

    @Override
    public QuoteEscapeType getQuoteEscaping() {
        return this.quoteEscape;
    }

    @Override
    public boolean getQuoteAlways() {
        return this.alwaysQuoted;
    }

    public void setAlwaysQuoted(boolean bl) {
        this.alwaysQuoted = bl;
    }

    public void setQuoteEscaping(QuoteEscapeType quoteEscapeType) {
        this.quoteEscape = quoteEscapeType;
    }

    public void setLineFilter(String string) {
        try {
            this.lineFilter = Pattern.compile(string);
        }
        catch (Exception exception) {
            this.lineFilter = null;
            String string2 = ResourceMgr.getString("ErrImportBadRegex");
            string2 = StringUtil.replace(string2, "%regex%", string);
            this.messages.append(string2);
            this.messages.appendNewLine();
            this.hasWarnings = true;
            LogMgr.logError(new CallerInfo(){}, "Error compiling regular expression " + string, exception);
        }
    }

    public void setIllegalDateIsNull(boolean bl) {
        this.illegalDateIsNull = bl;
    }

    public void setTreatClobAsFilenames(boolean bl) {
        this.clobsAreFilenames = bl;
    }

    @Override
    public void setColumns(List<ColumnIdentifier> list) throws SQLException {
        this.setColumns(list, null);
    }

    @Override
    public void setColumns(List<ColumnIdentifier> list, List<ColumnIdentifier> list2) throws SQLException {
        TableDefinition tableDefinition = this.getTargetTable();
        List<ColumnIdentifier> list3 = null;
        list3 = tableDefinition == null ? new ArrayList<ColumnIdentifier>(list) : tableDefinition.getColumns();
        this.importColumns = ImportFileColumn.createList();
        int n = 0;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            for (ColumnIdentifier object : list) {
                Object object2;
                boolean bl = object.getColumnName().equalsIgnoreCase("$wb_skip$");
                if (!bl && !list2.isEmpty()) {
                    bl = !list2.contains(object);
                }
                int n2 = list3.indexOf(object);
                if (!bl && n2 < 0) {
                    if (this.abortOnError && !this.ignoreMissingColumns) {
                        object2 = ResourceMgr.getFormattedString("ErrImportColumnNotFound", object.getColumnName(), this.getSourceFilename(), this.tableName) + "\n";
                        this.messages.append((CharSequence)object2);
                        this.hasErrors = true;
                        throw new SQLException((String)object2);
                    }
                    object2 = ResourceMgr.getFormattedString("ErrImportColumnIgnored", object.getColumnName(), this.getSourceFilename(), this.tableName) + "\n";
                    LogMgr.logWarning(new CallerInfo(){}, (CharSequence)object2);
                    this.hasWarnings = true;
                    arrayList.add(object2);
                    bl = true;
                }
                if (bl) {
                    object2 = new ImportFileColumn(object);
                    ((ImportFileColumn)object2).setTargetIndex(-1);
                    this.importColumns.add(object2);
                    continue;
                }
                object2 = list3.get(n2);
                ImportFileColumn importFileColumn = new ImportFileColumn((ColumnIdentifier)object2);
                importFileColumn.setTargetIndex(n);
                this.importColumns.add(importFileColumn);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            this.hasErrors = true;
            throw sQLException;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when setting column definition", exception);
            this.importColumns = null;
        }
        if (arrayList.size() > 0) {
            this.messages.appendNewLine();
            for (String string : arrayList) {
                this.messages.append(string);
            }
        }
        if (n == 0) {
            String string = ResourceMgr.getFormattedString("ErrImportNoColumns", this.tableName, this.getSourceFilename()) + "\n";
            this.hasErrors = true;
            this.messages.append(string);
            this.importColumns = null;
            throw new SQLException("No column matched in import file");
        }
    }

    public void setColumnWidths(Map<ColumnIdentifier, Integer> map) {
        if (map == null) {
            return;
        }
        if (this.importColumns == null) {
            throw new IllegalArgumentException("No columns defined!");
        }
        this.delimiter = null;
        for (Map.Entry<ColumnIdentifier, Integer> entry : map.entrySet()) {
            ImportFileColumn importFileColumn;
            int n = this.importColumns.indexOf(entry.getKey());
            if (n == -1 || (importFileColumn = (ImportFileColumn)this.importColumns.get(n)) == null) continue;
            importFileColumn.setDataWidth(entry.getValue());
        }
        this.fixedWidthImport = true;
    }

    @Override
    public Map<Integer, Object> getInputColumnValues(Collection<Integer> collection) {
        if (this.currentRowValues == null) {
            return null;
        }
        if (collection == null) {
            return null;
        }
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>(collection.size());
        for (Integer n : collection) {
            if (n <= 0 || n > this.currentRowValues.size()) continue;
            hashMap.put(n, this.currentRowValues.get(n - 1));
        }
        return hashMap;
    }

    protected List<Integer> getColumnWidths() {
        if (this.importColumns == null) {
            return null;
        }
        if (!this.fixedWidthImport) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (ImportFileColumn importFileColumn : this.importColumns) {
            if (importFileColumn.getDataWidth() <= -1) continue;
            arrayList.add(importFileColumn.getDataWidth());
        }
        return arrayList;
    }

    @Override
    public String getTextDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setTextDelimiter(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        this.delimiter = string;
        if (this.delimiter.contains("\\t")) {
            this.delimiter = this.delimiter.replace("\\t", DEFAULT_DELIMITER);
        }
    }

    @Override
    public boolean getContainsHeader() {
        return this.withHeader;
    }

    @Override
    public void setContainsHeader(boolean bl) {
        this.withHeader = bl;
    }

    @Override
    public String getTextQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public void setTextQuoteChar(String string) {
        this.quoteChar = StringUtil.isNonBlank(string) ? string : null;
    }

    @Override
    public String getLastRecord() {
        return this.currentLine;
    }

    public void setStreamImporter(StreamImporter streamImporter) {
        this.streamImporter = streamImporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCompleteFile(List<ColumnIdentifier> list, String string) throws Exception {
        try {
            BufferedReader bufferedReader = this.fileHandler.getMainFileReader();
            this.streamImporter.setup(this.targetTable.getTable(), list, bufferedReader, this, string);
            this.receiver.processFile(this.streamImporter);
        }
        finally {
            this.fileHandler.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processOneFile() throws Exception {
        if (this.inputFile.isAbsolute()) {
            this.baseDir = this.inputFile.getParentFile();
        }
        if (this.baseDir == null) {
            this.baseDir = new File(".");
        }
        this.blobDecoder.setBaseDir(this.baseDir);
        this.setupFileHandler();
        if (!this.withHeader && this.importColumns == null) {
            this.setColumns(this.getTargetTable().getColumns(), null);
        }
        BufferedReader bufferedReader = this.fileHandler.getMainFileReader();
        String string = StringUtil.LINE_TERMINATOR;
        if (this.enableMultiLineMode) {
            try {
                string = FileUtil.getLineEnding(bufferedReader);
                if (string == null) {
                    string = StringUtil.LINE_TERMINATOR;
                }
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, "Could not read line ending from file. Multi-line mode disabled!", iOException);
                this.messages.append(ResourceMgr.getString("ErrNoMultiLine"));
                this.enableMultiLineMode = false;
            }
            LogMgr.logInfo(new CallerInfo(){}, "Using line ending: " + StringUtil.escapeText(string, CharacterRange.RANGE_CONTROL));
            bufferedReader.close();
            this.setupFileHandler();
            bufferedReader = this.fileHandler.getMainFileReader();
        }
        char c = this.quoteChar == null ? (char)'\u0000' : this.quoteChar.charAt(0);
        CsvLineReader csvLineReader = new CsvLineReader(bufferedReader, c, this.quoteEscape, this.enableMultiLineMode, string);
        csvLineReader.setIgnoreEmptyLines(true);
        this.currentLine = null;
        long l = 0L;
        try {
            this.currentLine = csvLineReader.readLine();
            ++l;
            if (this.withHeader) {
                if (this.currentLine == null) {
                    this.hasErrors = true;
                    String string2 = ResourceMgr.getFormattedString("ErrImportNoHeader", this.getSourceFilename()) + "\n";
                    this.messages.appendNewLine();
                    this.messages.append(string2);
                    throw new IOException("Could not read header line from " + this.getSourceFilename());
                }
                if (this.importColumns == null) {
                    this.readColumns(this.currentLine);
                }
                this.currentLine = csvLineReader.readLine();
            }
        }
        catch (EOFException eOFException) {
            this.currentLine = null;
        }
        catch (IOException iOException) {
            LogMgr.logWarning(new CallerInfo(){}, "Error reading input file " + this.inputFile.getAbsolutePath(), iOException);
            FileUtil.closeQuietely(bufferedReader);
            throw iOException;
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Column definition could not be read.", sQLException);
            FileUtil.closeQuietely(bufferedReader);
            throw sQLException;
        }
        if (CollectionUtil.isEmpty(this.importColumns)) {
            throw new Exception("Cannot import file without a column definition");
        }
        List<ColumnIdentifier> list = this.getColumnsToImport();
        try {
            this.receiver.setTargetTable(this.targetTable != null ? this.targetTable.getTable() : null, list, this.inputFile);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error setting target table", exception);
            throw exception;
        }
        if (this.streamImporter != null) {
            FileUtil.closeQuietely(bufferedReader);
            this.sendCompleteFile(list, this.fileHandler.getEncoding());
            return;
        }
        Object[] objectArray = new Object[list.size()];
        int n = 0;
        LineParser lineParser = null;
        if (this.fixedWidthImport) {
            lineParser = new FixedLengthLineParser(this.getColumnWidths());
        } else {
            CsvLineParser csvLineParser = new CsvLineParser(this.delimiter, c);
            csvLineParser.setReturnEmptyStrings(true);
            csvLineParser.setUnquotedEmptyStringIsNull(this.alwaysQuoted);
            csvLineParser.setQuoteEscaping(this.quoteEscape);
            lineParser = csvLineParser;
        }
        this.converter.setIllegalDateIsNull(this.illegalDateIsNull);
        lineParser.setTrimValues(this.trimValues);
        int n2 = this.importColumns.size();
        try {
            boolean bl;
            boolean bl2 = true;
            boolean bl3 = bl = this.lineFilter != null;
            while (this.currentLine != null && !this.cancelImport) {
                boolean bl4 = this.receiver.shouldProcessNextRow();
                if (!bl4) {
                    this.receiver.nextRowSkipped();
                }
                if (bl && bl4) {
                    Matcher matcher = this.lineFilter.matcher(this.currentLine);
                    bl4 = matcher.find();
                }
                ++n;
                if (!bl4) {
                    try {
                        this.currentLine = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        LogMgr.logError(new CallerInfo(){}, "Error reading source file", iOException);
                        this.currentLine = null;
                    }
                    continue;
                }
                this.currentRowValues = this.getLineValues(lineParser, this.currentLine);
                bl2 = true;
                int n3 = -1;
                Arrays.fill(objectArray, null);
                for (int i = 0; i < n2; ++i) {
                    ImportFileColumn importFileColumn = (ImportFileColumn)this.importColumns.get(i);
                    if (importFileColumn == null || (n3 = importFileColumn.getTargetIndex()) == -1) continue;
                    if (i >= this.currentRowValues.size()) {
                        if (n != 1) continue;
                        LogMgr.logWarning(new CallerInfo(){}, "Ignoring column with index=" + (i + 1) + " because the import file has fewer columns");
                        continue;
                    }
                    String string3 = (String)this.currentRowValues.get(i);
                    if (this.emptyStringIsNull && string3 != null && string3.isEmpty()) {
                        string3 = null;
                    }
                    try {
                        ColumnIdentifier columnIdentifier = importFileColumn.getColumn();
                        int n4 = columnIdentifier.getDataType();
                        String string4 = columnIdentifier.getDbmsType();
                        if (this.isColumnFiltered(i, string3)) {
                            bl2 = false;
                            break;
                        }
                        if (this.valueModifier != null) {
                            string3 = this.valueModifier.modifyValue(columnIdentifier, string3);
                        }
                        if (SqlUtil.isCharacterType(n4) || SqlUtil.isXMLType(n4, string4)) {
                            if (this.clobsAreFilenames && string3 != null && (SqlUtil.isClobType(n4, string4, this.connection.getDbSettings()) || SqlUtil.isXMLType(n4, string4))) {
                                File file = new File(string3);
                                if (!file.isAbsolute()) {
                                    file = new File(this.baseDir, string3);
                                }
                                objectArray[n3] = file;
                                continue;
                            }
                            if (this.decodeUnicode) {
                                string3 = StringUtil.decodeUnicode(string3);
                            }
                            objectArray[n3] = string3;
                            continue;
                        }
                        if (SqlUtil.isBlobType(n4)) {
                            objectArray[n3] = this.blobDecoder.decodeBlob(string3, this.getBlobMode(columnIdentifier.getColumnName()));
                            continue;
                        }
                        objectArray[n3] = this.converter.convertValue(string3, n4);
                        continue;
                    }
                    catch (Exception exception) {
                        if (n3 != -1) {
                            objectArray[n3] = null;
                        }
                        String string5 = ResourceMgr.getString("ErrTextfileImport");
                        string5 = string5.replace("%row%", Integer.toString(n));
                        string5 = string5.replace("%col%", importFileColumn.getColumn().getColumnName());
                        string5 = string5.replace("%value%", string3 == null ? "(NULL)" : string3);
                        string5 = string5.replace("%msg%", exception.getClass().getName() + ": " + ExceptionUtil.getDisplay(exception, false));
                        this.messages.append(string5);
                        this.messages.appendNewLine();
                        if (this.abortOnError) {
                            this.hasErrors = true;
                            this.cancelImport = true;
                            throw exception;
                        }
                        this.hasWarnings = true;
                        LogMgr.logWarning(new CallerInfo(){}, string5, exception);
                        if (this.errorHandler != null) {
                            int n5 = this.errorHandler.getActionOnError(n, importFileColumn.getColumn().getColumnName(), string3 == null ? "(NULL)" : string3, ExceptionUtil.getDisplay(exception, false));
                            if (n5 == 3) {
                                throw exception;
                            }
                            if (n5 == 2) {
                                this.abortOnError = false;
                            }
                        }
                        this.receiver.recordRejected(this.currentLine, l, exception);
                        bl2 = false;
                    }
                }
                if (this.cancelImport) break;
                if (bl2 && this.ignoreAllNullRows && this.isOnlyNull(objectArray)) {
                    this.receiver.nextRowSkipped();
                    bl2 = false;
                }
                try {
                    if (bl2) {
                        this.receiver.processRow(objectArray);
                    }
                }
                catch (Exception exception) {
                    if (this.cancelImport) {
                        LogMgr.logDebug(new CallerInfo(){}, "Error sending line " + n, exception);
                    }
                    this.hasErrors = true;
                    this.cancelImport = true;
                    LogMgr.logError(new CallerInfo(){}, "Error sending line " + n, exception);
                    throw exception;
                }
                try {
                    this.currentLine = csvLineReader.readLine();
                }
                catch (IOException iOException) {
                    LogMgr.logError(new CallerInfo(){}, "Error reading source file", iOException);
                    this.currentLine = null;
                }
            }
            this.filesProcessed.add(this.inputFile);
            if (!this.cancelImport) {
                this.receiver.tableImportFinished();
            }
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
            this.fileHandler.done();
        }
    }

    @Override
    public void done() {
        if (this.fileHandler != null) {
            this.fileHandler.done();
        }
    }

    protected List<String> getLineValues(LineParser lineParser, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getColumnCount());
        lineParser.setLine(string);
        while (lineParser.hasNext()) {
            String string2 = lineParser.getNext();
            if (this.nullString != null && string2.equals(this.nullString)) {
                string2 = null;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void readColumns(String string) throws Exception {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(this.delimiter, this.quoteChar, false);
        wbStringTokenizer.setDelimiterNeedsWhitspace(false);
        wbStringTokenizer.setSourceString(string);
        while (wbStringTokenizer.hasMoreTokens()) {
            String string2 = wbStringTokenizer.nextToken();
            arrayList.add(new ColumnIdentifier(string2));
        }
        this.setColumns(arrayList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnIdentifier> getColumnsFromFile() {
        BufferedReader bufferedReader = null;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        try {
            this.setupFileHandler();
            bufferedReader = this.fileHandler.getMainFileReader();
            String string = bufferedReader.readLine();
            WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(this.delimiter, this.quoteChar, false);
            wbStringTokenizer.setSourceString(string);
            int n = 1;
            while (wbStringTokenizer.hasMoreTokens()) {
                String string2 = wbStringTokenizer.nextToken();
                if (string2 == null) continue;
                String string3 = null;
                string3 = this.withHeader ? string2.toUpperCase() : "Column" + n;
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(string3);
                arrayList.add(columnIdentifier);
                ++n;
            }
        }
        catch (Exception exception) {
            this.hasErrors = true;
            LogMgr.logError(new CallerInfo(){}, "Error when reading columns", exception);
        }
        finally {
            this.fileHandler.done();
        }
        return arrayList;
    }

    @Override
    public void checkTargetTable() throws SQLException {
        TableDefinition tableDefinition = this.getTargetTable();
        if (tableDefinition == null || tableDefinition.getColumns().isEmpty()) {
            TableIdentifier tableIdentifier = this.createTargetTableId();
            String string = ResourceMgr.getFormattedString("ErrTargetTableNotFound", tableIdentifier.getTableExpression(this.connection));
            this.messages.append(string);
            this.messages.appendNewLine();
            this.importColumns = null;
            this.hasErrors = true;
            throw new SQLException("Table " + tableIdentifier.getTableExpression(this.connection) + " not found!");
        }
    }

    @Override
    public void setupFileColumns(List<ColumnIdentifier> list) throws SQLException, IOException {
        List<ColumnIdentifier> list2 = null;
        if (this.withHeader) {
            list2 = this.getColumnsFromFile();
        } else {
            TableDefinition tableDefinition = this.getTargetTable();
            list2 = tableDefinition.getColumns();
        }
        this.setColumns(list2, list);
    }

    public int getColumnCount() {
        if (this.importColumns == null) {
            return 0;
        }
        return this.importColumns.size();
    }

    List<ImportFileColumn> getImportColumns() {
        return this.importColumns;
    }

    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
    }

    @Override
    public String getDecimalChar() {
        if (this.converter == null) {
            return null;
        }
        char c = this.converter.getDecimalCharacter();
        return new StringBuilder(1).append(c).toString();
    }

    @Override
    public void setDecimalChar(String string) {
        if (this.converter != null && StringUtil.isNonBlank(string)) {
            this.converter.setDecimalCharacter(string.charAt(0));
        }
    }

    @Override
    public boolean getDecode() {
        return this.decodeUnicode;
    }

    @Override
    public void setDecode(boolean bl) {
        this.decodeUnicode = bl;
    }
}

