/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SqlServerTypeReader
implements ObjectListExtender {
    private final String baseSql = "select db_name() as type_catalog, \n       s.name as type_schema, \n       t.name as type_name,  \n       type_name(system_type_id) as data_type, \n       t.is_nullable,  \n       t.max_length,  \n       t.scale,  \n       t.precision,  \n       t.collation_name \nfrom sys.types t with (nolock) \n  join sys.schemas s with (nolock) on t.schema_id = s.schema_id \nwhere t.is_user_defined = 1";
    private final String sqlServer2000Query = "select db_name() as type_catalog, \n       o.name as type_schema, \n       t.name as type_name,  \n       type_name(t.xtype) as data_type, \n       t.allownulls as is_nullable,  \n       t.length as max_length,  \n       t.scale,  \n       t.prec as [precision],  \n       t.collation as collation_name \nfrom systypes t with (nolock) \n  join sysusers o on t.uid = o.uid \nwhere xusertype > 256";
    private Set<String> maxLengthTypes = CollectionUtil.treeSet("varchar", "nvarchar", "char", "text", "ntext", "varbinary");
    private Set<String> numericTypes = CollectionUtil.treeSet("decimal", "numeric");

    public static boolean versionSupportsTypes(WbConnection wbConnection) {
        return SqlServerUtil.isSqlServer2000(wbConnection);
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("TYPE", stringArray)) {
            return false;
        }
        List<DomainIdentifier> list = this.getTypeList(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (DomainIdentifier domainIdentifier : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, (Object)domainIdentifier.getCatalog());
            dataStore.setValue(n, 3, (Object)domainIdentifier.getSchema());
            dataStore.setValue(n, 0, (Object)domainIdentifier.getObjectName());
            dataStore.setValue(n, 4, (Object)domainIdentifier.getComment());
            dataStore.setValue(n, 1, (Object)domainIdentifier.getObjectType());
            dataStore.getRow(n).setUserObject(domainIdentifier);
        }
        return true;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "TYPE".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainIdentifier> getTypeList(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<DomainIdentifier> arrayList = new ArrayList<DomainIdentifier>();
        try {
            statement = wbConnection.createStatementForQuery();
            String string3 = this.getSql(wbConnection, string, string2);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                DomainIdentifier domainIdentifier = this.createTypeFromResultSet(resultSet);
                arrayList.add(domainIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not read domains", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    private DomainIdentifier createTypeFromResultSet(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("type_catalog");
        String string2 = resultSet.getString("type_schema");
        String string3 = resultSet.getString("type_name");
        DomainIdentifier domainIdentifier = new DomainIdentifier(string, string2, string3);
        domainIdentifier.setObjectType("TYPE");
        String string4 = resultSet.getString("data_type");
        int n = resultSet.getInt("max_length");
        int n2 = resultSet.getInt("scale");
        int n3 = resultSet.getInt("precision");
        boolean bl = resultSet.getBoolean("is_nullable");
        domainIdentifier.setDataType(this.getDataTypeDefinition(string4, n, n2, n3));
        domainIdentifier.setNullable(bl);
        return domainIdentifier;
    }

    private String getDataTypeDefinition(String string, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
        stringBuilder.append(string);
        if (this.maxLengthTypes.contains(string)) {
            if (n == -1) {
                stringBuilder.append("(max)");
            } else {
                stringBuilder.append("(").append(n).append(")");
            }
        } else if (this.numericTypes.contains(string)) {
            stringBuilder.append("(").append(n3).append(",").append(n2).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        DomainIdentifier domainIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (domainIdentifier == null) {
            return null;
        }
        String[] stringArray = new String[]{"TYPE", "DATA_TYPE", "NULLABLE"};
        int[] nArray = new int[]{12, 12, 16};
        int[] nArray2 = new int[]{20, 10, 5};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)domainIdentifier.getObjectName());
        dataStore.setValue(0, 1, (Object)domainIdentifier.getDataType());
        dataStore.setValue(0, 2, (Object)domainIdentifier.isNullable());
        return dataStore;
    }

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("select db_name() as type_catalog, \n       s.name as type_schema, \n       t.name as type_name,  \n       type_name(system_type_id) as data_type, \n       t.is_nullable,  \n       t.max_length,  \n       t.scale,  \n       t.precision,  \n       t.collation_name \nfrom sys.types t with (nolock) \n  join sys.schemas s with (nolock) on t.schema_id = s.schema_id \nwhere t.is_user_defined = 1".length() + 20);
        if (SqlServerUtil.isSqlServer2000(wbConnection)) {
            stringBuilder.append("select db_name() as type_catalog, \n       o.name as type_schema, \n       t.name as type_name,  \n       type_name(t.xtype) as data_type, \n       t.allownulls as is_nullable,  \n       t.length as max_length,  \n       t.scale,  \n       t.prec as [precision],  \n       t.collation as collation_name \nfrom systypes t with (nolock) \n  join sysusers o on t.uid = o.uid \nwhere xusertype > 256");
            if (StringUtil.isNonBlank(string2)) {
                SqlUtil.appendAndCondition(stringBuilder, "t.name", string2, wbConnection);
            }
        } else {
            stringBuilder.append("select db_name() as type_catalog, \n       s.name as type_schema, \n       t.name as type_name,  \n       type_name(system_type_id) as data_type, \n       t.is_nullable,  \n       t.max_length,  \n       t.scale,  \n       t.precision,  \n       t.collation_name \nfrom sys.types t with (nolock) \n  join sys.schemas s with (nolock) on t.schema_id = s.schema_id \nwhere t.is_user_defined = 1");
            if (StringUtil.isNonBlank(string2)) {
                SqlUtil.appendAndCondition(stringBuilder, "t.name", string2, wbConnection);
            }
            if (StringUtil.isNonBlank(string)) {
                SqlUtil.appendAndCondition(stringBuilder, "s.name", string, wbConnection);
            }
        }
        stringBuilder.append("\n ORDER BY 1, 2");
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(new CallerInfo(){}, "Using SQL=\n" + stringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainIdentifier getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        Statement statement = null;
        ResultSet resultSet = null;
        DomainIdentifier domainIdentifier = null;
        try {
            statement = wbConnection.createStatementForQuery();
            String string = wbConnection.getMetadata().adjustObjectnameCase(dbObject.getObjectName());
            String string2 = wbConnection.getMetadata().adjustSchemaNameCase(dbObject.getSchema());
            String string3 = this.getSql(wbConnection, string2, string);
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                domainIdentifier = this.createTypeFromResultSet(resultSet);
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read domains", sQLException);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        return domainIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableTypeSource(WbConnection wbConnection, DomainIdentifier domainIdentifier) {
        String string;
        String string2 = "select col.name,  \n       type_name(col.system_type_id) as data_type, \n       col.is_nullable, \n       col.max_length, \n       col.precision,  \n       col.scale, \n       def.definition as default_value \nfrom sys.all_columns col \n  join sys.table_types tt on tt.type_table_object_id = col.object_id \n  join sys.schemas s on tt.schema_id = s.schema_id \n  left join sys.default_constraints def on def.object_id = col.default_object_id and def.parent_column_id = col.column_id \n";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string2 = string2 + "where tt.name = ? \n";
        if (StringUtil.isNonBlank(domainIdentifier.getSchema())) {
            string2 = string2 + " AND s.name = ? \n";
        }
        string2 = string2 + "order by col.column_id";
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "table type source", string2, new Object[0]);
        try {
            Object object;
            CharSequence charSequence;
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string2);
            preparedStatement.setString(1, wbConnection.getMetadata().removeQuotes(domainIdentifier.getObjectName()));
            if (StringUtil.isNonBlank(domainIdentifier.getSchema())) {
                preparedStatement.setString(2, wbConnection.getMetadata().removeQuotes(domainIdentifier.getSchema()));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                charSequence = resultSet.getString("name");
                object = resultSet.getString("data_type");
                int n = resultSet.getInt("max_length");
                int n2 = resultSet.getInt("scale");
                int n3 = resultSet.getInt("precision");
                boolean bl = resultSet.getBoolean("is_nullable");
                String string3 = resultSet.getString("default_value");
                ColumnIdentifier columnIdentifier = new ColumnIdentifier((String)charSequence);
                columnIdentifier.setDbmsType(this.getDataTypeDefinition((String)object, n, n2, n3));
                columnIdentifier.setIsNullable(bl);
                columnIdentifier.setDefaultValue(string3);
                arrayList.add(columnIdentifier);
            }
            charSequence = new StringBuilder(arrayList.size() * 20 + 50);
            ((StringBuilder)charSequence).append("CREATE TYPE ");
            ((StringBuilder)charSequence).append(domainIdentifier.getObjectExpression(wbConnection));
            ((StringBuilder)charSequence).append("\nAS\nTABLE\n(\n");
            object = TableSourceBuilderFactory.getBuilder(wbConnection);
            ((TableSourceBuilder)object).appendColumnDefinitions((StringBuilder)charSequence, arrayList, wbConnection.getMetadata());
            ((StringBuilder)charSequence).append("\n);\n");
            string = ((StringBuilder)charSequence).toString();
        }
        catch (SQLException sQLException) {
            String string4;
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not read columns for type " + domainIdentifier.getObjectName(), sQLException);
                string4 = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return string4;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return string;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        DomainIdentifier domainIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (domainIdentifier.getDataType().equalsIgnoreCase("table type")) {
            return this.getTableTypeSource(wbConnection, domainIdentifier);
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(domainIdentifier.getObjectExpression(wbConnection));
        stringBuilder.append("\n  FROM ");
        stringBuilder.append(domainIdentifier.getDataType());
        if (!domainIdentifier.isNullable()) {
            stringBuilder.append(" NOT NULL");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

