/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import workbench.db.DbMetadata;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;

public class MySQLIndexReader
extends JdbcIndexReader {
    public MySQLIndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processIndexList(Collection<IndexDefinition> collection) {
        if (collection.isEmpty()) {
            return;
        }
        ResultSet resultSet = null;
        Statement statement = null;
        WbConnection wbConnection = this.metaData.getWbConnection();
        Set<TableIdentifier> set = this.getIndexTables(collection);
        try {
            statement = wbConnection.createStatementForQuery();
            for (TableIdentifier tableIdentifier : set) {
                String string = "show index from " + SqlUtil.fullyQualifiedName(wbConnection, tableIdentifier) + " where sub_part is not null";
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    String string2 = resultSet.getString("Key_name");
                    String string3 = resultSet.getString("Column_name");
                    int n = resultSet.getInt("Sub_part");
                    IndexDefinition indexDefinition = this.findIndex(collection, string2);
                    IndexColumn indexColumn = this.findColumn(indexDefinition, string3);
                    if (indexColumn == null) continue;
                    indexColumn.setColumn(string3 + "(" + Integer.toString(n) + ")");
                }
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read indexed definition", sQLException);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
    }

    private Set<TableIdentifier> getIndexTables(Collection<IndexDefinition> collection) {
        HashSet<TableIdentifier> hashSet = new HashSet<TableIdentifier>();
        for (IndexDefinition indexDefinition : collection) {
            if (indexDefinition.getBaseTable() == null) continue;
            hashSet.add(indexDefinition.getBaseTable());
        }
        return hashSet;
    }

    private IndexColumn findColumn(IndexDefinition indexDefinition, String string) {
        if (indexDefinition == null) {
            return null;
        }
        for (IndexColumn indexColumn : indexDefinition.getColumns()) {
            if (!indexColumn.getColumn().equals(string)) continue;
            return indexColumn;
        }
        return null;
    }

    private IndexDefinition findIndex(Collection<IndexDefinition> collection, String string) {
        for (IndexDefinition indexDefinition : collection) {
            if (!indexDefinition.getName().equals(string)) continue;
            return indexDefinition;
        }
        return null;
    }
}

