/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class OracleExternalTableReader {
    private String baseSql = "-- SQL Workbench \nselect et.owner,  \n       et.table_name,  \n       et.type_name,  \n       et.default_directory_name,  \n       et.reject_limit,  \n       et.access_parameters,  \n       el.location, \n       el.directory_name \nfrom all_external_tables et \n  join all_external_locations el on el.owner = et.owner and el.table_name = et.table_name  where et.owner = ? \n   and et.table_name = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getDefinition(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        StringBuilder stringBuilder;
        block5: {
            stringBuilder = null;
            preparedStatement = null;
            resultSet = null;
            LogMgr.logMetadataSql(new CallerInfo(){}, "external table definition", this.baseSql, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            try {
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(this.baseSql);
                preparedStatement.setString(1, tableIdentifier.getRawSchema());
                preparedStatement.setString(2, tableIdentifier.getRawTableName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                String string = resultSet.getString("type_name");
                String string2 = resultSet.getString("default_directory_name");
                String string3 = resultSet.getString("reject_limit");
                String string4 = resultSet.getString("access_parameters");
                String string5 = resultSet.getString("location");
                String string6 = resultSet.getString("directory_name");
                stringBuilder = new StringBuilder(100);
                stringBuilder.append("ORGANIZATION EXTERNAL\n(\n");
                stringBuilder.append("  TYPE ");
                stringBuilder.append(string);
                stringBuilder.append('\n');
                stringBuilder.append("  DEFAULT DIRECTORY ");
                stringBuilder.append(string2);
                stringBuilder.append('\n');
                stringBuilder.append("  ACCESS PARAMETERS\n  (\n");
                stringBuilder.append((CharSequence)this.fixIndention(string4.trim(), "    "));
                stringBuilder.append("\n  )\n");
                stringBuilder.append("  LOCATION ('");
                if (!StringUtil.equalStringIgnoreCase(string2, string6)) {
                    stringBuilder.append(string6);
                    stringBuilder.append(':');
                }
                stringBuilder.append(string5);
                stringBuilder.append("')\n");
                stringBuilder.append(")\n");
                stringBuilder.append("REJECT LIMIT ");
                stringBuilder.append(string3);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "external table definition", this.baseSql, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder;
    }

    private StringBuilder fixIndention(String string, String string2) {
        List<String> list = StringUtil.getLines(string);
        StringBuilder stringBuilder = new StringBuilder(list.size() * 50);
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).trim().startsWith(")")) {
                string3 = null;
            } else if (i > 1 && list.get(i - 1).trim().startsWith("(")) {
                String string4 = list.get(i - 1);
                int n = string4.indexOf(40);
                int n2 = StringUtil.findFirstNonWhitespace(list.get(i));
                if (n2 > n) {
                    int n3 = n2 - n;
                    string3 = StringUtil.padRight(" ", n3);
                } else {
                    string3 = null;
                }
            }
            stringBuilder.append(string2);
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(list.get(i).trim());
            if (i >= list.size() - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }
}

