/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DropType;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleDDLCleaner;
import workbench.db.oracle.OracleTableSourceBuilder;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class OracleMViewReader {
    private String pkIndex;
    private String defaultTablespace = null;

    public CharSequence getMViewSource(WbConnection wbConnection, TableDefinition tableDefinition, List<IndexDefinition> list, DropType dropType, boolean bl) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        boolean bl2 = OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.mview);
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        StringBuilder stringBuilder = new StringBuilder(250);
        long l = System.currentTimeMillis();
        String string = tableIdentifier.getTableExpression(wbConnection);
        if (dropType != DropType.none) {
            stringBuilder.append("DROP MATERIALIZED VIEW ");
            stringBuilder.append(string);
            stringBuilder.append(";\n\n");
        }
        boolean bl3 = false;
        this.pkIndex = null;
        if (bl2) {
            try {
                object3 = DbmsMetadata.getDDL(wbConnection, "MATERIALIZED_VIEW", tableIdentifier.getObjectName(), tableIdentifier.getSchema());
                stringBuilder.append((String)object3);
                bl3 = true;
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve source for MVIEW " + string + " using dbms_metadata. Querying ALL_MVIEWS instead", exception);
            }
        }
        object3 = new OracleTableSourceBuilder(wbConnection);
        StringBuilder stringBuilder2 = ((OracleTableSourceBuilder)object3).getPartitionSql(tableIdentifier, "  ", false);
        if (!bl3) {
            object2 = new StringBuilder(500);
            serializable = new StringBuilder(150);
            try {
                this.retrieveMViewDetails(wbConnection, tableIdentifier, (StringBuilder)object2, (StringBuilder)serializable);
            }
            catch (SQLException sQLException) {
                return ExceptionUtil.getDisplay(sQLException);
            }
            stringBuilder.append("CREATE MATERIALIZED VIEW ");
            stringBuilder.append(string);
            object = tableDefinition.getColumns();
            if (wbConnection.getDbSettings().generateColumnListInViews() && object.size() > 0) {
                stringBuilder.append('\n');
                stringBuilder.append('(');
                stringBuilder.append('\n');
                int n = object.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = ((ColumnIdentifier)object.get(i)).getColumnName();
                    stringBuilder.append("  ");
                    stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string2));
                    if (i >= n - 1) continue;
                    stringBuilder.append(",\n");
                }
                stringBuilder.append("\n)");
            }
            if (StringUtil.isNonEmpty(stringBuilder2)) {
                stringBuilder.append('\n');
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            if (((StringBuilder)serializable).length() > 0) {
                stringBuilder.append((CharSequence)((Object)serializable));
            }
            stringBuilder.append("\nAS\n");
            stringBuilder.append((CharSequence)object2);
            stringBuilder.append('\n');
            if (bl) {
                TableSourceBuilder.appendComments(stringBuilder, wbConnection, tableDefinition);
            }
        }
        stringBuilder.append('\n');
        if (list == null) {
            list = wbConnection.getMetadata().getIndexReader().getTableIndexList(tableIdentifier, true);
        }
        if (this.pkIndex != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                serializable = (IndexDefinition)object2.next();
                object = ((IndexDefinition)serializable).getName();
                if (!((String)object).equals(this.pkIndex)) continue;
                object2.remove();
                break;
            }
        }
        if ((object2 = wbConnection.getMetadata().getIndexReader().getIndexSource(tableIdentifier, list)) != null) {
            stringBuilder.append("\n\n");
            stringBuilder.append((CharSequence)object2);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Building source for " + string + " took " + l2 + "ms");
        return stringBuilder;
    }

    private void retrieveMViewDetails(WbConnection wbConnection, TableIdentifier tableIdentifier, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws SQLException {
        if (OracleUtils.checkDefaultTablespace() && this.defaultTablespace == null) {
            this.defaultTablespace = OracleUtils.getDefaultTablespace(wbConnection);
        }
        String string = "       tb.compression, \n       tb.compress_for \n";
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "11.1")) {
            string = "       null as compression, \n       null as compress_for \n";
        }
        String string2 = "mv.use_no_index";
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "9.0")) {
            string2 = "null as use_no_index";
        }
        String string3 = "-- SQL Workbench \nselect mv.query, \n       mv.rewrite_enabled, \n       mv.refresh_mode, \n       mv.refresh_method, \n       mv.build_mode, \n       mv.fast_refreshable, \n       " + string2 + ", \n       cons.constraint_name, \n       cons.index_name, \n       rc.interval, \n       tb.tablespace_name, \n" + string + "from all_mviews mv \n  join all_tables tb on tb.owner = mv.owner and tb.table_name = mv.container_name \n  left join all_constraints cons on cons.owner = mv.owner and cons.table_name = mv.mview_name and cons.constraint_type = 'P' \n  left join all_refresh_children rc on rc.owner = mv.owner and rc.name = mv.mview_name \nwhere mv.owner = ? \n  and mv.mview_name = ? ";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        try {
            LogMgr.logMetadataSql(callerInfo, "MVIEW details", string3, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string4;
                String string5;
                String string6;
                String string7 = resultSet.getString("query");
                stringBuilder.append(this.cleanupQuery(string7));
                String string8 = resultSet.getString("BUILD_MODE");
                String string9 = resultSet.getString("tablespace_name");
                boolean bl = false;
                if (!"PREBUILT".equals(string8)) {
                    bl = OracleUtils.shouldAppendTablespace(string9, this.defaultTablespace, tableIdentifier.getRawSchema(), wbConnection.getCurrentUser());
                }
                if (bl) {
                    stringBuilder2.append("\n  TABLESPACE ");
                    stringBuilder2.append(string9);
                }
                if (StringUtil.equalStringIgnoreCase("enabled", string6 = resultSet.getString("compression")) && StringUtil.isNonBlank(string5 = resultSet.getString("compress_for"))) {
                    stringBuilder2.append("\n  COMPRESS FOR ");
                    stringBuilder2.append(string5);
                }
                if ("Y".equals(string5 = resultSet.getString("USE_NO_INDEX"))) {
                    stringBuilder2.append("\n  USING NO INDEX\n");
                }
                if ("PREBUILT".equals(string8)) {
                    stringBuilder2.append("\n  ON PREBUILT TABLE");
                } else {
                    stringBuilder2.append("\n  BUILD ");
                    stringBuilder2.append(string8);
                }
                String string10 = resultSet.getString("REFRESH_METHOD");
                stringBuilder2.append("\n  REFRESH ");
                stringBuilder2.append(string10);
                String string11 = resultSet.getString("REFRESH_MODE");
                stringBuilder2.append(" ON ");
                stringBuilder2.append(string11);
                String string12 = resultSet.getString("constraint_name");
                if (string12 != null) {
                    stringBuilder2.append(" WITH PRIMARY KEY");
                } else {
                    stringBuilder2.append(" WITH ROWID");
                }
                String string13 = resultSet.getString("INTERVAL");
                if (StringUtil.isNonBlank(string13)) {
                    stringBuilder2.append("\n  NEXT ");
                    stringBuilder2.append(string13.trim());
                }
                if ("Y".equals(string4 = resultSet.getString("REWRITE_ENABLED"))) {
                    stringBuilder2.append("\n  ENABLE QUERY REWRITE");
                } else {
                    stringBuilder2.append("\n  DISABLE QUERY REWRITE");
                }
                this.pkIndex = resultSet.getString("INDEX_NAME");
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(callerInfo, "Retrieving information from ALL_MVIEWS for " + tableIdentifier.getRawSchema() + "." + tableIdentifier.getRawTableName() + " took " + l2 + "ms");
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(callerInfo, sQLException, "MVIEW details", string3, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    private String cleanupQuery(String string) {
        if (string == null) {
            return "";
        }
        if (!(string = OracleDDLCleaner.cleanupQuotedIdentifiers(string)).endsWith(";")) {
            string = string + ";";
        }
        return string;
    }
}

