/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class OracleObjectListEnhancer
implements ObjectListEnhancer {
    private boolean canRetrieveSnapshots = true;

    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        boolean bl;
        if (wbConnection == null) {
            return;
        }
        boolean bl2 = bl = Settings.getInstance().getBoolProperty("workbench.db.oracle.detectsnapshots", true) && DbMetadata.typeIncluded("TABLE", stringArray);
        if (!bl) {
            return;
        }
        Map<String, String> map = this.getSnapshots(wbConnection, string2);
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string4 = dataStore.getValueAsString(i, 3);
            String string5 = dataStore.getValueAsString(i, 0);
            String string6 = string4 + "." + string5;
            if (!map.containsKey(string6)) continue;
            dataStore.setValue(i, 1, (Object)"MATERIALIZED VIEW");
            dataStore.setValue(i, 4, (Object)map.get(string6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSnapshots(WbConnection wbConnection, String string) {
        if (!this.canRetrieveSnapshots || wbConnection == null) {
            return Collections.emptyMap();
        }
        String string2 = Settings.getInstance().getProperty("workbench.db.oracle.default.mv.comment", "snapshot table for snapshot");
        if (StringUtil.isBlank(string2)) {
            string2 = null;
        }
        Map<String, String> map = new HashMap<String, String>();
        String string3 = OracleUtils.getRemarksReporting(wbConnection) ? "-- SQL Workbench \nSELECT mv.owner, mv.mview_name, \n       c.comments\nFROM all_mviews mv\n  left join all_mview_comments c on c.owner = mv.owner and c.mview_name = mv.mview_name \n" : "-- SQL Workbench \nSELECT mv.owner, mv.mview_name, \n       null as comments  \nFROM all_mviews mv \n";
        if (string != null) {
            string3 = string3 + " WHERE mv.owner = ?";
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "snapshots", string3, string);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            if (string != null) {
                preparedStatement.setString(1, string);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                if (string2 != null && string6 != null && string6.startsWith(string2) && string6.endsWith(string5)) {
                    string6 = null;
                }
                map.put(string4 + "." + string5, string6);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "snapshots", string3, string);
                this.canRetrieveSnapshots = false;
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return map;
    }
}

