/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import workbench.db.ColumnIdentifier;
import workbench.db.DependencyNode;
import workbench.db.DropType;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.TableGrantReader;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleExternalTableReader;
import workbench.db.oracle.OracleIndexReader;
import workbench.db.oracle.OracleTableGrantReader;
import workbench.db.oracle.OracleTablePartition;
import workbench.db.oracle.OracleUtils;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleTableSourceBuilder
extends TableSourceBuilder {
    public static final String REV_IDX_TYPE = "NORMAL/REV";
    public static final String INDEX_USAGE_PLACEHOLDER = "%pk_index_usage%";
    public static final String IOT_OPTIONS = "%IOT_DEFINITION%";
    private static final String A_DEFAULT = "DEFAULT";
    private String defaultTablespace;
    private String currentUser;

    public OracleTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
        if (OracleUtils.checkDefaultTablespace()) {
            this.defaultTablespace = OracleUtils.getDefaultTablespace(wbConnection);
        }
        this.currentUser = wbConnection.getCurrentUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        String string;
        CharSequence charSequence;
        CharSequence charSequence2;
        String string2;
        CallerInfo callerInfo;
        long l;
        StringBuilder stringBuilder;
        String string3;
        boolean bl;
        String string4;
        boolean bl2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block51: {
            String string5;
            OracleExternalTableReader oracleExternalTableReader;
            CharSequence charSequence3;
            if (tableIdentifier.getSourceOptions().isInitialized()) {
                return;
            }
            if (!Settings.getInstance().getBoolProperty("workbench.db.oracle.table_options.retrieve", true)) {
                LogMgr.logInfo(new CallerInfo(){}, "Not retrieving table options for " + tableIdentifier.getTableExpression());
                tableIdentifier.getSourceOptions().setInitialized();
                return;
            }
            if (Settings.getInstance().getBoolProperty("workbench.db.oracle.retrieve_externaltables", true) && (charSequence3 = (oracleExternalTableReader = new OracleExternalTableReader()).getDefinition(tableIdentifier, this.dbConnection)) != null) {
                tableIdentifier.getSourceOptions().setTableOption(charSequence3.toString());
                tableIdentifier.getSourceOptions().setInitialized();
                return;
            }
            boolean bl3 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "11.2");
            boolean bl4 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "11.1");
            boolean bl5 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "11.1");
            preparedStatement = null;
            resultSet = null;
            bl2 = false;
            if (OracleUtils.optimizeCatalogQueries() && (StringUtil.isEmptyString(string5 = tableIdentifier.getRawSchema()) || string5.equalsIgnoreCase(this.currentUser))) {
                bl2 = true;
            }
            string5 = "";
            if (bl3) {
                string5 = bl2 ? "  left join user_flashback_archive_tables fat on fat.table_name = atb.table_name \n" : "  left join dba_flashback_archive_tables fat on fat.table_name = atb.table_name and fat.owner_name = atb.owner \n";
            }
            String string6 = "-- SQL Workbench \nselect " + OracleUtils.getCacheHint() + "atb.tablespace_name, \n       atb.degree, \n       atb.row_movement, \n       atb.temporary, \n       atb.degree, \n       atb.cache, \n       atb.buffer_pool, \n" + (bl5 ? "       atb.flash_cache, \n       atb.cell_flash_cache, \n" : "       null as flash_cache, \n       null as cell_flash_cache, \n") + "       atb.duration, \n       atb.pct_free, \n       atb.pct_used, \n       atb.pct_increase, \n       atb.logging, \n       atb.iot_type, \n       atb.partitioned, \n       atb.read_only, \n" + (bl3 ? "       fat.flashback_archive_name, \n" : "       null as flashback_archive_name, \n") + (bl4 ? "       atb.compression, \n       atb.compress_for \n" : "       null as compression,\n       null as compress_for \n") + "from all_tables atb \n" + string5 + "where atb.table_name = ? ";
            string6 = bl2 ? string6.replace(" all_", " user_") : string6 + "\n and atb.owner = ?";
            string4 = null;
            bl = false;
            string3 = null;
            stringBuilder = new StringBuilder(100);
            l = System.currentTimeMillis();
            callerInfo = new CallerInfo(){};
            try {
                String string7;
                String string8;
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string6);
                preparedStatement.setString(1, tableIdentifier.getRawTableName());
                if (!bl2) {
                    preparedStatement.setString(2, tableIdentifier.getRawSchema());
                }
                LogMgr.logMetadataSql(callerInfo, "table source options", string6, tableIdentifier.getTableName(), tableIdentifier.getSchema());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block51;
                String string9 = resultSet.getString("temporary");
                boolean bl6 = StringUtil.equalString("Y", string9);
                if (!bl6) {
                    string2 = resultSet.getString("tablespace_name");
                    tableIdentifier.setTablespace(string2);
                }
                bl = StringUtil.equalStringIgnoreCase("YES", StringUtil.trim(resultSet.getString("partitioned")));
                string3 = resultSet.getString("IOT_TYPE");
                if (StringUtil.isNonBlank(string3)) {
                    tableIdentifier.getSourceOptions().addConfigSetting("organization", "index");
                    stringBuilder.append(IOT_OPTIONS);
                }
                if (StringUtil.stringsAreNotEqual("1", string2 = StringUtil.trim(resultSet.getString("degree")))) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    if (A_DEFAULT.equals(string2)) {
                        stringBuilder.append("PARALLEL");
                        tableIdentifier.getSourceOptions().addConfigSetting("parallel", "default");
                    } else {
                        stringBuilder.append("PARALLEL " + string2);
                        tableIdentifier.getSourceOptions().addConfigSetting("parallel", string2);
                    }
                }
                if (StringUtil.equalString("ENABLED", (String)(charSequence2 = StringUtil.trim(resultSet.getString("row_movement"))))) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("ENABLE ROW MOVEMENT");
                    tableIdentifier.getSourceOptions().addConfigSetting("row_movement", "enabled");
                }
                if ("YES".equals(charSequence = resultSet.getString("read_only"))) {
                    string = "ALTER TABLE " + tableIdentifier.getTableExpression(this.dbConnection) + " READ ONLY;";
                    String string10 = tableIdentifier.getSourceOptions().getAdditionalSql();
                    string10 = StringUtil.isBlank(string10) ? string : string10 + "\n" + string;
                    tableIdentifier.getSourceOptions().setAdditionalSql(string10);
                }
                string = resultSet.getString("duration");
                if (bl6) {
                    tableIdentifier.getSourceOptions().setTypeModifier("GLOBAL TEMPORARY");
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    if (StringUtil.equalString("SYS$TRANSACTION", string)) {
                        stringBuilder.append("ON COMMIT DELETE ROWS");
                        tableIdentifier.getSourceOptions().addConfigSetting("on_commit", "delete");
                    } else if (StringUtil.equalString("SYS$SESSION", string)) {
                        stringBuilder.append("ON COMMIT PRESERVE ROWS");
                        tableIdentifier.getSourceOptions().addConfigSetting("on_commit", "preserve");
                    }
                    tableIdentifier.setTablespace(null);
                }
                int n = resultSet.getInt("pct_free");
                if (!resultSet.wasNull() && n != 10 && StringUtil.isEmptyString(string3)) {
                    tableIdentifier.getSourceOptions().addConfigSetting("pct_free", Integer.toString(n));
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("PCTFREE ");
                    stringBuilder.append(n);
                }
                int n2 = resultSet.getInt("pct_used");
                if (!resultSet.wasNull() && n2 != 40 && StringUtil.isEmptyString(string3) && !bl6) {
                    tableIdentifier.getSourceOptions().addConfigSetting("pct_used", Integer.toString(n2));
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("PCTUSED ");
                    stringBuilder.append(n2);
                }
                String string11 = StringUtil.coalesce(StringUtil.trim(resultSet.getString("buffer_pool")), A_DEFAULT);
                String string12 = StringUtil.coalesce(StringUtil.trim(resultSet.getString("flash_cache")), A_DEFAULT);
                String string13 = StringUtil.coalesce(StringUtil.trim(resultSet.getString("cell_flash_cache")), A_DEFAULT);
                String string14 = null;
                if (StringUtil.stringsAreNotEqual(A_DEFAULT, string11)) {
                    tableIdentifier.getSourceOptions().addConfigSetting("buffer_pool", string11);
                    string14 = "STORAGE (BUFFER_POOL " + string11;
                }
                if (StringUtil.stringsAreNotEqual(A_DEFAULT, string12)) {
                    tableIdentifier.getSourceOptions().addConfigSetting("flash_cache", string12);
                    if (string14 == null) {
                        string14 = "STORAGE (";
                    }
                    string14 = string14 + " FLASH_CACHE " + string12;
                }
                if (StringUtil.stringsAreNotEqual(A_DEFAULT, string13)) {
                    tableIdentifier.getSourceOptions().addConfigSetting("cell_flash_cache", string13);
                    if (string14 == null) {
                        string14 = "STORAGE (";
                    }
                    string14 = string14 + " CELL_FLASH_CACHE " + string13;
                }
                if (string14 != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(string14 + ")");
                }
                if (StringUtil.equalStringIgnoreCase("NO", string8 = resultSet.getString("logging")) && !bl6) {
                    tableIdentifier.getSourceOptions().addConfigSetting("logging", "nologging");
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("NOLOGGING");
                }
                if (StringUtil.equalStringIgnoreCase("enabled", string7 = resultSet.getString("compression"))) {
                    String string15 = resultSet.getString("compress_for");
                    tableIdentifier.getSourceOptions().addConfigSetting("compression", string15);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("COMPRESS FOR ");
                    stringBuilder.append(string15);
                }
                if (!StringUtil.isNonEmpty(string4 = resultSet.getString("flashback_archive_name"))) break block51;
                tableIdentifier.getSourceOptions().addConfigSetting("flashback_archive", string4);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(callerInfo, sQLException, "table source options", string6, tableIdentifier.getTableName(), tableIdentifier.getSchema());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "Retrieving table options for " + tableIdentifier.getTableName() + " took " + l2 + "ms");
        string2 = tableIdentifier.getTablespace();
        if (OracleUtils.shouldAppendTablespace(string2, this.defaultTablespace, tableIdentifier.getRawSchema(), this.dbConnection.getCurrentUser())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("TABLESPACE ");
            stringBuilder.append(string2);
        }
        if (StringUtil.isNonEmpty(string4)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("FLASHBACK ARCHIVE ");
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(string4));
            if (Settings.getInstance().getBoolProperty("workbench.db.oracle.retrieve_flashback", false)) {
                this.retrieveFlashbackInfo(tableIdentifier);
            }
        }
        if (this.includePartitions && bl && (charSequence2 = this.getPartitionSql(tableIdentifier, "", true)) != null && ((StringBuilder)charSequence2).length() > 0) {
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
                stringBuilder.append('\n');
            }
            stringBuilder.append(charSequence2);
        }
        if ((charSequence2 = this.getNestedTableSql(tableIdentifier, list)) != null && ((StringBuilder)charSequence2).length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(charSequence2);
        }
        if ((charSequence = this.retrieveLobOptions(tableIdentifier, list)) != null) {
            stringBuilder.insert(0, charSequence + "\n");
        }
        tableIdentifier.getSourceOptions().setTableOption(stringBuilder.toString());
        if (StringUtil.isNonEmpty(string3)) {
            this.readIOTDefinition(tableIdentifier, bl2);
        }
        if (StringUtil.isNonEmpty(string = this.readColumnGroups(tableIdentifier))) {
            tableIdentifier.getSourceOptions().appendAdditionalSql(string);
        }
        tableIdentifier.getSourceOptions().setInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder retrieveLobOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (!this.hasLobColumns(list)) {
            return null;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (!Settings.getInstance().getBoolProperty("workbench.db.oracle.lob_options.retrieve", true)) {
            LogMgr.logWarning(callerInfo, "Not retrieving table LOB options for " + tableIdentifier.getTableExpression() + " even though table has LOB columns. To retrieve LOB options, set workbench.db.oracle.lob_options.retrieve to true");
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "-- SQL Workbench \nselect column_name, tablespace_name, chunk, retention, cache, logging, encrypt, compression, deduplication, in_row, securefile, retention_type, retention_value \nfrom all_lobs \nwhere table_name = '" + tableIdentifier.getRawTableName() + "' \n   and owner = '" + tableIdentifier.getRawSchema() + "' ";
        LogMgr.logMetadataSql(callerInfo, "LOB options", string, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder(100);
        long l = System.currentTimeMillis();
        try {
            boolean bl = true;
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString("column_name");
                String string3 = resultSet.getString("tablespace_name");
                long l2 = resultSet.getLong("chunk");
                long l3 = resultSet.getLong("retention");
                long l4 = resultSet.getLong("retention_value");
                String string4 = resultSet.getString("retention_type");
                if (A_DEFAULT.equalsIgnoreCase(string4)) {
                    string4 = "AUTO";
                }
                if (resultSet.wasNull()) {
                    l3 = -1L;
                }
                String string5 = resultSet.getString("cache");
                String string6 = resultSet.getString("logging");
                String string7 = resultSet.getString("encrypt");
                String string8 = resultSet.getString("compression");
                String string9 = resultSet.getString("securefile");
                String string10 = resultSet.getString("deduplication");
                String string11 = resultSet.getString("in_row");
                StringBuilder stringBuilder2 = new StringBuilder(50);
                boolean bl2 = false;
                if ("YES".equals(string9)) {
                    stringBuilder2.append(" SECUREFILE (");
                    bl2 = true;
                } else {
                    stringBuilder2.append(" BASICFILE (");
                }
                if (!StringUtil.equalStringIgnoreCase(string3, tableIdentifier.getTablespace())) {
                    stringBuilder2.append("TABLESPACE ");
                    stringBuilder2.append(string3);
                    stringBuilder2.append(' ');
                }
                if ("YES".equalsIgnoreCase(string11)) {
                    stringBuilder2.append("ENABLE STORAGE IN ROW");
                } else {
                    stringBuilder2.append("DISABLE STORAGE IN ROW");
                }
                if (l2 != 8192L) {
                    stringBuilder2.append(" CHUNK ");
                    stringBuilder2.append(l2);
                }
                if (bl2) {
                    stringBuilder2.append(" RETENTION ");
                    stringBuilder2.append(string4);
                    if ("MIN".equalsIgnoreCase(string4)) {
                        stringBuilder2.append(' ');
                        stringBuilder2.append(l4);
                    }
                    if ("NO".equals(string8)) {
                        stringBuilder2.append(" NOCOMPRESS");
                    } else {
                        stringBuilder2.append(" COMPRESS ");
                        stringBuilder2.append(string8);
                    }
                    if ("LOB".equals(string10)) {
                        stringBuilder2.append(" DEDUPLICATE");
                    }
                    if ("YES".equals(string7)) {
                        stringBuilder2.append(" ENCRYPT");
                    }
                }
                switch (string5) {
                    case "NO": {
                        stringBuilder2.append(" NOCACHE");
                        break;
                    }
                    case "YES": {
                        stringBuilder2.append(" CACHE");
                        break;
                    }
                    case "CACHEREADS": {
                        stringBuilder2.append(" CACHE READS");
                    }
                }
                if ("NO".equals(string6)) {
                    stringBuilder2.append(" NOLOGGING");
                }
                stringBuilder2.append(')');
                if (!bl) {
                    stringBuilder.append(",\n");
                }
                String string12 = "LOB (" + string2 + ")";
                stringBuilder.append(string12);
                stringBuilder.append(" STORE AS");
                stringBuilder.append((CharSequence)stringBuilder2);
                tableIdentifier.getSourceOptions().addConfigSetting(string12, stringBuilder2.toString());
                bl = false;
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(callerInfo, exception, "LOB options", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        long l5 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "Retrieving LOB options for " + tableIdentifier.getTableExpression() + " took " + l5 + "ms");
        return stringBuilder;
    }

    private boolean hasLobColumns(List<ColumnIdentifier> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (ColumnIdentifier columnIdentifier : list) {
            if (!columnIdentifier.getDbmsType().endsWith("LOB")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFlashbackInfo(TableIdentifier tableIdentifier) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            resultSet = null;
            String string = "-- SQL Workbench \nselect fa.flashback_archive_name,   \n       fa.retention_in_days, \n       tbl.tablespace_name \nfrom dba_flashback_archive fa  \n  join user_flashback_archive_tables fat  \n    on fat.flashback_archive_name = fa.flashback_archive_name  \n  join all_tables tbl  \n    on tbl.owner = fat.owner_name  \n   and tbl.table_name = fat.table_name \nwhere fat.owner_name = ? \n  and fat.table_name = ? ";
            CallerInfo callerInfo = new CallerInfo(){};
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, tableIdentifier.getSchema());
                preparedStatement.setString(2, tableIdentifier.getTableName());
                LogMgr.logMetadataSql(callerInfo, "flashback archive information", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                String string2 = resultSet.getString(1);
                int n = resultSet.getInt(2);
                String string3 = resultSet.getString(3);
                String string4 = "RETENTION ";
                string4 = n < 30 ? string4 + Integer.toString(n) + " DAY" : (n < 365 ? string4 + Integer.toString(n / 30) + " MONTH" : string4 + Integer.toString(n / 365) + " YEAR");
                String string5 = "\n-- definition of flasback archive \nCREATE FLASHBACK ARCHIVE " + string2 + "\n  TABLESPACE " + string3 + "\n  " + string4 + ";\n";
                tableIdentifier.getSourceOptions().setAdditionalSql(string5);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(callerInfo, exception, "flashback archive information", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    StringBuilder getPartitionSql(TableIdentifier tableIdentifier, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (Settings.getInstance().getBoolProperty("workbench.db.oracle.retrieve_partitions", true)) {
            try {
                OracleTablePartition oracleTablePartition = new OracleTablePartition(this.dbConnection);
                oracleTablePartition.retrieve(tableIdentifier, this.dbConnection);
                String string2 = oracleTablePartition.getSourceForTableDefinition(string, bl);
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving partitions for " + tableIdentifier.getFullyQualifiedName(this.dbConnection), sQLException);
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getNestedTableSql(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ColumnIdentifier object22 : list) {
            object = SqlUtil.getPlainTypeName(object22.getDbmsType());
            if (OracleUtils.STANDARD_TYPES.contains(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        String string = "-- SQL Workbench \nSELECT 'NESTED TABLE '||parent_table_column||' STORE AS '||table_name \nFROM all_nested_tables \nWHERE parent_table_name = ? \n  AND owner = ?";
        Statement statement = null;
        object = null;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            PreparedStatement preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getTableName());
            preparedStatement.setString(2, tableIdentifier.getSchema());
            LogMgr.logMetadataSql(callerInfo, "nested table", string, tableIdentifier.getTableName(), tableIdentifier.getSchema());
            object = preparedStatement.executeQuery();
            while (object.next()) {
                String string2 = object.getString(1);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string2);
            }
            JdbcUtils.closeAll((ResultSet)object, preparedStatement);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(callerInfo, sQLException, "nested table", string, tableIdentifier.getTableName(), tableIdentifier.getSchema());
        }
        finally {
            JdbcUtils.closeAll((ResultSet)object, statement);
        }
        return stringBuilder;
    }

    @Override
    public CharSequence getPkSource(TableIdentifier tableIdentifier, PkDefinition pkDefinition, boolean bl, boolean bl2) {
        boolean bl3;
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.constraint)) {
            try {
                String string = DbmsMetadata.getDDL(this.dbConnection, "CONSTRAINT", pkDefinition.getPkName(), tableIdentifier.getSchema());
                if (string != null) {
                    string = string + "\n";
                }
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OracleIndexReader oracleIndexReader = (OracleIndexReader)this.dbConnection.getMetadata().getIndexReader();
        String string = super.getPkSource(tableIdentifier, pkDefinition, bl, bl2).toString();
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        PkDefinition pkDefinition2 = pkDefinition == null ? tableIdentifier.getPrimaryKey() : pkDefinition;
        IndexDefinition indexDefinition = pkDefinition2.getPkIndexDefinition();
        String string2 = pkDefinition2.getPkIndexName();
        if (indexDefinition == null) {
            indexDefinition = this.getIndexDefinition(tableIdentifier, string2);
            pkDefinition2.setPkIndexDefinition(indexDefinition);
        }
        String string3 = "";
        if (pkDefinition2.isDisabled()) {
            string3 = " DISABLE";
        }
        boolean bl4 = bl3 = indexDefinition != null && REV_IDX_TYPE.equals(indexDefinition.getIndexType());
        if (indexDefinition == null) {
            string = string.replace(" %pk_index_usage%", string3);
        } else if (string2.equals(pkDefinition2.getPkName()) && !indexDefinition.isPartitioned()) {
            if (OracleUtils.shouldAppendTablespace(indexDefinition.getTablespace(), this.defaultTablespace, indexDefinition.getSchema(), this.dbConnection.getCurrentUser())) {
                String string4 = "USING INDEX";
                if (bl3) {
                    string4 = string4 + " REVERSE";
                }
                string = string.replace(INDEX_USAGE_PLACEHOLDER, "\n   " + string4 + " TABLESPACE " + indexDefinition.getTablespace());
            } else {
                string = string.replace(" %pk_index_usage%", "");
            }
        } else {
            String string5 = oracleIndexReader.getIndexSource(tableIdentifier, indexDefinition).toString();
            if (bl3) {
                string5 = string5.replace("\n    REVERSE", " REVERSE");
            }
            StringBuilder stringBuilder = new StringBuilder(string5.length() + 20);
            stringBuilder.append("\n   USING INDEX (\n     ");
            stringBuilder.append(SqlUtil.trimSemicolon(string5).trim().replace("\n", "\n  "));
            stringBuilder.append("\n   )");
            stringBuilder.append(string3);
            string = string.replace(INDEX_USAGE_PLACEHOLDER, stringBuilder);
        }
        return string;
    }

    private IndexDefinition getIndexDefinition(TableIdentifier tableIdentifier, String string) {
        IndexDefinition indexDefinition;
        OracleIndexReader oracleIndexReader = (OracleIndexReader)this.dbConnection.getMetadata().getIndexReader();
        try {
            indexDefinition = oracleIndexReader.getIndexDefinition(tableIdentifier, string, null);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve index", sQLException);
            indexDefinition = null;
        }
        return indexDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIOTDefinition(TableIdentifier tableIdentifier, boolean bl) {
        String string;
        String string2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l;
        String string3;
        StringBuilder stringBuilder;
        String string4;
        block11: {
            string4 = "-- SQL Workbench \nselect " + OracleUtils.getCacheHint() + "coalesce(atb.tablespace_name, pt.def_tablespace_name) as tablespace_name, \n       iot.tablespace_name as iot_overflow, \n       iot.table_name as overflow_table, \n       ac.index_name as pk_index_name, \n       ai.compression as index_compression, \n       ai.prefix_length, \n       ai.tablespace_name as index_tablespace \nfrom all_tables atb \n  left join all_tables iot on atb.table_name = iot.iot_name " + (bl ? "\n" : " and atb.owner = iot.owner \n") + "  left join all_constraints ac on ac.table_name = atb.table_name and ac.constraint_type = 'P' " + (bl ? "\n" : " and ac.owner = atb.owner \n") + "  left join all_indexes ai on ai.table_name = ac.table_name and ai.index_name = ac.index_name " + (bl ? "\n" : " and ai.owner = coalesce(ac.index_owner, ac.owner) \n") + "  left join all_part_tables pt on pt.table_name = iot.table_name " + (bl ? "\n" : " and pt.owner = iot.owner \n") + "where atb.table_name = ? ";
            string4 = bl ? string4.replace(" all_", " user_") : string4 + "\n and atb.owner = ?";
            LogMgr.logMetadataSql(new CallerInfo(){}, "IOT information", string4, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            stringBuilder = new StringBuilder(100);
            string3 = this.getIOTIncludedColumn(tableIdentifier.getSchema(), tableIdentifier.getTableName(), tableIdentifier.getPrimaryKey().getPkIndexName());
            l = System.currentTimeMillis();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            if (!bl) {
                preparedStatement.setString(2, tableIdentifier.getRawSchema());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) break block11;
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return;
        }
        try {
            String string5;
            stringBuilder.append("ORGANIZATION INDEX");
            string2 = resultSet.getString("IOT_OVERFLOW");
            tableIdentifier.getSourceOptions().addConfigSetting("organization", "index");
            string = resultSet.getString("index_compression");
            if ("ENABLED".equalsIgnoreCase(string) && StringUtil.isNonBlank(string5 = resultSet.getString("prefix_length"))) {
                stringBuilder.append("\n  COMPRESS ");
                stringBuilder.append(string5);
            }
            if (string3 != null) {
                stringBuilder.append("\n  INCLUDING ");
                stringBuilder.append(string3);
                if (StringUtil.isEmptyString(string2)) {
                    stringBuilder.append(" OVERFLOW");
                }
                tableIdentifier.getSourceOptions().addConfigSetting("iot_included_cols", string3);
            }
            if (StringUtil.isNonEmpty(string5 = resultSet.getString("INDEX_TABLESPACE"))) {
                stringBuilder.append("\n  TABLESPACE ").append(string5);
                tableIdentifier.getSourceOptions().addConfigSetting("index_tablespace", string5);
                tableIdentifier.setTablespace(null);
            }
            if (StringUtil.isNonBlank(string2)) {
                stringBuilder.append("\n  OVERFLOW TABLESPACE ");
                stringBuilder.append(string2);
                tableIdentifier.getSourceOptions().addConfigSetting("overflow_tablespace", string2);
            }
            tableIdentifier.setUseInlinePK(true);
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "IOT information", string4, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        string2 = tableIdentifier.getSourceOptions().getTableOption();
        string = string2.replace(IOT_OPTIONS, stringBuilder.toString());
        tableIdentifier.getSourceOptions().setTableOption(string);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving IOT information for " + tableIdentifier.getTableExpression() + " took " + l2 + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIOTIncludedColumn(String string, String string2, String string3) {
        String string4;
        long l;
        CallerInfo callerInfo;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            resultSet = null;
            String string5 = "-- SQL Workbench \nselect column_name \nfrom all_tab_columns \nwhere column_name not in (select column_name \n                          from all_ind_columns  \n                          where index_name = ? \n                            and index_owner = ?) \n  and table_name = ? \n  and owner = ? \norder by column_id \n";
            callerInfo = new CallerInfo(){};
            l = System.currentTimeMillis();
            string4 = null;
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string5);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string);
                LogMgr.logMetadataSql(callerInfo, "IOT included columns", string5, string3, string, string2, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                string4 = resultSet.getString(1);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(callerInfo, exception, "IOT included columns", string5, string3, string, string2, string);
                    string4 = null;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "Retrieving included columns for IOT " + string + "." + string2 + " took " + l2 + "ms");
        return string4;
    }

    @Override
    protected String getAdditionalFkSql(TableIdentifier tableIdentifier, DependencyNode dependencyNode, String string) {
        string = dependencyNode.isValidated() ? TemplateHandler.removePlaceholder(string, "%validate%", false) : TemplateHandler.replacePlaceholder(string, "%validate%", "NOVALIDATE", true);
        string = dependencyNode.isEnabled() ? TemplateHandler.removePlaceholder(string, "%enabled%", false) : TemplateHandler.replacePlaceholder(string, "%enabled%", "DISABLE", true);
        return string;
    }

    @Override
    public String getNativeTableSource(TableIdentifier tableIdentifier, DropType dropType) {
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.table)) {
            try {
                String string;
                boolean bl = this.dbConnection.getDbSettings().createInlineFKConstraints();
                boolean bl2 = this.dbConnection.getDbSettings().createInlinePKConstraints();
                String string2 = DbmsMetadata.getTableDDL(this.dbConnection, tableIdentifier.getTableName(), tableIdentifier.getSchema(), bl2, bl) + "\n";
                if (!bl2 && tableIdentifier.getPrimaryKeyName() != null && StringUtil.isNonEmpty(string = DbmsMetadata.getDDL(this.dbConnection, "CONSTRAINT", tableIdentifier.getPrimaryKeyName(), tableIdentifier.getSchema()))) {
                    string2 = string2 + "\n\n" + string + "\n";
                }
                return string2;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return super.getNativeTableSource(tableIdentifier, dropType);
    }

    @Override
    public StringBuilder getFkSource(TableIdentifier tableIdentifier) {
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.constraint)) {
            String string = DbmsMetadata.getDependentDDL(this.dbConnection, "REF_CONSTRAINT", tableIdentifier.getTableName(), tableIdentifier.getSchema());
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder(string.length());
                stringBuilder.append(string);
                stringBuilder.append('\n');
                return stringBuilder;
            }
            return null;
        }
        return super.getFkSource(tableIdentifier);
    }

    @Override
    public StringBuilder getFkSource(TableIdentifier tableIdentifier, List<DependencyNode> list, boolean bl) {
        if (!bl && OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.constraint)) {
            return this.getFkSource(tableIdentifier);
        }
        return super.getFkSource(tableIdentifier, list, bl);
    }

    @Override
    public String getTableSource(TableIdentifier tableIdentifier, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.table)) {
            return this.getCompleteTableSource(tableIdentifier, dropType, bl, bl2);
        }
        return super.getTableSource(tableIdentifier, dropType, bl, bl2);
    }

    public String getCompleteTableSource(TableIdentifier tableIdentifier, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        OracleTableGrantReader oracleTableGrantReader;
        StringBuilder stringBuilder;
        Object object;
        Object object2;
        Object object3;
        String string = "";
        if (dropType != DropType.none) {
            string = this.generateDrop(tableIdentifier, dropType).toString() + "\n\n";
        }
        boolean bl3 = this.dbConnection.getDbSettings().createInlinePKConstraints();
        boolean bl4 = this.dbConnection.getDbSettings().createInlineFKConstraints();
        if (!bl3 && tableIdentifier.getPrimaryKey() == null) {
            object3 = this.getIndexReader().getPrimaryKey(tableIdentifier);
            tableIdentifier.setPrimaryKey((PkDefinition)object3);
        }
        string = string + DbmsMetadata.getTableDDL(this.dbConnection, tableIdentifier.getTableName(), tableIdentifier.getSchema(), this.dbConnection.getDbSettings().createInlinePKConstraints(), bl4);
        if (tableIdentifier.getPrimaryKeyName() != null && StringUtil.isNonEmpty((CharSequence)(object3 = DbmsMetadata.getDDL(this.dbConnection, "CONSTRAINT", tableIdentifier.getPrimaryKeyName(), tableIdentifier.getSchema())))) {
            string = string + "\n\n" + (String)object3;
        }
        if (bl && !bl4 && StringUtil.isNonEmpty((CharSequence)(object3 = this.getFkSource(tableIdentifier)))) {
            string = string + "\n\n" + object3;
        }
        object3 = null;
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.index)) {
            object3 = DbmsMetadata.getDependentDDL(this.dbConnection, "INDEX", tableIdentifier.getTableName(), tableIdentifier.getSchema());
        } else {
            object2 = this.getIndexReader().getTableIndexList(tableIdentifier, true);
            object = object2.stream().filter(indexDefinition -> !indexDefinition.isPrimaryKeyIndex()).collect(Collectors.toList());
            object3 = this.getIndexReader().getIndexSource(tableIdentifier, (List<IndexDefinition>)object);
        }
        if (StringUtil.isNonEmpty((CharSequence)object3)) {
            string = string + "\n\n" + object3;
        }
        if (StringUtil.isNonEmpty((CharSequence)(object2 = this.readColumnGroups(tableIdentifier)))) {
            string = string + "\n\n" + (String)object2;
        }
        if (StringUtil.isNonEmpty((CharSequence)(object = DbmsMetadata.getDependentDDL(this.dbConnection, "COMMENT", tableIdentifier.getTableName(), tableIdentifier.getSchema())))) {
            string = string + "\n\n" + (String)object;
        }
        if (bl2 && StringUtil.isNonEmpty(stringBuilder = ((TableGrantReader)(oracleTableGrantReader = new OracleTableGrantReader())).getTableGrantSource(this.dbConnection, tableIdentifier))) {
            string = string + "\n\n" + stringBuilder;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readColumnGroups(TableIdentifier tableIdentifier) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        StringBuilder stringBuilder;
        block7: {
            if (!JdbcUtils.hasMinimumServerVersion(this.dbConnection, "11.0")) {
                return "";
            }
            String string = "select extension \nfrom all_stat_extensions \nwhere owner = ? \n  and table_name = ?";
            if (!OracleUtils.showSystemGeneratedExtendedStats()) {
                string = string + "\n  and creator <> 'SYSTEM'";
            }
            stringBuilder = new StringBuilder(500);
            String string2 = this.currentUser.equalsIgnoreCase(tableIdentifier.getRawSchema()) ? "NULL" : "'" + tableIdentifier.getRawSchema() + "'";
            String string3 = this.dbConnection.getMetadata().quoteObjectname(tableIdentifier.getTableName());
            LogMgr.logMetadataSql(new CallerInfo(){}, "extended stats", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, tableIdentifier.getRawSchema());
                preparedStatement.setString(2, tableIdentifier.getRawTableName());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    if (!StringUtil.isNonEmpty(string4)) continue;
                    String string5 = String.format("select dbms_stats.create_extended_stats(ownname => %s, tabname => '%s', extension => '%s') from dual;\n", string2, string3, SqlUtil.escapeQuotes(string4));
                    stringBuilder.append(string5);
                }
                if (stringBuilder.length() <= 0) break block7;
                stringBuilder.append('\n');
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "extended stats", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder.toString();
    }
}

