/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class PgPublication
implements DbObject,
Serializable {
    public static final String TYPE_NAME = "PUBLICATION";
    private String name;
    private String comment;
    private boolean replicatesInserts;
    private boolean replicatesUpdates;
    private boolean replicatesTruncate;
    private boolean replicatesDeletes;
    private boolean includeAllTables;
    private boolean tablesInitialized;
    private List<TableIdentifier> tables = new ArrayList<TableIdentifier>();

    public PgPublication(String string) {
        this.name = string;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        String string;
        String string2 = "CREATE PUBLICATION " + SqlUtil.quoteObjectname(this.name);
        if (this.includeAllTables) {
            string2 = string2 + "\n  FOR ALL TABLES";
        } else {
            if (!this.tablesInitialized) {
                this.setTables(this.retrieveTables(wbConnection));
            }
            string = " ";
            if (this.tables.size() > 5) {
                string = "\n    ";
            }
            String string3 = this.tables.stream().map(tableIdentifier -> tableIdentifier.getTableExpression(wbConnection)).collect(Collectors.joining("," + string));
            string2 = string2 + "\n  FOR TABLE" + string + string3;
        }
        string = this.getPublishOptions();
        if (string != null) {
            string2 = string2 + "\n WITH (publish = '" + string + "')";
        }
        string2 = string2 + ";";
        return string2;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return "DROP PUBLICATION IF EXISTS " + SqlUtil.quoteObjectname(this.name);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setReplicatesInserts(boolean bl) {
        this.replicatesInserts = bl;
    }

    public void setReplicatesUpdates(boolean bl) {
        this.replicatesUpdates = bl;
    }

    public void setReplicatesTruncate(boolean bl) {
        this.replicatesTruncate = bl;
    }

    public void setReplicatesDeletes(boolean bl) {
        this.replicatesDeletes = bl;
    }

    public void setIncludeAllTables(boolean bl) {
        this.includeAllTables = bl;
    }

    private String getPublishOptions() {
        if (this.replicatesDeletes && this.replicatesInserts && this.replicatesTruncate && this.replicatesUpdates) {
            return null;
        }
        String string = "";
        int n = 0;
        if (this.replicatesInserts) {
            string = string + "insert";
            ++n;
        }
        if (this.replicatesUpdates) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + "update";
            ++n;
        }
        if (this.replicatesDeletes) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + "delete";
            ++n;
        }
        if (this.replicatesTruncate) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + "truncate";
            ++n;
        }
        return string;
    }

    public void setTables(List<TableIdentifier> list) {
        this.tables.clear();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.tables.addAll(list);
        this.tablesInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableIdentifier> retrieveTables(WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        String string = "select t.relnamespace::regnamespace::text as schema_name, \n       t.relname as table_name, \n       pg_catalog.obj_description(t.oid) as remarks \nfrom pg_class t \nwhere t.oid in (select rel.prrelid \n                from pg_publication_rel rel                   join pg_publication pub on pub.oid = rel.prpubid \n                where pub.pubname = ?)";
        LogMgr.logMetadataSql(new CallerInfo(){}, "publication tables", string, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, this.name);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("schema_name");
                String string3 = resultSet.getString("table_name");
                String string4 = resultSet.getString("remarks");
                TableIdentifier tableIdentifier = new TableIdentifier(string2, string3);
                tableIdentifier.setComment(string4);
                tableIdentifier.setNeverAdjustCase(true);
                arrayList.add(tableIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "publication tables", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }
}

