/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresDomainReader
implements ObjectListExtender {
    final String baseSql = "SELECT null::text as domain_catalog,  \n       n.nspname as domain_schema, \n       t.typname as domain_name, \n       pg_catalog.format_type(t.typbasetype, t.typtypmod) as data_type, \n       not t.typnotnull as nullable, \n       t.typdefault as default_value, \n       c.conname as constraint_name, \n       pg_catalog.pg_get_constraintdef(c.oid, true) as constraint_definition, \n       pg_catalog.obj_description(t.oid) as remarks \nFROM pg_catalog.pg_type t \n  LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace \n  LEFT JOIN pg_catalog.pg_constraint c ON t.oid = c.contypid \nWHERE t.typtype = 'd' \n  AND n.nspname <> 'pg_catalog' \n  AND n.nspname <> 'information_schema' \n";

    public Map<String, DomainIdentifier> getDomainInfo(WbConnection wbConnection, String string) {
        List<DomainIdentifier> list = this.getDomainList(wbConnection, string, null);
        HashMap<String, DomainIdentifier> hashMap = new HashMap<String, DomainIdentifier>(list.size());
        for (DomainIdentifier domainIdentifier : list) {
            hashMap.put(domainIdentifier.getObjectName(), domainIdentifier);
        }
        return hashMap;
    }

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("SELECT null::text as domain_catalog,  \n       n.nspname as domain_schema, \n       t.typname as domain_name, \n       pg_catalog.format_type(t.typbasetype, t.typtypmod) as data_type, \n       not t.typnotnull as nullable, \n       t.typdefault as default_value, \n       c.conname as constraint_name, \n       pg_catalog.pg_get_constraintdef(c.oid, true) as constraint_definition, \n       pg_catalog.obj_description(t.oid) as remarks \nFROM pg_catalog.pg_type t \n  LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace \n  LEFT JOIN pg_catalog.pg_constraint c ON t.oid = c.contypid \nWHERE t.typtype = 'd' \n  AND n.nspname <> 'pg_catalog' \n  AND n.nspname <> 'information_schema' \n".length() + 40);
        stringBuilder.append("SELECT * FROM ( ");
        stringBuilder.append("SELECT null::text as domain_catalog,  \n       n.nspname as domain_schema, \n       t.typname as domain_name, \n       pg_catalog.format_type(t.typbasetype, t.typtypmod) as data_type, \n       not t.typnotnull as nullable, \n       t.typdefault as default_value, \n       c.conname as constraint_name, \n       pg_catalog.pg_get_constraintdef(c.oid, true) as constraint_definition, \n       pg_catalog.obj_description(t.oid) as remarks \nFROM pg_catalog.pg_type t \n  LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace \n  LEFT JOIN pg_catalog.pg_constraint c ON t.oid = c.contypid \nWHERE t.typtype = 'd' \n  AND n.nspname <> 'pg_catalog' \n  AND n.nspname <> 'information_schema' \n");
        stringBuilder.append(") di \n");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("\n WHERE ");
            SqlUtil.appendExpression(stringBuilder, "domain_name", string2, wbConnection);
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(bl ? " AND " : " WHERE ");
            SqlUtil.appendExpression(stringBuilder, "domain_schema", string, wbConnection);
        }
        stringBuilder.append("\n ORDER BY 1, 2 ");
        LogMgr.logMetadataSql(new CallerInfo(){}, "domains", stringBuilder, new Object[0]);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainIdentifier> getDomainList(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        String string3 = null;
        ArrayList<DomainIdentifier> arrayList = new ArrayList<DomainIdentifier>();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            string3 = this.getSql(wbConnection, string, string2);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("domain_catalog");
                String string5 = resultSet.getString("domain_schema");
                String string6 = resultSet.getString("domain_name");
                DomainIdentifier domainIdentifier = new DomainIdentifier(string4, string5, string6);
                domainIdentifier.setCheckConstraint(resultSet.getString("constraint_definition"));
                domainIdentifier.setDataType(resultSet.getString("data_type"));
                domainIdentifier.setNullable(resultSet.getBoolean("nullable"));
                domainIdentifier.setDefaultValue(resultSet.getString("default_value"));
                domainIdentifier.setComment(resultSet.getString("remarks"));
                arrayList.add(domainIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "domains", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public DomainIdentifier getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<DomainIdentifier> list = this.getDomainList(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public String getDomainSource(DomainIdentifier domainIdentifier) {
        if (domainIdentifier == null) {
            return null;
        }
        String string = SqlUtil.buildExpression(null, domainIdentifier);
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE DOMAIN ");
        stringBuilder.append(string);
        stringBuilder.append(" AS ");
        stringBuilder.append(domainIdentifier.getDataType());
        if (domainIdentifier.getDefaultValue() != null) {
            stringBuilder.append("\n   DEFAULT ");
            stringBuilder.append(domainIdentifier.getDefaultValue());
        }
        if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint()) || !domainIdentifier.isNullable()) {
            stringBuilder.append("\n   CONSTRAINT ");
            if (StringUtil.isNonBlank(domainIdentifier.getConstraintName())) {
                stringBuilder.append(domainIdentifier.getConstraintName()).append(" ");
            }
            if (!domainIdentifier.isNullable()) {
                stringBuilder.append("NOT NULL");
            }
            if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint())) {
                if (!domainIdentifier.isNullable()) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(domainIdentifier.getCheckConstraint());
            }
        }
        stringBuilder.append(";\n");
        if (StringUtil.isNonBlank(domainIdentifier.getComment())) {
            stringBuilder.append("\nCOMMENT ON DOMAIN ").append(string).append(" IS '");
            stringBuilder.append(SqlUtil.escapeQuotes(domainIdentifier.getComment()));
            stringBuilder.append("';\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!this.handlesType(stringArray)) {
            return false;
        }
        if (!DbMetadata.typeIncluded("DOMAIN", stringArray)) {
            return false;
        }
        List<DomainIdentifier> list = this.getDomainList(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (DomainIdentifier domainIdentifier : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)domainIdentifier.getSchema());
            dataStore.setValue(n, 0, (Object)domainIdentifier.getObjectName());
            dataStore.setValue(n, 4, (Object)domainIdentifier.getComment());
            dataStore.setValue(n, 1, (Object)domainIdentifier.getObjectType());
            dataStore.getRow(n).setUserObject(domainIdentifier);
        }
        return true;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("DOMAIN", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        DomainIdentifier domainIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (domainIdentifier == null) {
            return null;
        }
        String[] stringArray = new String[]{"DOMAIN", "DATA_TYPE", "NULLABLE", "CONSTRAINT", "REMARKS"};
        int[] nArray = new int[]{12, 12, 16, 12, 12};
        int[] nArray2 = new int[]{20, 10, 5, 30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)domainIdentifier.getObjectName());
        dataStore.setValue(0, 1, (Object)domainIdentifier.getDataType());
        dataStore.setValue(0, 2, (Object)domainIdentifier.isNullable());
        dataStore.setValue(0, 3, (Object)domainIdentifier.getCheckConstraint());
        dataStore.setValue(0, 4, (Object)domainIdentifier.getComment());
        dataStore.resetStatus();
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return Collections.singletonList("DOMAIN");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        return this.getDomainSource(this.getObjectDefinition(wbConnection, dbObject));
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

