/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.postgres.ForeignServer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresForeignServerReader
implements ObjectListExtender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ForeignServer> getServerList(WbConnection wbConnection, String string) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<ForeignServer> arrayList = new ArrayList<ForeignServer>();
        String string2 = "select s.srvname as name, \n       s.srvtype as type,\n       s.srvversion as version,\n       s.srvoptions as options,\n       w.fdwname as fdw\nfrom pg_catalog.pg_foreign_server s\n  join pg_catalog.pg_foreign_data_wrapper w on s.srvfdw = w.oid";
        if (StringUtil.isNonBlank(string)) {
            if (string.contains("%")) {
                string2 = string2 + "\nWHERE s.srvname like '";
                string2 = string2 + SqlUtil.escapeUnderscore(string, wbConnection);
                string2 = string2 + "' ";
                string2 = string2 + SqlUtil.getEscapeClause(wbConnection, string);
            } else {
                string2 = string2 + "\nWHERE s.srvname = '";
                string2 = string2 + SqlUtil.escapeQuotes(string);
                string2 = string2 + "' ";
            }
        }
        string2 = string2 + "\norder by s.srvname";
        LogMgr.logMetadataSql(new CallerInfo(){}, "foreign servers", string2, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString("name");
                String string4 = resultSet.getString("type");
                String string5 = resultSet.getString("version");
                String[] stringArray = JdbcUtils.getArray(resultSet, "options", String[].class);
                String string6 = resultSet.getString("fdw");
                ForeignServer foreignServer = new ForeignServer(string3);
                foreignServer.setVersion(string5);
                foreignServer.setType(string4);
                foreignServer.setFdwName(string6);
                if (stringArray != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (String string7 : stringArray) {
                        String[] stringArray2 = string7.split("=");
                        if (stringArray2.length == 2) {
                            hashMap.put(stringArray2[0], stringArray2[1]);
                        }
                        foreignServer.setOptions(hashMap);
                    }
                }
                arrayList.add(foreignServer);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "foreign servers", string2, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public ForeignServer getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<ForeignServer> list = this.getServerList(wbConnection, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("FOREIGN SERVER", stringArray)) {
            return false;
        }
        List<ForeignServer> list = this.getServerList(wbConnection, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (ForeignServer foreignServer : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, null);
            dataStore.setValue(n, 0, (Object)foreignServer.getObjectName());
            dataStore.setValue(n, 4, (Object)foreignServer.getComment());
            dataStore.setValue(n, 1, (Object)foreignServer.getObjectType());
            dataStore.getRow(n).setUserObject(foreignServer);
        }
        return true;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("FOREIGN SERVER", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("FOREIGN SERVER");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        ForeignServer foreignServer = this.getObjectDefinition(wbConnection, dbObject);
        if (foreignServer == null) {
            return null;
        }
        return foreignServer.getSource();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

