/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import workbench.db.JdbcUtils;
import workbench.db.SequenceAdjuster;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class PostgresSequenceAdjuster
implements SequenceAdjuster {
    @Override
    public int adjustTableSequences(WbConnection wbConnection, TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        Map<String, String> map = this.getColumnSequences(wbConnection, tableIdentifier);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.syncSingleSequence(wbConnection, tableIdentifier, entry.getKey(), entry.getValue());
        }
        if (bl && !wbConnection.getAutoCommit()) {
            wbConnection.commit();
        }
        return map.size();
    }

    private void syncSingleSequence(WbConnection wbConnection, TableIdentifier tableIdentifier, String string, String string2) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        String string3 = "select setval('" + string2 + "', (select max(" + string + ") from " + tableIdentifier.getTableExpression(wbConnection) + "))";
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence sync", string3, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                LogMgr.logDebug(new CallerInfo(){}, "New value for sequence " + string2 + " is: " + l);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "sequence sync", string3, new Object[0]);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getColumnSequences(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select * \nfrom ( \n  select column_name,  \n         pg_catalog.pg_get_serial_sequence(?, column_name) as sequence_name \n  from information_schema.columns \n  where table_name = ? \n  and table_schema = ? \n) t \nwhere sequence_name is not null";
        LogMgr.logMetadataSql(new CallerInfo(){}, "column sequences", string, tableIdentifier.getRawTableName(), tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            preparedStatement.setString(3, tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                hashMap.put(string2, string3);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "column sequences", string, tableIdentifier.getRawTableName(), tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return hashMap;
    }
}

