/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import workbench.db.SequenceDefinition;
import workbench.db.report.TagAttribute;
import workbench.db.report.TagWriter;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;

public class ReportSequence {
    public static final String TAG_SEQ_DEF = "sequence-def";
    public static final String TAG_SEQ_NAME = "sequence-name";
    public static final String TAG_SEQ_CATALOG = "sequence-catalog";
    public static final String TAG_SEQ_SCHEMA = "sequence-schema";
    public static final String TAG_SEQ_COMMENT = "sequence-comment";
    public static final String TAG_SEQ_SOURCE = "sequence-source";
    public static final String TAG_SEQ_PROPS = "sequence-properties";
    public static final String TAG_SEQ_OWNING_TABLE = "owned-by-table";
    public static final String TAG_SEQ_OWNING_COLUMN = "owned-by-column";
    public static final String TAG_SEQ_PROPERTY = "property";
    private SequenceDefinition sequence;
    private TagWriter tagWriter = new TagWriter();
    private String schemaNameToUse = null;

    public ReportSequence(SequenceDefinition sequenceDefinition) {
        this.sequence = sequenceDefinition;
    }

    public SequenceDefinition getSequence() {
        return this.sequence;
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public void setSchemaNameToUse(String string) {
        this.schemaNameToUse = string;
    }

    public StringBuilder getXml() {
        return this.getXml(new StringBuilder("  "), true);
    }

    public StringBuilder getXml(StringBuilder stringBuilder, boolean bl) {
        StringBuilder stringBuilder2 = new StringBuilder(500);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append((CharSequence)stringBuilder);
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_SEQ_DEF, "name", this.sequence.getSequenceName());
        stringBuilder2.append('\n');
        if (StringUtil.isNonEmpty(this.sequence.getCatalog())) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_SEQ_CATALOG, this.sequence.getCatalog());
        }
        if (this.sequence.getRelatedTable() != null && this.sequence.getRelatedColumn() != null) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_SEQ_OWNING_TABLE, this.sequence.getRelatedTable().getTableName());
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_SEQ_OWNING_COLUMN, this.sequence.getRelatedColumn());
        }
        this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_SEQ_SCHEMA, this.schemaNameToUse == null ? this.sequence.getSequenceOwner() : this.schemaNameToUse);
        this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_SEQ_NAME, this.sequence.getSequenceName());
        this.tagWriter.appendTagConditionally(stringBuilder2, stringBuilder3, TAG_SEQ_COMMENT, this.sequence.getComment());
        this.writeSequenceProperties(stringBuilder2, stringBuilder3);
        if (bl) {
            this.writeSourceTag(this.tagWriter, stringBuilder2, stringBuilder3, this.sequence.getSource());
        }
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_SEQ_DEF);
        return stringBuilder2;
    }

    public void writeSourceTag(TagWriter tagWriter, StringBuilder stringBuilder, StringBuilder stringBuilder2, CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_SEQ_SOURCE);
        stringBuilder.append("<![CDATA[");
        stringBuilder.append(StringUtil.rtrim(charSequence));
        stringBuilder.append("]]>");
        stringBuilder.append('\n');
        tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_SEQ_SOURCE);
    }

    protected void writeSequenceProperties(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        Object object;
        if (this.sequence.getProperties().isEmpty()) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
        stringBuilder4.append("  ");
        this.tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_SEQ_PROPS);
        stringBuilder.append('\n');
        for (String object2 : this.sequence.getProperties()) {
            if ("remarks".equalsIgnoreCase("propName")) continue;
            object = this.sequence.getSequenceProperty(object2);
            TagAttribute tagAttribute = new TagAttribute("name", object2);
            TagAttribute tagAttribute2 = new TagAttribute("value", object == null ? "" : WbDateFormatter.getDisplayValue(object));
            this.tagWriter.appendOpenTag(stringBuilder, stringBuilder3, TAG_SEQ_PROPERTY, false, tagAttribute, tagAttribute2);
            stringBuilder.append("/>\n");
        }
        if (this.sequence.getRelatedTable() != null && this.sequence.getRelatedColumn() != null) {
            String string = this.sequence.getRelatedTable().getTableName() + "." + this.sequence.getRelatedColumn();
            TagAttribute tagAttribute = new TagAttribute("name", "owned_by".toUpperCase());
            object = new TagAttribute("value", string);
            this.tagWriter.appendOpenTag(stringBuilder, stringBuilder3, TAG_SEQ_PROPERTY, false, new TagAttribute[]{tagAttribute, object});
            stringBuilder.append("/>\n");
        }
        this.tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_SEQ_PROPS);
    }
}

