/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.search;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.db.search.RowDataSearcher;
import workbench.db.search.TableDataSearcher;
import workbench.interfaces.TableSearchConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ClientSideTableSearcher
implements TableDataSearcher {
    private String searchString;
    private boolean isRunning;
    private boolean includeBLOBs;
    private boolean includeCLOBs;
    private int maxRows = Integer.MAX_VALUE;
    private List<TableIdentifier> tablesToSearch;
    private WbConnection connection;
    private boolean cancelSearch;
    private Thread searchThread;
    private Statement searchQuery;
    private TableSearchConsumer consumer;
    private RowDataSearcher searcher;
    private ColumnComparator comparator;
    private boolean treatBlobAsText;
    private String blobEncoding;
    private boolean showOnlyMatchedColumns;

    public void setShowOnlyMatchedColumns(boolean bl) {
        this.showOnlyMatchedColumns = bl;
    }

    @Override
    public String getCriteria() {
        return this.searchString;
    }

    @Override
    public void startBackgroundSearch() {
        this.cancelSearch = false;
        this.searchThread = new WbThread("TableSearcher Thread"){

            @Override
            public void run() {
                ClientSideTableSearcher.this.search();
            }
        };
        this.searchThread.start();
    }

    @Override
    public void cancelSearch() {
        this.cancelSearch = true;
        try {
            if (this.searchThread != null) {
                this.searchThread.interrupt();
            }
            if (this.searchQuery != null) {
                this.searchQuery.cancel();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when cancelling", throwable);
        }
    }

    private void setRunning(boolean bl) {
        this.isRunning = bl;
        if (this.consumer != null) {
            if (bl) {
                this.consumer.searchStarted();
            } else {
                this.consumer.searchEnded();
            }
        }
    }

    public void setTreatBlobAsText(boolean bl, String string) {
        this.treatBlobAsText = bl;
        if (this.treatBlobAsText && EncodingUtil.isEncodingSupported(string)) {
            this.blobEncoding = string;
            this.includeBLOBs = true;
        } else {
            this.blobEncoding = null;
        }
    }

    public void setRetrieveBLOBs(boolean bl) {
        this.includeBLOBs = bl;
        this.blobEncoding = null;
    }

    public void setIncludeCLOBs(boolean bl) {
        this.includeCLOBs = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search() {
        if (this.isRunning) {
            return;
        }
        this.cancelSearch = false;
        this.setRunning(true);
        try {
            long l = this.tablesToSearch.size();
            long l2 = 1L;
            for (TableIdentifier tableIdentifier : this.tablesToSearch) {
                if (this.cancelSearch) {
                    break;
                }
                this.searchTable(tableIdentifier, l2, l);
                ++l2;
            }
        }
        finally {
            this.setRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchTable(TableIdentifier tableIdentifier, long l, long l2) {
        block12: {
            String string;
            ResultSet resultSet;
            Savepoint savepoint;
            block11: {
                savepoint = null;
                resultSet = null;
                if (this.connection.getDbSettings().useSavePointForDML()) {
                    savepoint = this.connection.setSavepoint();
                }
                TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.connection, "tablesearch");
                tableSelectBuilder.setIncludeBLOBColumns(this.includeBLOBs);
                tableSelectBuilder.setIncludeCLOBColumns(this.includeCLOBs);
                string = tableSelectBuilder.getSelectForTable(tableIdentifier, -1);
                if (!StringUtil.isEmptyString(string)) break block11;
                LogMgr.logWarning(new CallerInfo(){}, "No SELECT generated for " + tableIdentifier.getTableExpression() + ". Most probably the table was not fund");
                JdbcUtils.closeAll(resultSet, this.searchQuery);
                return;
            }
            try {
                if (this.consumer != null) {
                    this.consumer.setCurrentTable(tableIdentifier.getTableName(), string, l, l2);
                }
                this.searchQuery = this.connection.createStatementForQuery();
                resultSet = this.searchQuery.executeQuery(string);
                ResultInfo resultInfo = new ResultInfo(resultSet.getMetaData(), this.connection);
                DataStore dataStore = new DataStore(resultSet.getMetaData(), this.connection);
                String string2 = "-- " + ResourceMgr.getFormattedString("TxtSearchFilter", this.comparator.getUserDisplay() + " '" + this.searchString + "'\n\n");
                dataStore.setGeneratingSql(string2 + string);
                dataStore.setResultName(tableIdentifier.getTableName());
                dataStore.setUpdateTableToBeUsed(tableIdentifier);
                boolean bl = this.connection.trimCharData();
                this.searcher.setBlobTextEncoding(this.blobEncoding);
                RowDataReader rowDataReader = RowDataReaderFactory.createReader(resultInfo, this.connection);
                while (resultSet.next() && !this.cancelSearch) {
                    RowData rowData = rowDataReader.read(resultSet, bl);
                    if (this.searcher.isSearchStringContained(rowData, resultInfo, this.showOnlyMatchedColumns)) {
                        dataStore.addRow(rowData);
                    }
                    rowDataReader.closeStreams();
                    if (dataStore.getRowCount() <= this.maxRows) continue;
                    break;
                }
                if (this.consumer != null) {
                    this.consumer.tableSearched(tableIdentifier, dataStore);
                }
                this.connection.releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Error searching table", throwable);
                    this.connection.rollback(savepoint);
                    break block12;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    JdbcUtils.closeAll(resultSet, this.searchQuery);
                }
            }
            JdbcUtils.closeAll(resultSet, this.searchQuery);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    public void setComparator(ColumnComparator columnComparator) {
        this.comparator = columnComparator;
    }

    @Override
    public void setCriteria(String string, boolean bl) {
        this.setCriteria(string, bl, null);
    }

    public void setCriteria(String string, boolean bl, Collection<String> collection) {
        if (StringUtil.isNonBlank(string)) {
            this.searchString = string.trim();
            if (this.searchString.charAt(0) == '%') {
                this.searchString = this.searchString.substring(1);
            }
            if (this.searchString.endsWith("%")) {
                this.searchString = this.searchString.substring(0, this.searchString.length() - 2);
            }
        } else {
            this.searchString = null;
        }
        this.searcher = new RowDataSearcher(this.searchString, this.comparator, bl);
        this.searcher.setColumnsToSearch(collection);
    }

    @Override
    public void setConsumer(TableSearchConsumer tableSearchConsumer) {
        this.consumer = tableSearchConsumer;
    }

    @Override
    public void setRetrieveLobColumns(boolean bl) {
        this.includeBLOBs = bl;
        this.includeCLOBs = bl;
        this.blobEncoding = null;
    }

    @Override
    public void setMaxRows(int n) {
        this.maxRows = n <= 0 ? Integer.MAX_VALUE : n;
    }

    @Override
    public void setTableNames(List<TableIdentifier> list) {
        this.tablesToSearch = CollectionUtil.arrayList(list);
    }

    @Override
    public ColumnExpression getSearchExpression() {
        return this.searcher.getExpression();
    }
}

