/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.shutdown;

import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.ConnectionMgr;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.shutdown.DbShutdownHook;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class HsqlShutdownHook
implements DbShutdownHook {
    private boolean canShutdown(WbConnection wbConnection) {
        String string = wbConnection.getUrl();
        if (string == null) {
            return true;
        }
        return !string.startsWith("jdbc:hsqldb:hsql:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return;
        }
        boolean bl = ConnectionMgr.getInstance().isActive(wbConnection);
        if (bl) {
            return;
        }
        if (this.canShutdown(wbConnection)) {
            Statement statement = null;
            try {
                statement = wbConnection.createStatement();
                LogMgr.logInfo(new CallerInfo(){}, "Local HSQL connection detected. Sending SHUTDOWN to the engine before disconnecting");
                statement.executeUpdate("SHUTDOWN");
            }
            finally {
                JdbcUtils.closeStatement(statement);
            }
        }
        wbConnection.shutdown();
    }
}

