/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.sqltemplates;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.CommentSqlManager;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.db.sqltemplates.ColumnDefinitionTemplate;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ColumnChanger {
    public static final String PARAM_NEW_COL_NAME = "%new_column_name%";
    public static final String PARAM_DATATYPE = "%datatype%";
    public static final String PARAM_NEW_DATATYPE = "%new_datatype%";
    public static final String PARAM_DEFAULT_EXPR = "%default_expression%";
    public static final String PARAM_NULLABLE = "%nullable%";
    public static final String PARAM_DEFAULT_VALUE = "%default_value%";
    private WbConnection dbConn;
    private DbSettings dbSettings;
    private CommentSqlManager commentMgr;

    public ColumnChanger(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.dbSettings = wbConnection != null ? wbConnection.getDbSettings() : null;
        this.commentMgr = new CommentSqlManager(this.dbSettings != null ? this.dbSettings.getDbId() : "");
    }

    ColumnChanger(DbSettings dbSettings) {
        this.dbConn = null;
        this.dbSettings = dbSettings;
        this.commentMgr = new CommentSqlManager(this.dbSettings != null ? this.dbSettings.getDbId() : "");
    }

    public String getAlterScript(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        String string2;
        Object object;
        List<String> list = this.getAlterStatements(tableIdentifier, columnIdentifier, columnIdentifier2);
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 50);
        if (this.dbConn != null && this.dbConn.getMetadata().isOracle() && columnIdentifier != null && !StringUtil.equalStringOrEmpty((String)(object = columnIdentifier.getComment()), string2 = columnIdentifier2.getComment()) && !OracleUtils.remarksEnabled(this.dbConn)) {
            stringBuilder.append("-- ");
            stringBuilder.append(ResourceMgr.getString("MsgSchemaReporterOracleRemarksWarning"));
            stringBuilder.append('\n');
        }
        for (String string2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    public List<String> getAlterStatements(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        List<String> list = CollectionUtil.arrayList();
        if (columnIdentifier == null && this.canAddColumn()) {
            String string;
            String string2 = this.addColumn(tableIdentifier, columnIdentifier2);
            if (string2 != null) {
                list.add(string2);
            }
            if (StringUtil.isNonBlank(columnIdentifier2.getComment()) && (string = this.changeRemarks(tableIdentifier, null, columnIdentifier2)) != null) {
                list.add(string);
            }
        } else if (columnIdentifier != null) {
            String string = this.changeDataType(tableIdentifier, columnIdentifier, columnIdentifier2);
            if (string != null) {
                list.add(SqlUtil.trimSemicolon(string));
            }
            if ((string = this.changeDefault(tableIdentifier, columnIdentifier, columnIdentifier2)) != null) {
                list.add(SqlUtil.trimSemicolon(string));
            }
            if ((string = this.changeNullable(tableIdentifier, columnIdentifier, columnIdentifier2)) != null) {
                list.add(SqlUtil.trimSemicolon(string));
            }
            if ((string = this.changeRemarks(tableIdentifier, columnIdentifier, columnIdentifier2)) != null) {
                list.add(SqlUtil.trimSemicolon(string));
            }
            if ((string = this.renameColumn(tableIdentifier, columnIdentifier, columnIdentifier2)) != null) {
                list.add(SqlUtil.trimSemicolon(string));
            }
        }
        return list;
    }

    protected String changeCommonPlaceholders(String string, ColumnIdentifier columnIdentifier) {
        string = string.replace(PARAM_NULLABLE, this.nullableSql(columnIdentifier.isNullable()));
        String string2 = columnIdentifier.getComment();
        if (string2 == null) {
            string2 = "";
        }
        string = string.replace("%comment%", string2.replace("'", "''"));
        String string3 = columnIdentifier.getDefaultValue();
        if (StringUtil.isBlank(string3)) {
            string = string.replace("DEFAULT %default_value%", "");
            string = string.replace(PARAM_DEFAULT_VALUE, "");
        } else {
            string = string.replace(PARAM_DEFAULT_VALUE, string3);
        }
        String string4 = columnIdentifier.getDbmsType();
        string = string.replace(PARAM_NEW_DATATYPE, string4);
        string = string.replace(PARAM_DATATYPE, string4);
        return string;
    }

    public boolean canAlterType() {
        String string = this.dbSettings.getAlterColumnDataTypeSql();
        return string != null;
    }

    public boolean canRenameColumn() {
        String string = this.dbSettings.getRenameColumnSql();
        return string != null;
    }

    public boolean canChangeNullable() {
        String string = this.dbSettings.getAlterColumnDropNotNull();
        String string2 = this.dbSettings.getAlterColumnSetNotNull();
        return string != null && string2 != null;
    }

    public boolean canChangeDefault() {
        String string = this.dbSettings.getAlterColumnDefaultSql();
        String string2 = this.dbSettings.getSetColumnDefaultSql();
        String string3 = this.dbSettings.getDropColumnDefaultSql();
        return string != null || string2 != null && string3 != null;
    }

    public boolean canAddColumn() {
        String string = this.dbSettings.getAddColumnSql();
        return string != null;
    }

    public boolean canChangeComment() {
        String string = this.commentMgr.getCommentSqlTemplate("column", null);
        return string != null;
    }

    protected String getColumnExpression(ColumnIdentifier columnIdentifier) {
        String string = columnIdentifier.getColumnName();
        if (this.dbConn == null) {
            return string;
        }
        if (!this.dbConn.getDbSettings().useQuotedColumnsForComments()) {
            return this.dbConn.getMetadata().removeQuotes(string);
        }
        if (this.dbConn.getMetadata().isReservedWord(string)) {
            return this.dbConn.getMetadata().quoteObjectname(string);
        }
        return string;
    }

    protected String addColumn(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return null;
        }
        String string = this.dbSettings.getAddColumnSql();
        string = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.dbConn, false);
        string = string.replace("%column_name%", this.getColumnExpression(columnIdentifier));
        string = string.replace(PARAM_DATATYPE, columnIdentifier.getDbmsType());
        string = StringUtil.isBlank(columnIdentifier.getDefaultValue()) ? string.replace(PARAM_DEFAULT_EXPR, "") : string.replace(PARAM_DEFAULT_EXPR, "DEFAULT " + columnIdentifier.getDefaultValue());
        string = ColumnDefinitionTemplate.replaceNullable(string, this.dbSettings.getDbId(), columnIdentifier.isNullable(), null);
        return string;
    }

    protected boolean dataTypeChanged(ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        String string = columnIdentifier.getDbmsType();
        String string2 = columnIdentifier2.getDbmsType();
        return !string.trim().equalsIgnoreCase(string2.trim());
    }

    protected String changeDataType(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        String string = this.dbSettings.getAlterColumnDataTypeSql();
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (!this.dataTypeChanged(columnIdentifier, columnIdentifier2)) {
            return null;
        }
        string = string.replace("%column_name%", this.getColumnExpression(columnIdentifier));
        string = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.dbConn, false);
        string = string.replace(PARAM_DATATYPE, columnIdentifier.getDbmsType());
        string = string.replace(PARAM_NEW_DATATYPE, columnIdentifier2.getDbmsType());
        string = this.changeCommonPlaceholders(string, columnIdentifier2);
        return string;
    }

    protected String renameColumn(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        String string = this.dbSettings.getRenameColumnSql();
        if (StringUtil.isBlank(string)) {
            return null;
        }
        String string2 = this.getColumnExpression(columnIdentifier);
        String string3 = this.getColumnExpression(columnIdentifier2);
        if (string2.trim().equalsIgnoreCase(string3.trim())) {
            return null;
        }
        string = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.dbConn, false);
        string = string.replace("%column_name%", this.getColumnExpression(columnIdentifier));
        string = string.replace(PARAM_NEW_COL_NAME, this.getColumnExpression(columnIdentifier2));
        string = this.changeCommonPlaceholders(string, columnIdentifier2);
        return string;
    }

    private boolean nullableChanged(ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        boolean bl;
        boolean bl2 = columnIdentifier.isNullable();
        return bl2 != (bl = columnIdentifier2.isNullable());
    }

    private String changeNullable(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        boolean bl;
        boolean bl2 = columnIdentifier.isNullable();
        if (bl2 == (bl = columnIdentifier2.isNullable())) {
            return null;
        }
        String string = this.dbSettings.getAlterColumnDropNotNull();
        String string2 = this.dbSettings.getAlterColumnSetNotNull();
        String string3 = null;
        if (bl2 && !bl) {
            if (string2 == null) {
                return null;
            }
            string3 = string2;
        } else if (!bl2 && bl) {
            string3 = string;
        }
        if (string3 != null) {
            string3 = TemplateHandler.replaceTablePlaceholder(string3, tableIdentifier, this.dbConn, false);
            string3 = string3.replace("%column_name%", this.getColumnExpression(columnIdentifier));
            string3 = string3.replace(PARAM_DATATYPE, columnIdentifier.getDbmsType());
            string3 = string3.replace(PARAM_NEW_DATATYPE, columnIdentifier2.getDbmsType());
        }
        string3 = this.changeCommonPlaceholders(string3, columnIdentifier2);
        return string3;
    }

    private String changeRemarks(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        String string;
        String string2;
        String string3;
        String string4 = columnIdentifier == null ? "" : columnIdentifier.getComment();
        if (StringUtil.equalStringOrEmpty(string4, string3 = columnIdentifier2.getComment())) {
            return null;
        }
        if (StringUtil.isBlank(string3)) {
            string3 = "";
        }
        if (StringUtil.isBlank(string2 = this.commentMgr.getCommentSqlTemplate("column", string = CommentSqlManager.getAction(string4, string3)))) {
            return null;
        }
        string2 = string2.replace("%fq_object_name%", tableIdentifier.getFullyQualifiedName(this.dbConn));
        string2 = string2.replace("%object_name%", tableIdentifier.getObjectExpression(this.dbConn));
        string2 = TemplateHandler.replaceTablePlaceholder(string2, tableIdentifier, this.dbConn, false);
        string2 = string2.replace("%schema%", tableIdentifier.getSchema() == null ? "" : tableIdentifier.getSchema());
        string2 = string2.replace("%column_name%", this.getColumnExpression(columnIdentifier == null ? columnIdentifier2 : columnIdentifier));
        string2 = string2.replace("%comment%", string3.replace("'", "''"));
        string2 = string2.replace(PARAM_DATATYPE, columnIdentifier2.getDbmsType());
        if (columnIdentifier != null) {
            string2 = string2.replace(PARAM_DATATYPE, columnIdentifier.getDbmsType());
        }
        if (columnIdentifier2 != null) {
            string2 = string2.replace(PARAM_NEW_DATATYPE, columnIdentifier2.getDbmsType());
        }
        return string2;
    }

    public String getColumnCommentSql(DbObject dbObject, ColumnIdentifier columnIdentifier) {
        String string = columnIdentifier.getComment();
        if (StringUtil.isBlank(string)) {
            string = "";
        }
        String string2 = this.commentMgr.getCommentSqlTemplate("column", "set");
        string2 = string2.replace("%fq_object_name%", dbObject.getFullyQualifiedName(this.dbConn));
        string2 = string2.replace("%object_name%", dbObject.getObjectExpression(this.dbConn));
        string2 = TemplateHandler.replaceTablePlaceholder(string2, dbObject, this.dbConn, false);
        string2 = string2.replace("%schema%", dbObject.getSchema() == null ? "" : dbObject.getSchema());
        string2 = string2.replace("%column_name%", this.getColumnExpression(columnIdentifier));
        string2 = string2.replace("%comment%", string.replace("'", "''"));
        string2 = string2.replace(PARAM_DATATYPE, columnIdentifier.getDbmsType());
        if (columnIdentifier != null) {
            string2 = string2.replace(PARAM_NEW_DATATYPE, columnIdentifier.getDbmsType());
        }
        return string2;
    }

    private String changeDefault(TableIdentifier tableIdentifier, ColumnIdentifier columnIdentifier, ColumnIdentifier columnIdentifier2) {
        String string = this.dbSettings.getAlterColumnDefaultSql();
        String string2 = this.dbSettings.getSetColumnDefaultSql();
        String string3 = this.dbSettings.getDropColumnDefaultSql();
        String string4 = columnIdentifier.getDefaultValue();
        String string5 = columnIdentifier2.getDefaultValue();
        String string6 = null;
        if (string4 == null && string5 == null) {
            return null;
        }
        if (string4 != null && string4.equals(string5)) {
            return null;
        }
        if (string4 != null && string5 == null) {
            if (string3 == null) {
                return null;
            }
            string6 = TemplateHandler.replaceTablePlaceholder(string3, tableIdentifier, this.dbConn, false);
        }
        if (string5 != null) {
            if (string2 != null) {
                string6 = TemplateHandler.replaceTablePlaceholder(string2, tableIdentifier, this.dbConn, false);
                string6 = string6.replace(PARAM_DEFAULT_VALUE, string5);
            } else if (string != null) {
                string6 = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.dbConn, false);
                string6 = string6.replace(PARAM_DEFAULT_VALUE, string5);
            }
        }
        if (string6 != null) {
            string6 = string6.replace("%column_name%", this.getColumnExpression(columnIdentifier));
            string6 = string6.replace(PARAM_DATATYPE, columnIdentifier.getDbmsType());
            string6 = string6.replace(PARAM_NEW_DATATYPE, columnIdentifier2.getDbmsType());
        }
        return string6;
    }

    private String nullableSql(boolean bl) {
        if (bl) {
            return Settings.getInstance().getProperty("workbench.db." + this.dbSettings.getDbId() + ".nullkeyword", "NULL");
        }
        return "NOT NULL";
    }
}

