/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui;

import java.io.File;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class WindowTitleBuilder {
    private static final int NAME_AT_END = 1;
    private static final int NAME_AT_START = 2;
    private boolean showProfileGroup = GuiSettings.getShowProfileGroupInWindowTitle();
    private boolean showURL = GuiSettings.getShowURLinWindowTitle();
    private boolean includeUser = GuiSettings.getIncludeUserInTitleURL();
    private int productNamePosition = 2;
    private boolean showWorkspace = GuiSettings.getShowWorkspaceInWindowTitle();
    private boolean showNotConnected = true;

    public WindowTitleBuilder() {
        this.setShowProductNameAtEnd(GuiSettings.getShowProductNameAtEnd());
    }

    public void setShowProfileGroup(boolean bl) {
        this.showProfileGroup = bl;
    }

    public void setShowURL(boolean bl) {
        this.showURL = bl;
    }

    public void setIncludeUser(boolean bl) {
        this.includeUser = bl;
    }

    public void setShowProductNameAtEnd(boolean bl) {
        this.productNamePosition = bl ? 1 : 2;
    }

    public void setShowWorkspace(boolean bl) {
        this.showWorkspace = bl;
    }

    public void setShowNotConnected(boolean bl) {
        this.showNotConnected = bl;
    }

    public String getWindowTitle(WbConnection wbConnection) {
        return this.getWindowTitle(wbConnection, null, null);
    }

    public String getWindowTitle(WbConnection wbConnection, String string, String string2) {
        return this.getWindowTitle(wbConnection, string, string2, "SQL Workbench/J");
    }

    public String getWindowTitle(WbConnection wbConnection, String string, String string2, String string3) {
        Object object;
        int n;
        String string4;
        StringBuilder stringBuilder = new StringBuilder(50);
        ConnectionProfile connectionProfile = wbConnection != null ? wbConnection.getProfile() : null;
        String string5 = string4 = wbConnection != null ? wbConnection.getDisplayUser() : null;
        if (string3 != null && this.productNamePosition == 2) {
            stringBuilder.append(string3);
            stringBuilder.append(' ');
        }
        if (connectionProfile != null) {
            int n2 = n = this.includeUser || connectionProfile.getPromptForUsername() ? 1 : 0;
            if (this.showURL) {
                if (this.showProfileGroup) {
                    this.appendProfileName(stringBuilder, connectionProfile);
                }
                object = this.makeCleanUrl(connectionProfile.getActiveUrl());
                if (n != 0 && string4 != null) {
                    stringBuilder.append(string4);
                    if (((String)object).charAt(0) != '@') {
                        stringBuilder.append('@');
                    }
                }
                stringBuilder.append((String)object);
            } else {
                if (connectionProfile.getPromptForUsername()) {
                    stringBuilder.append(string4);
                    stringBuilder.append(" - ");
                }
                if (this.showProfileGroup) {
                    this.appendProfileName(stringBuilder, connectionProfile);
                }
                stringBuilder.append(connectionProfile.getName());
            }
        } else if (this.showNotConnected) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("- ");
            }
            stringBuilder.append(ResourceMgr.getString("TxtNotConnected"));
        }
        if (StringUtil.isNonBlank(string) && this.showWorkspace) {
            File file = new File(string);
            object = file.getName();
            stringBuilder.append(" - ");
            stringBuilder.append((String)object);
            stringBuilder.append(" ");
        }
        n = GuiSettings.getShowFilenameInWindowTitle();
        if (StringUtil.isNonBlank(string2) && n != 0) {
            stringBuilder.append(" - ");
            if (n == 2) {
                stringBuilder.append(string2);
            } else {
                object = new File(string2);
                stringBuilder.append(((File)object).getName());
            }
        }
        if (StringUtil.isNonBlank(string3) && this.productNamePosition == 1) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" - ");
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private void appendProfileName(StringBuilder stringBuilder, ConnectionProfile connectionProfile) {
        String string = GuiSettings.getTitleGroupBracket();
        String string2 = GuiSettings.getTitleGroupSeparator();
        char c = this.getOpeningBracket(string);
        char c2 = this.getClosingBracket(string);
        if (c != '\u0000' && c2 != '\u0000') {
            stringBuilder.append(c);
        }
        stringBuilder.append(connectionProfile.getGroup());
        if (c != '\u0000' && c2 != '\u0000') {
            stringBuilder.append(c2);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
    }

    private char getOpeningBracket(String string) {
        if (StringUtil.isEmptyString(string)) {
            return '\u0000';
        }
        return string.charAt(0);
    }

    private char getClosingBracket(String string) {
        if (StringUtil.isEmptyString(string)) {
            return '\u0000';
        }
        char c = this.getOpeningBracket(string);
        if (c == '{') {
            return '}';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '(') {
            return ')';
        }
        if (c == '<') {
            return '>';
        }
        return '\u0000';
    }

    public String makeCleanUrl(String string) {
        int n;
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        string = string.replace("jdbc:", "");
        if (GuiSettings.getCleanupURLParametersInWindowTitle()) {
            n = string.indexOf(38);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(59)) > 0) {
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(63)) > 0) {
                string = string.substring(0, n);
            }
        } else {
            string = string.replaceFirst("(?i)(integratedSecurity=true);*", "");
        }
        if (GuiSettings.getRemoveJDBCProductInWindowTitle()) {
            if (string.contains("oracle:")) {
                string = string.replace("oracle:thin:", "");
                string = string.replace("oracle:oci:", "");
            } else if (string.contains("jtds:sqlserver:")) {
                string = string.replace("jtds:sqlserver:", "");
            } else {
                n = string.indexOf(58);
                if (n > 0) {
                    string = string.substring(n + 1);
                }
            }
        }
        return string;
    }
}

