/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import workbench.db.WbConnection;
import workbench.gui.actions.WbAction;
import workbench.gui.completion.CompletionHandler;
import workbench.gui.editor.JEditTextArea;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class AutoCompletionAction
extends WbAction {
    private CompletionHandler handler;
    private JEditTextArea editor;
    private StatusBar status;

    public AutoCompletionAction(JEditTextArea jEditTextArea, StatusBar statusBar) {
        this.editor = jEditTextArea;
        this.status = statusBar;
        this.initMenuDefinition("MnuTxtAutoComplete", KeyStroke.getKeyStroke(32, 2));
        this.setMenuItemName("MnuTxtSQL");
        this.setEnabled(false);
        jEditTextArea.addKeyBinding(this);
    }

    public void closePopup() {
        if (this.handler != null) {
            this.handler.cancelPopup();
        }
    }

    public void setConnection(WbConnection wbConnection) {
        if (wbConnection == null) {
            this.handler = null;
        } else if (this.handler == null) {
            try {
                this.handler = new CompletionHandler();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error setting connection", exception);
            }
        }
        if (wbConnection != null) {
            this.handler.setStatusBar(this.status);
            this.handler.setEditor(this.editor);
            this.handler.setConnection(wbConnection);
        }
        this.setEnabled(wbConnection != null);
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.getAccelerator();
        this.editor.removeKeyBinding(keyStroke2);
        super.setAccelerator(keyStroke);
        this.editor.addKeyBinding(this);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.handler.showCompletionPopup();
    }
}

