/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.resource.Settings;

public class CopyAllColumnNamesAction
extends WbAction {
    private static final long serialVersionUID = 5433513843703540824L;
    private WbTable client;

    public CopyAllColumnNamesAction(WbTable wbTable) {
        this.client = wbTable;
        this.isConfigurable = false;
        this.initMenuDefinition("MnuTxtCopyAllColNames");
        this.removeIcon();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        int n = this.client.getColumnCount();
        if (n > 0) {
            boolean bl = Settings.getInstance().getFormatterAddSpaceAfterComma();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                String string = this.client.getColumnName(i);
                stringBuilder.append(string);
                if (i + 1 == n) continue;
                stringBuilder.append(",");
                if (!bl) continue;
                stringBuilder.append(" ");
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(stringBuilder.toString()), null);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

