/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import workbench.db.ColumnDropper;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.GenericObjectDropper;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ObjectDropperUI;
import workbench.interfaces.ObjectDropListener;
import workbench.interfaces.ObjectDropper;
import workbench.interfaces.Reloadable;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;
import workbench.util.CollectionUtil;

public class DropDbObjectAction
extends WbAction
implements WbSelectionListener {
    private DbObjectList source;
    private ObjectDropper dropper;
    private ObjectDropListener dropListener;
    private Reloadable data;
    private boolean available = true;
    private WbSelectionModel selection;

    public DropDbObjectAction(String string, DbObjectList dbObjectList, ListSelectionModel listSelectionModel, Reloadable reloadable) {
        this("MnuTxtDropDbObject", dbObjectList, WbSelectionModel.Factory.createFacade(listSelectionModel), reloadable);
    }

    public DropDbObjectAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel, Reloadable reloadable) {
        this("MnuTxtDropDbObject", dbObjectList, wbSelectionModel, reloadable);
    }

    public DropDbObjectAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        this("MnuTxtDropDbObject", dbObjectList, wbSelectionModel, null);
    }

    public DropDbObjectAction(String string, DbObjectList dbObjectList, WbSelectionModel wbSelectionModel, Reloadable reloadable) {
        this.initMenuDefinition(string);
        this.source = dbObjectList;
        this.data = reloadable;
        this.selection = wbSelectionModel;
        this.selectionChanged(wbSelectionModel);
        this.selection.addSelectionListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
        }
    }

    public void addDropListener(ObjectDropListener objectDropListener) {
        this.dropListener = objectDropListener;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.dropObjects();
    }

    public void setAvailable(boolean bl) {
        this.available = bl;
        if (!this.available) {
            this.setEnabled(false);
        }
    }

    public void setDropper(ObjectDropper objectDropper) {
        this.dropper = objectDropper;
    }

    private boolean needAutoCommit(List<DbObject> list) {
        DbSettings dbSettings = this.source.getConnection().getDbSettings();
        for (DbObject dbObject : list) {
            if (dbSettings.canDropInTransaction(dbObject.getObjectType())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropObjects() {
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<DbObject> list = this.source.getSelectedObjects();
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = this.source.getConnection().getAutoCommit();
        ObjectDropperUI objectDropperUI = null;
        try {
            ObjectDropper objectDropper;
            if (bl2 && !this.source.getConnection().getProfile().getAutocommit()) {
                this.source.getConnection().changeAutoCommit(false);
                bl = true;
            }
            if (!bl2 && this.needAutoCommit(list)) {
                this.source.getConnection().changeAutoCommit(true);
                bl = true;
            }
            if ((objectDropper = this.dropper) == null) {
                objectDropper = list.get(0) instanceof ColumnIdentifier ? new ColumnDropper() : new GenericObjectDropper();
            }
            objectDropper.setObjects(list);
            objectDropper.setConnection(this.source.getConnection());
            objectDropper.setObjectTable(this.source.getObjectTable());
            objectDropperUI = new ObjectDropperUI(objectDropper);
            JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this.source.getComponent());
            objectDropperUI.showDialog(jFrame);
        }
        finally {
            if (bl) {
                this.source.getConnection().changeAutoCommit(bl2);
            }
        }
        if (objectDropperUI.success() && !objectDropperUI.dialogWasCancelled()) {
            EventQueue.invokeLater(() -> {
                if (this.data != null) {
                    this.data.reload();
                }
                if (this.dropListener != null) {
                    this.dropListener.objectsDropped(list);
                }
            });
        }
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        WbConnection wbConnection = this.source.getConnection();
        if (wbConnection == null || wbConnection.isSessionReadOnly()) {
            this.setEnabled(false);
        } else {
            List<DbObject> list = this.source.getSelectedObjects();
            if (CollectionUtil.isEmpty(list)) {
                this.setEnabled(false);
                return;
            }
            int n = 0;
            int n2 = list.size();
            for (DbObject dbObject : list) {
                if (!(dbObject instanceof ColumnIdentifier)) continue;
                ++n;
            }
            if (n > 0 && n == n2) {
                TableIdentifier tableIdentifier = this.source.getObjectTable();
                this.setEnabled(tableIdentifier != null);
            } else {
                this.setEnabled(this.available && n == 0 && n2 > 0);
            }
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

