/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DropDownButton;
import workbench.gui.components.WbMenuItem;
import workbench.gui.components.WbTable;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.filter.FilterExpression;
import workbench.util.CollectionUtil;
import workbench.util.WbFile;

public class FilterPickerAction
extends WbAction
implements PropertyChangeListener,
ActionListener {
    private WbTable client;
    private DropDownButton dropDownButton;
    private FilterDefinitionManager filterMgr;
    private WbAction[] additionalActions;

    public FilterPickerAction(WbTable wbTable) {
        this(wbTable, FilterDefinitionManager.getDefaultInstance(), null);
    }

    public FilterPickerAction(WbTable wbTable, FilterDefinitionManager filterDefinitionManager, WbAction ... wbActionArray) {
        this.client = wbTable;
        this.initMenuDefinition("MnuTxtPickFilter");
        this.setIcon("dropdown");
        this.setMenuItemName("MnuTxtData");
        this.additionalActions = wbActionArray;
        this.filterMgr = filterDefinitionManager;
        this.buildPopup();
        this.filterMgr.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.client == null) {
            return;
        }
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            try {
                FilterExpression filterExpression = this.filterMgr.loadFilter(string);
                this.client.applyFilter(filterExpression);
                String string2 = "<html>" + ResourceMgr.getDescription("MnuTxtPickFilter");
                string2 = string2 + "<br>(" + string + ")</html>";
                this.dropDownButton.setToolTipText(string2);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error loading filter", exception);
                Window window = SwingUtilities.getWindowAncestor(this.client);
                WbSwingUtilities.showErrorMessage(window, "Could not load filter: " + exception.getMessage());
                this.dropDownButton.setToolTipText(ResourceMgr.getDescription("MnuTxtPickFilter"));
            }
        }
    }

    private void checkEnabled() {
        if (this.client == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.hasAdditionalActions() || this.filterMgr.getEntries().size() > 0);
        }
    }

    public void setClient(WbTable wbTable) {
        this.client = wbTable;
        this.checkEnabled();
    }

    @Override
    public JButton getToolbarButton(boolean bl) {
        DropDownButton dropDownButton = null;
        if (this.dropDownButton == null || bl) {
            ImageIcon imageIcon = IconMgr.getInstance().getToolbarIcon("dropdown");
            DropDownButton dropDownButton2 = new DropDownButton(imageIcon);
            dropDownButton2.setAction(this);
            dropDownButton2.setText(null);
            dropDownButton2.setMnemonic(0);
            int n = imageIcon.getIconWidth();
            int n2 = imageIcon.getIconHeight();
            Dimension dimension = new Dimension(n, n2);
            dropDownButton2.setMaximumSize(dimension);
            dropDownButton2.setPreferredSize(dimension);
            dropDownButton2.setMinimumSize(dimension);
            if (this.dropDownButton == null) {
                this.dropDownButton = dropDownButton2;
            }
            dropDownButton = dropDownButton2;
        } else {
            dropDownButton = this.dropDownButton;
        }
        return dropDownButton;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.buildPopup();
    }

    private boolean hasAdditionalActions() {
        return this.additionalActions != null && this.additionalActions.length > 0;
    }

    private void buildPopup() {
        List<WbFile> list = this.filterMgr.getEntries();
        if (list == null && !this.hasAdditionalActions()) {
            return;
        }
        JMenu jMenu = new JMenu("filters");
        if (CollectionUtil.isNonEmpty(list)) {
            for (WbFile wbFile : list) {
                WbMenuItem wbMenuItem = new WbMenuItem(wbFile.getName());
                wbMenuItem.setToolTipText(wbFile.getFullPath());
                wbMenuItem.setActionCommand(wbFile.getFullPath());
                wbMenuItem.addActionListener(this);
                jMenu.add(wbMenuItem);
            }
        }
        if (this.hasAdditionalActions()) {
            if (list.size() > 0) {
                jMenu.addSeparator();
            }
            for (WbAction wbAction : this.additionalActions) {
                WbMenuItem wbMenuItem = new WbMenuItem();
                wbMenuItem.setAction(wbAction);
                jMenu.add(wbMenuItem);
            }
        }
        if (this.dropDownButton == null) {
            this.getToolbarButton();
        }
        this.dropDownButton.setDropDownMenu(jMenu.getPopupMenu());
        this.checkEnabled();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.dropDownButton != null) {
            this.dropDownButton.dispose();
            this.dropDownButton = null;
        }
        if (this.filterMgr != null) {
            this.filterMgr.removePropertyChangeListener(this);
        }
    }
}

