/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.interfaces.MainPanel;
import workbench.util.BrowserLauncher;
import workbench.util.ExceptionUtil;

public class HelpContactAction
extends WbAction {
    private MainWindow mainWindow;

    public HelpContactAction(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.initMenuDefinition("MnuTxtHelpContact");
        this.removeIcon();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.sendEmail();
    }

    private void sendEmail() {
        HelpContactAction.sendEmail(this.mainWindow);
    }

    public static void sendEmail(MainWindow mainWindow) {
        WbConnection wbConnection = null;
        if (mainWindow != null) {
            wbConnection = mainWindow.getCurrentPanel().map(MainPanel::getConnection).orElse(null);
        }
        try {
            BrowserLauncher.openEmail("support@sql-workbench.eu", wbConnection);
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
        }
    }
}

