/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Color;
import java.sql.SQLException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.ListModel;
import workbench.gui.completion.CompletionPopup;
import workbench.gui.editor.JEditTextArea;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.fksupport.JoinCondition;
import workbench.sql.fksupport.JoinCreator;
import workbench.util.StringUtil;
import workbench.util.TableAlias;

public class JoinCompletionPopup
extends CompletionPopup {
    private JoinCreator creator;
    private StatusBar statusBar;

    public JoinCompletionPopup(JEditTextArea jEditTextArea, List list, JoinCreator joinCreator) {
        super(jEditTextArea, JoinCompletionPopup.getHeader(), JoinCompletionPopup.getModel(list));
        this.elementList.setSelectionMode(0);
        this.creator = joinCreator;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    private static JLabel getHeader() {
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblCompletionListTables"));
        jLabel.setForeground(Color.BLUE);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jLabel;
    }

    private static ListModel getModel(List list) {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (Object e : list) {
            defaultListModel.addElement(e);
        }
        return defaultListModel;
    }

    public void showPopup() {
        super.showPopup(null, false);
    }

    @Override
    protected void doPaste() {
        Object e = this.elementList.getSelectedValue();
        if (e == null) {
            return;
        }
        try {
            List<JoinCondition> list;
            String string = null;
            if (e instanceof JoinCondition) {
                string = this.creator.getJoinCondition((JoinCondition)e);
            } else if (e instanceof TableAlias && (list = this.creator.getJoinConditions((TableAlias)e)).size() > 1) {
                string = this.creator.getJoinCondition(list.get(0));
            }
            if (StringUtil.isNonBlank(string)) {
                this.editor.insertText(string + " ");
            } else if (this.statusBar != null) {
                this.statusBar.setStatusMessage(ResourceMgr.getString("MsgComplNoFK"), 2500);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve join condition", sQLException);
        }
    }
}

