/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ValuesCreatorParameter;
import workbench.gui.actions.WbAction;
import workbench.gui.editor.ValuesListCreator;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.TextSelectionListener;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class MakeValuesListAction
extends WbAction
implements TextSelectionListener {
    private EditorPanel client;

    public MakeValuesListAction(EditorPanel editorPanel) {
        this.client = editorPanel;
        this.client.addSelectionListener(this);
        this.initMenuDefinition("MnuTxtMakeValuesList");
        this.setMenuItemName("MnuTxtSQL");
        this.setEnabled(false);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.client.getSelectedText();
        if (StringUtil.isBlank(string)) {
            return;
        }
        ValuesCreatorParameter valuesCreatorParameter = new ValuesCreatorParameter(string);
        Window window = WbSwingUtilities.getWindowAncestor(this.client);
        boolean bl = WbSwingUtilities.getOKCancel(ResourceMgr.getString("MnuTxtMakeValuesList"), window, valuesCreatorParameter, () -> valuesCreatorParameter.setFocusToInput());
        if (!bl) {
            return;
        }
        valuesCreatorParameter.saveSettings();
        ValuesListCreator valuesListCreator = new ValuesListCreator(string, valuesCreatorParameter.getDelimiter(), valuesCreatorParameter.isRegex());
        valuesListCreator.setEmptyStringIsNull(valuesCreatorParameter.getEmptyStringIsNull());
        valuesListCreator.setTrimDelimiter(valuesCreatorParameter.getTrimDelimiter());
        String string2 = Settings.getInstance().getInternalEditorLineEnding();
        valuesListCreator.setLineEnding(string2);
        String string3 = valuesListCreator.createValuesList();
        string3 = string3 + string2;
        if (StringUtil.isNonBlank(string3)) {
            this.client.setSelectedText(string3);
        }
    }

    @Override
    public void selectionChanged(int n, int n2) {
        this.setEnabled(this.client.getSelectionLength() > 0);
    }
}

