/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import workbench.db.DbObject;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.TableExporter;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.Exporter;
import workbench.interfaces.TextSelectionListener;
import workbench.util.CollectionUtil;

public class SpoolDataAction
extends WbAction
implements TextSelectionListener {
    private EditorPanel editor;
    private boolean canExport = false;
    private DbObjectList objects;
    private Exporter dataExporter;

    public SpoolDataAction(DbObjectList dbObjectList) {
        this(dbObjectList, "MnuTxtSpoolData");
    }

    public SpoolDataAction(DbObjectList dbObjectList, String string) {
        this.objects = dbObjectList;
        this.initMenuDefinition(string);
        this.setIcon("spool-data");
        this.setMenuItemName("MnuTxtSQL");
        this.setEnabled(DbObjectList.Util.getSelectedTableObjects(dbObjectList).size() > 0);
    }

    public SpoolDataAction(Exporter exporter, String string) {
        this.dataExporter = exporter;
        this.initMenuDefinition(string);
        this.setIcon("spool-data");
        this.setMenuItemName("MnuTxtSQL");
        this.setEnabled(false);
    }

    public void canExport(boolean bl) {
        this.canExport = bl;
        this.checkEnabled();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.objects != null) {
            this.exportData();
        } else if (this.dataExporter != null) {
            this.dataExporter.exportData();
        }
    }

    private void exportData() {
        Frame frame;
        if (!WbSwingUtilities.isConnectionIdle(this.objects.getComponent(), this.objects.getConnection())) {
            return;
        }
        List<DbObject> list = this.objects.getSelectedObjects();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        TableExporter tableExporter = new TableExporter(this.objects.getConnection());
        if (tableExporter.selectTables(list, frame = (Frame)SwingUtilities.getWindowAncestor(this.objects.getComponent()))) {
            EventQueue.invokeLater(() -> tableExporter.startExport(frame));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.editor != null) {
            this.editor.removeSelectionListener(this);
        }
    }

    public void setEditor(EditorPanel editorPanel) {
        this.editor = editorPanel;
        this.editor.addSelectionListener(this);
        this.checkEnabled();
    }

    private void checkEnabled() {
        if (this.editor != null) {
            this.setEnabled(this.canExport && this.editor.isTextSelected());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void selectionChanged(int n, int n2) {
        this.checkEnabled();
    }
}

