/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import workbench.gui.components.WbMenuItem;
import workbench.gui.components.WbToolbarButton;
import workbench.interfaces.Disposable;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.PlatformShortcuts;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.resource.ShortcutManager;
import workbench.util.StringUtil;

public class WbAction
extends AbstractAction
implements Disposable {
    private static final String MAIN_MENU_ITEM = "MainMenuItem";
    private static final String MENU_SEPARATOR = "MenuSep";
    private static final String ALTERNATE_ACCELERATOR = "AltAcc";
    private static final String DEFAULT_ACCELERATOR = "DefaultAcc";
    private static final String MNEMONIC_INDEX = "MnemonicIndex";
    private String actionName;
    protected JButton toolbarButton;
    private ActionListener delegate;
    protected WbAction proxy;
    private WbAction original;
    private String iconKey;
    private String baseTooltip;
    protected boolean isConfigurable = true;
    private String descriptiveName;
    private boolean useLabelSizeAsLargeIcon;
    private String customIconFile;

    public WbAction() {
        this.actionName = this.getClass().getSimpleName();
        this.putValue("ActionCommandKey", this.actionName);
        this.initCustomIcon();
    }

    public WbAction(ActionListener actionListener, String string) {
        this.delegate = actionListener;
        this.actionName = string;
        this.putValue("ActionCommandKey", this.actionName);
    }

    public static boolean invokedByMouse(ActionEvent actionEvent) {
        boolean bl = (actionEvent.getModifiers() & 0x10) != 0;
        return bl;
    }

    public static boolean isAltPressed(ActionEvent actionEvent) {
        return WbAction.isAltPressed(actionEvent.getModifiers());
    }

    public static boolean isAltPressed(int n) {
        return (n & 8) == 8;
    }

    public static boolean isShiftPressed(ActionEvent actionEvent) {
        return WbAction.isShiftPressed(actionEvent.getModifiers());
    }

    public static boolean isShiftPressed(int n) {
        return (n & 1) == 1;
    }

    public static boolean isCtrlPressed(ActionEvent actionEvent) {
        return WbAction.isCtrlPressed(actionEvent.getModifiers());
    }

    public static boolean isCtrlPressed(int n) {
        int n2 = PlatformShortcuts.getDefaultModifier();
        boolean bl = (n & n2) == n2;
        return bl;
    }

    public void setUseLabelIconSize(boolean bl) {
        this.useLabelSizeAsLargeIcon = bl;
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    public boolean allowDuplicate() {
        return false;
    }

    public boolean hasShiftModifier() {
        return false;
    }

    public boolean hasCtrlModifier() {
        return false;
    }

    public void setTooltip(String string) {
        this.baseTooltip = StringUtil.trimToNull(string);
        this.initTooltip();
    }

    public String getCustomIconProperty() {
        return "workbench.gui.action.icon." + this.actionName;
    }

    private void initCustomIcon() {
        this.customIconFile = Settings.getInstance().getProperty(this.getCustomIconProperty(), null);
    }

    private void initTooltip() {
        if (this.baseTooltip == null) {
            this.putValue("ShortDescription", null);
        } else {
            String string = this.getAcceleratorDisplay();
            if (this.baseTooltip.startsWith("<html>") || string == null) {
                this.putValue("ShortDescription", this.baseTooltip);
            } else {
                this.putValue("ShortDescription", this.baseTooltip + " (" + string + ")");
            }
        }
    }

    public String getToolTipText() {
        return this.baseTooltip;
    }

    public String getTooltipTextWithKeys() {
        return (String)this.getValue("ShortDescription");
    }

    public void clearAccelerator() {
        this.putValue("AcceleratorKey", null);
        this.initTooltip();
    }

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    protected void setActionName(String string) {
        this.actionName = string;
        this.putValue("ActionCommandKey", this.actionName);
    }

    public String getMenuLabel() {
        return (String)this.getValue("Name");
    }

    public void initMenuDefinition(String string) {
        this.initMenuDefinition(string, null);
    }

    public void initMenuDefinition(String string, KeyStroke keyStroke) {
        this.setMenuTextByKey(string);
        this.setDefaultAccelerator(keyStroke);
        this.initializeShortcut();
    }

    protected void initializeShortcut() {
        if (this.isConfigurable()) {
            ShortcutManager shortcutManager = ShortcutManager.getInstance();
            shortcutManager.registerAction(this);
            KeyStroke keyStroke = shortcutManager.getCustomizedKeyStroke(this);
            this.setAccelerator(keyStroke);
        }
    }

    public void initMenuDefinition(String string, String string2, KeyStroke keyStroke) {
        this.setMenuText(string);
        this.setTooltip(string2);
        this.setDefaultAccelerator(keyStroke);
        this.initializeShortcut();
    }

    public void setMenuTextByKey(String string) {
        this.setMenuText(ResourceMgr.getString(string));
        this.setTooltip(ResourceMgr.getDescription(string, true));
    }

    public void setMenuText(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(38);
        if (n > -1) {
            char c = string.charAt(n + 1);
            string = string.substring(0, n) + string.substring(n + 1);
            Integer n2 = c;
            Integer n3 = n;
            this.putValue("MnemonicKey", n2);
            this.putValue(MNEMONIC_INDEX, n3);
        }
        this.putValue("Name", string);
    }

    public void setAlternateAccelerator(KeyStroke keyStroke) {
        this.putValue(ALTERNATE_ACCELERATOR, keyStroke);
    }

    public KeyStroke getAlternateAccelerator() {
        return (KeyStroke)this.getValue(ALTERNATE_ACCELERATOR);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
        this.initTooltip();
    }

    public String getDescriptiveName() {
        if (this.descriptiveName == null) {
            return this.getMenuLabel();
        }
        return this.descriptiveName;
    }

    protected void setDescriptiveName(String string) {
        this.descriptiveName = string;
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public JButton getToolbarButton() {
        return this.getToolbarButton(false);
    }

    public JButton getToolbarButton(boolean bl) {
        JButton jButton;
        if (this.toolbarButton == null || bl) {
            WbToolbarButton wbToolbarButton = new WbToolbarButton();
            wbToolbarButton.setAction(this);
            wbToolbarButton.setMnemonic(0);
            if (this.toolbarButton == null) {
                this.toolbarButton = wbToolbarButton;
            }
            jButton = wbToolbarButton;
        } else {
            jButton = this.toolbarButton;
        }
        return jButton;
    }

    public void addToToolbar(JToolBar jToolBar) {
        jToolBar.add(this.getToolbarButton());
    }

    public void addToMenu(JMenu jMenu) {
        jMenu.add(this.getMenuItem());
    }

    public JMenuItem getMenuItem() {
        WbMenuItem wbMenuItem = new WbMenuItem();
        wbMenuItem.setAction(this);
        wbMenuItem.setHorizontalTextPosition(11);
        wbMenuItem.setVerticalTextPosition(0);
        Integer n = (Integer)this.getValue(MNEMONIC_INDEX);
        if (n != null) {
            try {
                wbMenuItem.setDisplayedMnemonicIndex(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return wbMenuItem;
    }

    public String getMenuItemName() {
        return (String)this.getValue(MAIN_MENU_ITEM);
    }

    public void setMenuItemName(String string) {
        this.putValue(MAIN_MENU_ITEM, string);
    }

    public boolean getCreateMenuSeparator() {
        Boolean bl = (Boolean)this.getValue(MENU_SEPARATOR);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setCreateMenuSeparator(boolean bl) {
        this.putValue(MENU_SEPARATOR, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getActionName() {
        return this.actionName;
    }

    public void addToInputMap(JComponent jComponent) {
        this.addToInputMap(jComponent.getInputMap(), jComponent.getActionMap());
    }

    public void addToInputMap(JComponent jComponent, int n) {
        this.addToInputMap(jComponent.getInputMap(n), jComponent.getActionMap());
    }

    public void addToInputMap(InputMap inputMap, ActionMap actionMap) {
        if (this.getAccelerator() == null) {
            return;
        }
        inputMap.put(this.getAccelerator(), this.getActionName());
        actionMap.put(this.getActionName(), this);
        KeyStroke keyStroke = this.getAlternateAccelerator();
        if (keyStroke != null) {
            inputMap.put(keyStroke, this.getActionName());
        }
        int n = this.getAccelerator().getKeyCode();
        int n2 = this.getAccelerator().getModifiers();
        if (this.hasShiftModifier()) {
            inputMap.put(KeyStroke.getKeyStroke(n, n2 | 1), this.getActionName());
        }
        if (this.hasCtrlModifier()) {
            inputMap.put(KeyStroke.getKeyStroke(n, n2 | PlatformShortcuts.getDefaultModifier()), this.getActionName());
        }
    }

    public void removeFromInputMap(InputMap inputMap, ActionMap actionMap) {
        actionMap.remove(this.getActionName());
        inputMap.remove(this.getAccelerator());
        KeyStroke keyStroke = this.getAlternateAccelerator();
        if (keyStroke != null) {
            inputMap.remove(keyStroke);
        }
        int n = this.getAccelerator().getKeyCode();
        int n2 = this.getAccelerator().getModifiers();
        if (this.hasShiftModifier()) {
            inputMap.remove(KeyStroke.getKeyStroke(n, n2 | 1));
        }
        if (this.hasCtrlModifier()) {
            inputMap.remove(KeyStroke.getKeyStroke(n, n2 | PlatformShortcuts.getDefaultModifier()));
        }
    }

    public void setDefaultAccelerator(KeyStroke keyStroke) {
        this.putValue(DEFAULT_ACCELERATOR, keyStroke);
    }

    public KeyStroke getDefaultAccelerator() {
        return (KeyStroke)this.getValue(DEFAULT_ACCELERATOR);
    }

    public void setIcon(String string) {
        this.iconKey = string;
        if (string == null) {
            this.removeIcon();
        }
    }

    @Override
    public Object getValue(String string) {
        if (string.equals("SmallIcon")) {
            if (GuiSettings.showMenuIcons()) {
                return this.getIcon("SmallIcon", IconMgr.getInstance().getSizeForMenuItem());
            }
            return null;
        }
        if (string.equals("SwingLargeIconKey")) {
            int n = IconMgr.getInstance().getToolbarIconSize();
            if (this.useLabelSizeAsLargeIcon) {
                n = IconMgr.getInstance().getSizeForLabel();
            }
            return this.getIcon("SwingLargeIconKey", n);
        }
        return super.getValue(string);
    }

    public boolean useInToolbar() {
        return true;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public void setCustomIconFile(String string) {
        this.customIconFile = StringUtil.trimToNull(string);
    }

    public String getCustomIconFile() {
        return this.customIconFile;
    }

    public boolean hasCustomIcon() {
        return this.customIconFile != null;
    }

    public boolean hasIcon() {
        return this.iconKey != null;
    }

    public ImageIcon getToolbarIcon() {
        return (ImageIcon)this.getValue("SwingLargeIconKey");
    }

    private ImageIcon getIcon(String string, int n) {
        ImageIcon imageIcon;
        if (this.customIconFile != null && string.equals("SwingLargeIconKey") && (imageIcon = IconMgr.getInstance().getExternalImage(this.customIconFile, 0)) != null) {
            return imageIcon;
        }
        if (this.iconKey == null) {
            return null;
        }
        imageIcon = (ImageIcon)super.getValue(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        imageIcon = IconMgr.getInstance().getIcon(this.iconKey, n, true);
        if (imageIcon != null) {
            this.putValue(string, imageIcon);
        }
        return imageIcon;
    }

    public void removeIcon() {
        this.iconKey = null;
        this.putValue("SmallIcon", null);
        this.putValue("SwingLargeIconKey", null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            EventQueue.invokeLater(() -> {
                if (this.original != null) {
                    this.original.executeAction(actionEvent);
                } else {
                    this.executeAction(actionEvent);
                }
            });
        }
    }

    public void executeAction(ActionEvent actionEvent) {
        if (this.isEnabled() && this.delegate != null) {
            if (actionEvent != null) {
                actionEvent.setSource(this);
            }
            this.delegate.actionPerformed(actionEvent);
        }
    }

    private String getAcceleratorDisplay() {
        KeyStroke keyStroke = this.getDefaultAccelerator();
        if (keyStroke == null) {
            return null;
        }
        String string = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (string == null) {
            string = "-";
        }
        int n = keyStroke.getModifiers();
        int n2 = keyStroke.getKeyCode();
        String string2 = KeyEvent.getKeyModifiersText(n) + string + KeyEvent.getKeyText(n2);
        return string2;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.proxy != null) {
            this.proxy.setEnabled(bl);
        }
    }

    public void setOriginal(WbAction wbAction) {
        if (this.original != null) {
            this.original.setProxy(null);
            if (wbAction == null) {
                this.setEnabled(false);
            }
        }
        this.original = null;
        if (wbAction != null) {
            this.setEnabled(wbAction.isEnabled());
            this.original = wbAction;
            this.original.setProxy(this);
        }
    }

    public String toString() {
        return this.getActionName() + ", " + this.getAccelerator();
    }

    protected void setProxy(WbAction wbAction) {
        this.proxy = wbAction;
    }

    public boolean equals(Object object) {
        if (object instanceof WbAction) {
            return ((WbAction)object).actionName.equals(this.actionName);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.actionName != null ? this.actionName.hashCode() : 0);
        return n;
    }

    @Override
    public void dispose() {
        this.delegate = null;
        this.original = null;
        this.proxy = null;
        if (this.toolbarButton != null) {
            this.toolbarButton.setAction(null);
            this.toolbarButton.setIcon(null);
            this.toolbarButton = null;
        }
    }

    public static void dispose(WbAction ... wbActionArray) {
        if (wbActionArray == null) {
            return;
        }
        for (WbAction wbAction : wbActionArray) {
            if (wbAction == null) continue;
            wbAction.dispose();
        }
    }
}

