/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import workbench.db.WbConnection;
import workbench.gui.completion.BaseAnalyzer;
import workbench.resource.ResourceMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.StringUtil;

public class ExecAnalyzer
extends BaseAnalyzer {
    private String qualifier;

    public ExecAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, this.sql);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            this.context = -1;
            return;
        }
        this.context = 1;
        this.qualifier = this.getQualifierLeftOfCursor();
    }

    @Override
    protected void buildResult() {
        if (this.context == -1) {
            return;
        }
        this.title = ResourceMgr.getString("TxtDbExplorerProcs");
        String string = null;
        if (StringUtil.isNonBlank(this.qualifier)) {
            String[] stringArray = this.qualifier.split("\\.");
            if (stringArray.length == 1) {
                string = stringArray[0];
            }
            if (stringArray.length == 2) {
                string = stringArray[1];
            }
        }
        if (string == null) {
            string = this.dbConnection.getCurrentSchema();
        }
        this.elements = this.dbConnection.getObjectCache().getProcedures(string);
    }
}

