/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class BooleanPropertyEditor
extends JCheckBox
implements ItemListener,
SimplePropertyEditor {
    private Object source;
    private Method setter;
    private Method getter;
    private boolean changed;
    private String propName;
    private boolean immediateUpdate;

    @Override
    public void setSourceObject(Object object, String string) {
        this.source = object;
        this.changed = false;
        this.propName = string;
        this.removeItemListener(this);
        if (object == null) {
            this.getter = null;
            this.setter = null;
            return;
        }
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        try {
            String string3 = "get" + string2;
            Class<?> clazz = object.getClass();
            try {
                this.getter = clazz.getMethod(string3, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getter = null;
            }
            if (this.getter == null) {
                string3 = "is" + string2;
                this.getter = clazz.getMethod(string3, null);
            }
            string3 = "set" + string2;
            Class[] classArray = new Class[]{Boolean.TYPE};
            this.setter = clazz.getMethod(string3, classArray);
            Boolean bl = (Boolean)this.getter.invoke(this.source, (Object[])null);
            this.setSelected(bl);
            this.addItemListener(this);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BooleanPropertyEditor.this.firePropertyChange(BooleanPropertyEditor.this.propName, null, BooleanPropertyEditor.this.isSelected());
            }
        });
    }

    @Override
    public void applyChanges() {
        if (!this.changed) {
            return;
        }
        if (this.setter == null) {
            return;
        }
        Object[] objectArray = new Object[]{this.isSelected()};
        try {
            this.setter.invoke(this.source, objectArray);
            this.changed = false;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when applying changes", exception);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setImmediateUpdate(boolean bl) {
        this.immediateUpdate = bl;
    }

    @Override
    public boolean getImmediateUpdate() {
        return this.immediateUpdate;
    }
}

