/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import workbench.util.NumberStringCache;

class ByteBufferTableModel
implements TableModel {
    private final byte[] data;
    private final int rowCount;
    private final int columns = 16;
    private final String[] labels;

    ByteBufferTableModel(byte[] byArray) {
        this.data = byArray;
        this.rowCount = byArray.length / 16 + 1;
        this.labels = new String[17];
        for (int i = 0; i < 16; ++i) {
            this.labels[i] = NumberStringCache.getHexString(i);
        }
        this.labels[16] = "0123456789abcdef";
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return 17;
    }

    @Override
    public String getColumnName(int n) {
        return this.labels[n];
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 16) {
            int n3 = n * 16;
            int n4 = Math.min(n * 16 + 16, this.data.length);
            StringBuilder stringBuilder = new StringBuilder(16);
            for (int i = n3; i < n4; ++i) {
                int n5;
                int n6 = n5 = this.data[i] < 0 ? 256 + this.data[i] : this.data[i];
                if (n5 > 31 && n5 < 128 || n5 > 128 && n5 < 255) {
                    stringBuilder.append((char)n5);
                    continue;
                }
                stringBuilder.append('.');
            }
            return stringBuilder.toString();
        }
        int n7 = n * 16 + n2;
        if (n7 >= this.data.length) {
            return "";
        }
        int n8 = this.data[n7] < 0 ? 256 + this.data[n7] : this.data[n7];
        return NumberStringCache.getHexString(n8);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }
}

