/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIManager;

public class CloseIcon
implements Icon {
    private static final float SMALL_SIZE_FACTOR = 0.3f;
    private static final float LARGE_SIZE_FACTOR = 0.15f;
    private static final Color DISABLED_FG_COLOR = UIManager.getDefaults().getColor("Button.disabledForeground");
    private final BasicStroke stroke;
    private final Color foregroundColor;
    private final Color backgroundColor;
    private int offset;
    private final int size;

    public CloseIcon(int n) {
        this(n, null, null);
    }

    public CloseIcon(int n, Color color, Color color2) {
        this.size = n % 2 == 0 ? n : n + 1;
        this.foregroundColor = color;
        this.backgroundColor = color2;
        this.stroke = new BasicStroke((float)this.size / 12.0f, 2, 0);
        this.calculateSize(false);
    }

    public void setUseLargeSize(boolean bl) {
        this.calculateSize(bl);
    }

    private void calculateSize(boolean bl) {
        int n = bl ? (int)Math.ceil((float)this.size * 0.15f) : (int)Math.ceil((float)this.size * 0.3f);
        if (n % 2 != 0) {
            ++n;
        }
        this.offset = n / 2;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    private Color getForeground(Component component) {
        if (component.isEnabled()) {
            return this.foregroundColor == null ? component.getForeground() : this.foregroundColor;
        }
        return DISABLED_FG_COLOR == null ? component.getForeground() : DISABLED_FG_COLOR;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n3 = this.offset;
        int n4 = this.size - this.offset - 1;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fillRect(n, n2, n + this.size, n2 + this.size);
        }
        graphics2D.setColor(this.getForeground(component));
        graphics2D.setStroke(this.stroke);
        graphics2D.drawLine(n3 + n, n3 + n2, n4 + n, n4 + n2);
        graphics2D.drawLine(n4 + n, n3 + n2, n3 + n, n4 + n2);
    }
}

