/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;

public class ColumnOrderMgr {
    private final Map<String, List<String>> columnOrders = new HashMap<String, List<String>>();

    public static ColumnOrderMgr getInstance() {
        return LazyInstanceHolder.instance;
    }

    private ColumnOrderMgr() {
        this.load();
    }

    public int getSize() {
        return this.columnOrders.size();
    }

    public synchronized void restoreColumnOrder(WbTable wbTable) {
        String string = this.getColumnOrderKey(wbTable);
        if (string == null) {
            return;
        }
        List<String> list = this.columnOrders.get(string);
        if (list != null) {
            this.applyColumnOrder(wbTable, list, true);
        }
    }

    private String getColumnOrderKey(WbTable wbTable) {
        if (wbTable == null) {
            return null;
        }
        DataStore dataStore = wbTable.getDataStore();
        if (dataStore == null) {
            return null;
        }
        WbConnection wbConnection = dataStore.getOriginalConnection();
        if (wbConnection == null) {
            return null;
        }
        TableIdentifier tableIdentifier = dataStore.getUpdateTable();
        if (tableIdentifier == null) {
            dataStore.checkUpdateTable();
        }
        if ((tableIdentifier = dataStore.getUpdateTable()) == null) {
            return null;
        }
        String string = wbConnection.getUrl();
        return this.getColumnOrderKey(tableIdentifier, string);
    }

    public String getColumnOrderKey(TableIdentifier tableIdentifier, String string) {
        String string2 = tableIdentifier.getTableExpression() + "@" + string;
        return string2;
    }

    public synchronized boolean isOrderSaved(WbTable wbTable) {
        String string = this.getColumnOrderKey(wbTable);
        return this.columnOrders.containsKey(string);
    }

    public synchronized boolean isOrderSaved(TableIdentifier tableIdentifier, String string) {
        String string2 = this.getColumnOrderKey(tableIdentifier, string);
        return this.columnOrders.containsKey(string2);
    }

    public void resetColumnOrder(WbTable wbTable) {
        String string = this.getColumnOrderKey(wbTable);
        this.removeColumnOrder(string);
        if (wbTable == null) {
            return;
        }
        TableColumnModel tableColumnModel = wbTable.getColumnModel();
        if (tableColumnModel == null) {
            return;
        }
        if (tableColumnModel.getColumnCount() == 0) {
            return;
        }
        Comparator<TableColumn> comparator = new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                return tableColumn.getModelIndex() - tableColumn2.getModelIndex();
            }
        };
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>(tableColumnModel.getColumnCount());
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            arrayList.add(tableColumnModel.getColumn(i));
        }
        Collections.sort(arrayList, comparator);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (TableColumn tableColumn : arrayList) {
            defaultTableColumnModel.addColumn(tableColumn);
        }
        wbTable.setColumnModel(defaultTableColumnModel);
    }

    public void applyColumnOrder(WbTable wbTable, List<String> list, boolean bl) {
        if (list == null || list.isEmpty()) {
            return;
        }
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumnModel tableColumnModel = wbTable.getColumnModel();
        for (CharSequence object : list) {
            try {
                int string = tableColumnModel.getColumnIndex(object);
                TableColumn tableColumn = tableColumnModel.getColumn(string);
                defaultTableColumnModel.addColumn(tableColumn);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogMgr.logDebug(new CallerInfo(){}, "Column '" + object + "' not found.");
            }
        }
        if (bl) {
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                String string = tableColumn.getIdentifier().toString();
                if (list.contains(string)) continue;
                list.add(string);
                defaultTableColumnModel.addColumn(tableColumn);
            }
        }
        wbTable.setColumnModel(defaultTableColumnModel);
    }

    public synchronized void removeColumnOrder(String string) {
        if (string == null) {
            return;
        }
        this.columnOrders.remove(string);
    }

    public List<String> getColumnOrder(WbTable wbTable) {
        TableColumnModel tableColumnModel = wbTable.getColumnModel();
        ArrayList<String> arrayList = new ArrayList<String>(tableColumnModel.getColumnCount());
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            String string = tableColumnModel.getColumn(i).getIdentifier().toString();
            arrayList.add(string);
        }
        return arrayList;
    }

    public synchronized void storeColumnOrder(WbTable wbTable) {
        if (wbTable == null) {
            return;
        }
        String string = this.getColumnOrderKey(wbTable);
        this.columnOrders.put(string, this.getColumnOrder(wbTable));
    }

    public synchronized void saveSettings() throws IOException {
        File file = Settings.getInstance().getColumnOrderStorage();
        if (this.columnOrders.isEmpty() && file.exists()) {
            file.delete();
        } else if (this.columnOrders.size() > 0) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try (XMLEncoder xMLEncoder = new XMLEncoder(fileOutputStream);){
                xMLEncoder.writeObject(this.columnOrders);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() {
        File file = Settings.getInstance().getColumnOrderStorage();
        if (!file.exists()) {
            return;
        }
        this.columnOrders.clear();
        try (XMLDecoder xMLDecoder = null;){
            FileInputStream fileInputStream = new FileInputStream(file);
            xMLDecoder = new XMLDecoder(fileInputStream);
            Object object = xMLDecoder.readObject();
            this.columnOrders.putAll((Map)object);
        }
    }

    protected static class LazyInstanceHolder {
        protected static final ColumnOrderMgr instance = new ColumnOrderMgr();

        protected LazyInstanceHolder() {
        }
    }
}

