/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.PlainEditor;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.Restoreable;
import workbench.interfaces.TextContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class EditWindow
extends JDialog
implements ActionListener,
WindowListener {
    private TextContainer textContainer;
    private JComponent editor;
    private Restoreable componentSettings;
    private JButton okButton = new WbButton(ResourceMgr.getString("LblOK"));
    private JButton cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
    private boolean isCancelled = true;
    private String settingsId;

    public EditWindow(Frame frame, String string, String string2) {
        this(frame, string, string2, "workbench.data.edit.window");
    }

    public EditWindow(Frame frame, String string, String string2, boolean bl, boolean bl2) {
        this(frame, string, string2, "workbench.data.edit.window", bl, true, bl2);
    }

    public EditWindow(Frame frame, String string, String string2, String string3) {
        this(frame, string, string2, string3, false);
    }

    public EditWindow(Frame frame, String string, String string2, String string3, boolean bl) {
        this(frame, string, string2, string3, bl, true, false);
    }

    public EditWindow(Frame frame, String string, String string2, String string3, boolean bl, boolean bl2) {
        this(frame, string, string2, string3, bl, bl2, false);
    }

    public EditWindow(Frame frame, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(frame, string, bl2);
        this.init(string2, string3, bl, bl3);
        WbSwingUtilities.center(this, frame);
    }

    public EditWindow(Dialog dialog, String string, String string2, String string3, boolean bl) {
        super(dialog, string, true);
        this.init(string2, string3, bl, true);
        WbSwingUtilities.center(this, WbManager.getInstance().getCurrentWindow());
    }

    public EditWindow(Dialog dialog, String string, String string2, boolean bl, boolean bl2) {
        super(dialog, string, true);
        this.init(string2, "workbench.data.edit.window", bl, bl2);
        WbSwingUtilities.center(this, WbManager.getInstance().getCurrentWindow());
    }

    public void setReadOnly() {
        this.textContainer.setEditable(false);
    }

    private void init(String string, String string2, boolean bl, boolean bl2) {
        Object object;
        JComponent jComponent;
        this.settingsId = string2;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        if (bl) {
            jComponent = EditorPanel.createSqlEditor();
            ((EditorPanel)jComponent).showFindOnPopupMenu();
            ((EditorPanel)jComponent).showFormatSql();
            this.editor = jComponent;
            this.textContainer = jComponent;
        } else if (Settings.getInstance().getUsePlainEditorForData()) {
            jComponent = new PlainEditor();
            this.componentSettings = jComponent;
            this.textContainer = jComponent;
            this.editor = jComponent;
        } else {
            jComponent = EditorPanel.createTextEditor();
            ((EditorPanel)jComponent).showFindOnPopupMenu();
            this.editor = jComponent;
            this.textContainer = jComponent;
        }
        this.getContentPane().add((Component)this.editor, "Center");
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(2));
        if (!bl2) {
            jComponent.add(this.okButton);
        } else {
            this.cancelButton.setText(ResourceMgr.getString("LblClose"));
        }
        jComponent.add(this.cancelButton);
        this.getContentPane().add((Component)jComponent, "South");
        if (GuiSettings.getUseReaderForMultilineRenderer() && this.editor instanceof PlainEditor) {
            object = new StringReader(string);
            try {
                ((PlainEditor)this.editor).readText((Reader)object);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not set value using StringReader", throwable);
                this.textContainer.setText(string);
            }
        } else {
            this.textContainer.setText(string);
        }
        this.editor.setMinimumSize(new Dimension(100, 100));
        this.editor.setPreferredSize(new Dimension(300, 200));
        this.textContainer.setCaretPosition(0);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        object = new WbTraversalPolicy();
        ((WbTraversalPolicy)object).setDefaultComponent(this.editor);
        ((WbTraversalPolicy)object).addComponent(this.editor);
        ((WbTraversalPolicy)object).addComponent(this.okButton);
        ((WbTraversalPolicy)object).addComponent(this.cancelButton);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
        this.setFocusCycleRoot(false);
        new EscAction(this, this);
        if (!Settings.getInstance().restoreWindowSize(this, this.settingsId)) {
            this.setSize(500, 400);
        }
        this.addWindowListener(this);
    }

    public void setInfoText(String string) {
        if (this.editor instanceof PlainEditor) {
            ((PlainEditor)this.editor).setInfoText(string);
        }
    }

    public void hideCancelButton() {
        this.cancelButton.removeActionListener(this);
        this.cancelButton.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.isCancelled = false;
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.isCancelled = true;
        }
        this.closeWindow();
    }

    private void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getText() {
        return this.textContainer.getText();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Settings.getInstance().storeWindowSize(this, this.settingsId);
        if (this.componentSettings != null) {
            this.componentSettings.saveSettings();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.validate();
        this.editor.validate();
        this.editor.requestFocusInWindow();
        WbSwingUtilities.repaintLater(this);
    }
}

