/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.util.HashMap;
import java.util.Map;
import workbench.gui.components.TypeEntry;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.NumberStringCache;

public class GenericRowMonitor
implements RowActionMonitor {
    private StatusBar statusBar;
    private String updateMsg;
    private String currentMonitorObject;
    private int monitorType;
    private String objectMsg = ResourceMgr.getString("MsgProcessObject") + " ";
    private Map<String, TypeEntry> typeStack = new HashMap<String, TypeEntry>();

    public GenericRowMonitor(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    @Override
    public int getMonitorType() {
        return this.monitorType;
    }

    @Override
    public void setMonitorType(int n) {
        this.monitorType = n;
        switch (n) {
            case 0: {
                this.updateMsg = ResourceMgr.getString("MsgImportingRow") + " ";
                break;
            }
            case 1: {
                this.updateMsg = ResourceMgr.getString("MsgUpdatingRow") + " ";
                break;
            }
            case 2: {
                this.updateMsg = ResourceMgr.getString("MsgLoadingRow") + " ";
                break;
            }
            case 3: {
                this.updateMsg = ResourceMgr.getString("MsgWritingRow") + " ";
                break;
            }
            case 4: {
                this.updateMsg = ResourceMgr.getString("MsgCopyingRow") + " ";
                break;
            }
            case 5: {
                this.updateMsg = ResourceMgr.getString("MsgProcessTable") + " ";
                break;
            }
            case 6: {
                this.updateMsg = ResourceMgr.getString("MsgProcessObject") + " ";
                break;
            }
            case 8: {
                this.updateMsg = ResourceMgr.getString("MsgProcessingDeletes") + " ";
                break;
            }
            case 7: {
                this.updateMsg = null;
                break;
            }
            default: {
                LogMgr.logWarning(new CallerInfo(){}, "Invalid monitor type " + n + " specified!");
                this.monitorType = 7;
                this.updateMsg = null;
            }
        }
    }

    @Override
    public void setCurrentObject(String string, long l, long l2) {
        this.currentMonitorObject = string;
        if (this.monitorType == 7) {
            this.statusBar.setStatusMessage(string);
        } else {
            StringBuilder stringBuilder = new StringBuilder(40);
            if (this.objectMsg != null) {
                stringBuilder.append(this.objectMsg);
            }
            stringBuilder.append(string);
            if (l > 0L) {
                stringBuilder.append(" (");
                stringBuilder.append(l);
                if (l2 > 0L) {
                    stringBuilder.append('/');
                    stringBuilder.append(l2);
                }
                stringBuilder.append(')');
            }
            this.statusBar.setStatusMessage(stringBuilder.toString());
        }
    }

    @Override
    public void setCurrentRow(long l, long l2) {
        if (this.updateMsg == null && this.currentMonitorObject == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(40);
        if (this.updateMsg == null) {
            stringBuilder.append(this.objectMsg);
            stringBuilder.append(this.currentMonitorObject);
            stringBuilder.append(" (");
        } else {
            stringBuilder.append(this.updateMsg);
        }
        stringBuilder.append(NumberStringCache.getNumberString(l));
        if (l2 > 0L) {
            stringBuilder.append('/');
            stringBuilder.append(NumberStringCache.getNumberString(l2));
        }
        if (this.updateMsg == null) {
            stringBuilder.append(')');
        }
        this.statusBar.setStatusMessage(stringBuilder.toString());
    }

    @Override
    public void jobFinished() {
        this.statusBar.clearStatusMessage();
        this.updateMsg = null;
        this.currentMonitorObject = null;
        this.typeStack.clear();
    }

    @Override
    public void saveCurrentType(String string) {
        TypeEntry typeEntry = new TypeEntry();
        typeEntry.msg = this.updateMsg;
        typeEntry.type = this.monitorType;
        typeEntry.obj = this.currentMonitorObject;
        this.typeStack.put(string, typeEntry);
    }

    @Override
    public void restoreType(String string) {
        this.statusBar.clearStatusMessage();
        TypeEntry typeEntry = this.typeStack.get(string);
        if (typeEntry == null) {
            return;
        }
        this.updateMsg = typeEntry.msg;
        this.currentMonitorObject = typeEntry.obj;
        this.monitorType = typeEntry.type;
    }
}

