/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.FlatButton;
import workbench.gui.components.WbButton;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class MasterPasswordDialog
extends JDialog
implements ActionListener {
    private boolean cancelled = true;
    private boolean removeMasterPwd = false;
    private EscAction escAction;
    private char echoChar;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel newPwdLabel;
    private JButton okButton;
    private JLabel oldPwdLabel;
    private JPasswordField pwdInput;
    private JButton removePwdButton;
    private JPasswordField repeatPwd;
    private JButton showPwd;
    private JButton showRepeat;
    private JLabel warningLabel;

    public MasterPasswordDialog(Frame frame, boolean bl) {
        super(frame, ResourceMgr.getString("TxtWindowTitleMasterPwd"), true);
        this.init(bl);
    }

    public MasterPasswordDialog(Dialog dialog) {
        super(dialog, ResourceMgr.getString("TxtWindowTitleMasterPwd"), true);
        this.init(true);
    }

    private void init(boolean bl) {
        this.escAction = new EscAction(this, this);
        this.setResizable(true);
        this.initComponents();
        this.warningLabel.setIconTextGap(IconMgr.getInstance().getSizeForLabel() / 2);
        this.warningLabel.setIcon(IconMgr.getInstance().getLabelIcon("alert"));
        this.warningLabel.setFont(this.warningLabel.getFont().deriveFont(1));
        this.pack();
        if (!bl || !Settings.getInstance().getUseMasterPassword()) {
            this.removePwdButton.setVisible(false);
        }
        this.echoChar = this.pwdInput.getEchoChar();
        this.showPwd.setIcon(IconMgr.getInstance().getLabelIcon("eye"));
        this.showRepeat.setIcon(IconMgr.getInstance().getLabelIcon("eye"));
        this.showPwd.setMargin(this.pwdInput.getMargin());
        WbSwingUtilities.makeEqualHeight(this.pwdInput, this.showPwd);
        this.showRepeat.setMargin(this.pwdInput.getMargin());
        WbSwingUtilities.makeEqualHeight(this.repeatPwd, this.showRepeat);
    }

    public boolean doRemoveMasterPassword() {
        return this.removeMasterPwd;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public String getMasterPassword() {
        if (this.removeMasterPwd) {
            return null;
        }
        return this.pwdInput.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escAction) {
            this.doCancel();
        }
    }

    private void doCancel() {
        this.removeMasterPwd = false;
        this.cancelled = true;
        this.closeWindow();
    }

    private void initComponents() {
        this.oldPwdLabel = new JLabel();
        this.newPwdLabel = new JLabel();
        this.pwdInput = new JPasswordField();
        this.repeatPwd = new JPasswordField();
        this.jPanel1 = new JPanel();
        this.removePwdButton = new JButton();
        this.okButton = new WbButton();
        this.cancelButton = new WbButton();
        this.jPanel2 = new JPanel();
        this.warningLabel = new JLabel();
        this.showPwd = new FlatButton();
        this.showRepeat = new FlatButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.oldPwdLabel.setText(ResourceMgr.getString("LblNewPwd"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(13, 12, 8, 0);
        this.getContentPane().add((Component)this.oldPwdLabel, gridBagConstraints);
        this.newPwdLabel.setText(ResourceMgr.getString("LblPwdRepeat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 12, 8, 0);
        this.getContentPane().add((Component)this.newPwdLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(13, 8, 8, 0);
        this.getContentPane().add((Component)this.pwdInput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        this.getContentPane().add((Component)this.repeatPwd, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.removePwdButton.setText("Remove");
        this.removePwdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterPasswordDialog.this.removePwdButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.removePwdButton, gridBagConstraints);
        this.okButton.setText(ResourceMgr.getString("LblOK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterPasswordDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.jPanel1.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(ResourceMgr.getString("LblCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterPasswordDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(19, 12, 16, 12);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.warningLabel.setText(ResourceMgr.getString("LblMasterPwdWarn"));
        this.warningLabel.setIconTextGap(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.getContentPane().add((Component)this.warningLabel, gridBagConstraints);
        this.showPwd.setIcon(new ImageIcon(this.getClass().getResource("/workbench/resource/images/eye16.png")));
        this.showPwd.setIconTextGap(0);
        this.showPwd.setMargin(new Insets(0, 0, 0, 0));
        this.showPwd.setMaximumSize(null);
        this.showPwd.setMinimumSize(null);
        this.showPwd.setPreferredSize(null);
        this.showPwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterPasswordDialog.this.showPwdActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(13, 0, 0, 13);
        this.getContentPane().add((Component)this.showPwd, gridBagConstraints);
        this.showRepeat.setIcon(new ImageIcon(this.getClass().getResource("/workbench/resource/images/eye16.png")));
        this.showRepeat.setIconTextGap(0);
        this.showRepeat.setMargin(new Insets(0, 0, 0, 0));
        this.showRepeat.setMaximumSize(null);
        this.showRepeat.setMinimumSize(null);
        this.showRepeat.setPreferredSize(null);
        this.showRepeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MasterPasswordDialog.this.showRepeatActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 13);
        this.getContentPane().add((Component)this.showRepeat, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doCancel();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        char[] cArray = this.pwdInput.getPassword();
        if (cArray == null || cArray.length == 0) {
            WbSwingUtilities.showErrorMessageKey(this, "MsgNoPwd");
            return;
        }
        if (!Arrays.equals(this.pwdInput.getPassword(), this.repeatPwd.getPassword())) {
            WbSwingUtilities.showErrorMessageKey(this, "MsgPwdNoMatch");
            return;
        }
        this.removeMasterPwd = false;
        this.cancelled = false;
        this.closeWindow();
    }

    private void removePwdButtonActionPerformed(ActionEvent actionEvent) {
        this.removeMasterPwd = true;
        this.cancelled = false;
        this.closeWindow();
    }

    private void showPwdActionPerformed(ActionEvent actionEvent) {
        this.togglePasswordVisible(this.pwdInput);
    }

    private void showRepeatActionPerformed(ActionEvent actionEvent) {
        this.togglePasswordVisible(this.repeatPwd);
    }

    private void togglePasswordVisible(JPasswordField jPasswordField) {
        if (jPasswordField.getEchoChar() == '\u0000') {
            jPasswordField.setEchoChar(this.echoChar);
        } else {
            jPasswordField.setEchoChar('\u0000');
        }
    }

    private void closeWindow() {
        this.dispose();
    }
}

