/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import workbench.gui.components.NumberField;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class NumberPropertyEditor
extends NumberField
implements DocumentListener,
SimplePropertyEditor,
FocusListener {
    private Object source;
    private Method setter;
    private Method getter;
    private String propName;
    private boolean changed;
    private boolean immediateUpdate;

    public NumberPropertyEditor() {
        this.addFocusListener(this);
    }

    @Override
    public void setSourceObject(Object object, String string) {
        this.source = object;
        this.changed = false;
        this.propName = string;
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Document document = this.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        try {
            String string3 = "get" + string2;
            Class<?> clazz = object.getClass();
            this.getter = clazz.getMethod(string3, null);
            string3 = "set" + string2;
            Class[] classArray = new Class[]{Integer.TYPE};
            this.setter = clazz.getMethod(string3, classArray);
            String string4 = this.getter.invoke(this.source, (Object[])null).toString();
            super.setText(string4);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
        document = this.getDocument();
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    @Override
    public void applyChanges() {
        if (this.setter == null) {
            return;
        }
        if (!this.changed) {
            return;
        }
        Object[] objectArray = new Object[]{this.getText()};
        try {
            this.setter.invoke(this.source, objectArray);
            this.changed = true;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error applying changes", exception);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setImmediateUpdate(boolean bl) {
        this.immediateUpdate = bl;
        if (bl) {
            this.applyChanges();
        }
    }

    @Override
    public boolean getImmediateUpdate() {
        return this.immediateUpdate;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.immediateUpdate) {
            this.applyChanges();
        }
    }
}

