/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Graphics;
import workbench.gui.components.GuiPosition;

public class TabHighlighter {
    private final Color selectedHighlight;
    private final int thickness;
    private final GuiPosition location;

    public TabHighlighter(Color color, int n, GuiPosition guiPosition) {
        this.selectedHighlight = color;
        this.thickness = n;
        this.location = guiPosition;
    }

    public void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl && this.selectedHighlight != null) {
            int n7 = this.getThickness(n6);
            graphics.setColor(this.selectedHighlight);
            switch (this.location) {
                case top: {
                    graphics.fillRect(n3, n4, n5 - 1, n7);
                    break;
                }
                case left: {
                    graphics.fillRect(n3, n4, n7, n4 + n6);
                    break;
                }
                case right: {
                    graphics.fillRect(n3 + (n5 - n7), n4, n7, n6);
                    break;
                }
                case bottom: {
                    graphics.fillRect(n3, n4 + n6 - n7, n5 - 1, n7);
                }
            }
        }
    }

    private int getThickness(int n) {
        if (this.thickness > 0) {
            return this.thickness;
        }
        return (int)((double)n * 0.1);
    }
}

