/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Insets;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import workbench.gui.WbSwingUtilities;
import workbench.resource.Settings;

public class TabbedPaneUIFactory {
    private static final Insets TOP_INSETS = new Insets(2, 1, 1, 1);
    private static final Insets BOTTOM_INSETS = new Insets(1, 1, 2, 1);
    private static final Insets LEFT_INSETS = new Insets(1, 3, 1, 1);
    private static final Insets RIGHT_INSETS = new Insets(1, 1, 1, 3);

    static Insets getBorderLessInsets(int n) {
        switch (n) {
            case 1: {
                return (Insets)TOP_INSETS.clone();
            }
            case 3: {
                return (Insets)BOTTOM_INSETS.clone();
            }
            case 2: {
                return (Insets)LEFT_INSETS.clone();
            }
            case 4: {
                return (Insets)RIGHT_INSETS.clone();
            }
        }
        return WbSwingUtilities.getEmptyInsets();
    }

    public static String getTabbedPaneUIClass() {
        if (!Settings.getInstance().getBoolProperty("workbench.gui.replacetabbedpane", true)) {
            return null;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getClass().getName();
        if (string.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
            return "workbench.gui.components.BorderLessMetalTabbedPaneUI";
        }
        if (string.startsWith("com.sun.java.swing.plaf.windows.Windows")) {
            return "workbench.gui.components.BorderLessWindowsTabbedPaneUI";
        }
        if (string.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            return "workbench.gui.components.BorderLessMotifTabbedPaneUI";
        }
        if (string.contains("WebLookAndFeel")) {
            return "com.alee.laf.tabbedpane.WebTabbedPaneUI";
        }
        return null;
    }

    public static TabbedPaneUI getBorderLessUI() {
        String string = TabbedPaneUIFactory.getTabbedPaneUIClass();
        if (string == null) {
            return null;
        }
        return TabbedPaneUIFactory.getClassInstance(string);
    }

    private static TabbedPaneUI getClassInstance(String string) {
        TabbedPaneUI tabbedPaneUI = null;
        try {
            Class<?> clazz = Class.forName(string);
            tabbedPaneUI = (TabbedPaneUI)clazz.newInstance();
        }
        catch (Exception exception) {
            JTabbedPane jTabbedPane = new JTabbedPane();
            tabbedPaneUI = (TabbedPaneUI)UIManager.getUI(jTabbedPane);
            UIManager.getDefaults().put("TabbedPaneUI", tabbedPaneUI.getClass().getName());
        }
        return tabbedPaneUI;
    }
}

