/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import workbench.gui.components.GuiPosition;
import workbench.gui.components.MultiLineToolTip;
import workbench.gui.components.TabButtonComponent;
import workbench.gui.components.TabCloser;
import workbench.gui.components.TabHighlightSupport;
import workbench.gui.components.TabHighlighter;
import workbench.gui.components.TabbedPaneUIFactory;
import workbench.interfaces.Moveable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;

public class WbTabbedPane
extends JTabbedPane
implements MouseListener,
MouseMotionListener,
ChangeListener,
PropertyChangeListener {
    private Moveable tabMover;
    private int draggedTabIndex;
    private TabCloser tabCloser;
    private boolean hideDisabledButtons;
    private boolean onlyCloseActive;
    private Point dragStart;
    private Rectangle tabBounds;
    private int previousTabIndex;

    public WbTabbedPane() {
        this.init();
    }

    public WbTabbedPane(int n) {
        super(n);
        this.init();
    }

    public void hideDisabledButtons(boolean bl) {
        this.hideDisabledButtons = bl;
    }

    public void setCloseButtonEnabled(Component component, boolean bl) {
        if (this.tabCloser == null) {
            return;
        }
        int n = this.indexOfComponent(component);
        if (n == -1) {
            return;
        }
        this.setCloseButtonEnabled(n, bl);
    }

    public void setCloseButtonEnabled(int n, boolean bl) {
        if (this.tabCloser == null) {
            return;
        }
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setEnabled(bl);
        }
    }

    protected TabButtonComponent getTabButton(int n) {
        TabButtonComponent tabButtonComponent = (TabButtonComponent)this.getTabComponentAt(n);
        return tabButtonComponent;
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        super.setDisplayedMnemonicIndexAt(n, n2);
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setDisplayedMnemonicIndex(n2);
        }
    }

    @Override
    public void setMnemonicAt(int n, int n2) {
        super.setMnemonicAt(n, n2);
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setDisplayedMnemonic(n2);
        }
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        super.setIconAt(n, icon);
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setIcon(icon);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabButtonComponent tabButtonComponent = this.getTabButton(i);
            if (tabButtonComponent == null) continue;
            tabButtonComponent.setFont(font);
        }
    }

    @Override
    public void setForegroundAt(int n, Color color) {
        super.setForegroundAt(n, color);
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setForeground(color);
        }
    }

    @Override
    public void setBackgroundAt(int n, Color color) {
        super.setBackgroundAt(n, color);
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setForeground(color);
        }
    }

    public void showCloseButton(TabCloser tabCloser) {
        boolean bl = tabCloser != null && this.tabCloser == null;
        boolean bl2 = tabCloser == null && this.tabCloser != null;
        this.tabCloser = tabCloser;
        if (bl) {
            this.addCloseButtons();
            this.updateButtons();
            this.addChangeListener(this);
        } else if (bl2) {
            this.removeCloseButtons();
            this.removeChangeListener(this);
        }
    }

    protected void addCloseButtons() {
        if (this.tabCloser == null) {
            return;
        }
        for (int i = 0; i < this.getTabCount(); ++i) {
            String string = this.getTitleAt(i);
            Icon icon = this.getIconAt(i);
            TabButtonComponent tabButtonComponent = new TabButtonComponent(string, this, true);
            tabButtonComponent.setIcon(icon);
            tabButtonComponent.setFont(this.getFont());
            tabButtonComponent.setBackground(this.getBackgroundAt(i));
            tabButtonComponent.setForeground(this.getForegroundAt(i));
            this.setTabComponentAt(i, tabButtonComponent);
        }
    }

    protected void removeCloseButtons() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabButtonComponent tabButtonComponent = this.getTabButton(i);
            if (tabButtonComponent != null) {
                tabButtonComponent.setButtonVisible(false);
                continue;
            }
            this.setTabComponentAt(i, null);
        }
    }

    public void closeButtonClicked(int n) {
        if (this.tabCloser == null) {
            return;
        }
        if (!this.tabCloser.canCloseTab(n)) {
            return;
        }
        if (this.onlyCloseActive && n != this.getSelectedIndex()) {
            EventQueue.invokeLater(() -> this.setSelectedIndex(n));
        } else {
            EventQueue.invokeLater(() -> this.tabCloser.tabCloseButtonClicked(n));
        }
    }

    public int getTabHeight() {
        Font font = this.getFont();
        if (font == null) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null) {
            return 0;
        }
        int n = fontMetrics.getHeight();
        Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
        if (insets != null) {
            n += insets.top + insets.bottom + 2;
        }
        return n + 5;
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
        multiLineToolTip.setComponent(this);
        return multiLineToolTip;
    }

    private void init() {
        this.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        this.putClientProperty("jgoodies.embeddedTabs", Boolean.FALSE);
        this.putClientProperty("jgoodies.tabIconsEnabled", Boolean.FALSE);
        try {
            TabbedPaneUI tabbedPaneUI = TabbedPaneUIFactory.getBorderLessUI();
            if (tabbedPaneUI != null) {
                this.setUI(tabbedPaneUI);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
        this.onlyCloseActive = GuiSettings.getCloseActiveTabOnly();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.display.tab.closebutton.onlyactive", new String[0]);
        this.addChangeListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    public void setTabHighlight(Color color, int n, GuiPosition guiPosition) {
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof TabHighlightSupport) {
            TabHighlightSupport tabHighlightSupport = (TabHighlightSupport)((Object)tabbedPaneUI);
            if (color == null) {
                tabHighlightSupport.setTabHighlighter(null);
            } else {
                tabHighlightSupport.setTabHighlighter(new TabHighlighter(color, n, guiPosition));
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Settings.getInstance().removePropertyChangeListener(this);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void setTitleAt(int n, String string) {
        super.setTitleAt(n, string);
        TabButtonComponent tabButtonComponent = this.getTabButton(n);
        if (tabButtonComponent != null) {
            tabButtonComponent.setTitle(string);
        }
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        if (this.tabCloser != null) {
            this.setTabComponentAt(n, new TabButtonComponent(string, this, this.tabCloser != null));
            this.updateButtons();
        }
    }

    @Override
    public void fireStateChanged() {
        super.fireStateChanged();
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return false;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public void disableDragDropReordering() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.tabMover = null;
        this.draggedTabIndex = -1;
    }

    public void enableDragDropReordering(Moveable moveable) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.tabMover = moveable;
        this.draggedTabIndex = -1;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getUI().tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY());
        if (n < 0) {
            this.dragStart = null;
            this.draggedTabIndex = -1;
            this.tabBounds = null;
            return;
        }
        this.dragStart = mouseEvent.getPoint();
        this.tabBounds = this.getUI().getTabBounds(this, n);
        if (this.tabMover != null && this.tabMover.startMove(n)) {
            this.draggedTabIndex = n;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.dragStart == null) {
            return;
        }
        double d = Math.abs(this.dragStart.distance(point));
        boolean bl = this.tabBounds.contains(point);
        if (this.tabMover != null && d > 2.0 && bl) {
            this.tabMover.endMove(this.draggedTabIndex);
        } else {
            this.tabMover.moveCancelled();
        }
        this.draggedTabIndex = -1;
        this.dragStart = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.tabMover == null) {
            return;
        }
        if (this.draggedTabIndex == -1) {
            return;
        }
        int n = this.getUI().tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY());
        if (n != -1 && n != this.draggedTabIndex) {
            this.setCursor(DragSource.DefaultMoveDrop);
            if (this.tabMover.moveTab(this.draggedTabIndex, n)) {
                this.draggedTabIndex = n;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void updateButtons() {
        if (this.tabCloser == null) {
            return;
        }
        int n = this.getTabCount();
        int n2 = this.getSelectedIndex();
        for (int i = 0; i < n; ++i) {
            boolean bl = this.tabCloser.canCloseTab(i);
            if (this.onlyCloseActive) {
                bl = i != n2;
            }
            this.setCloseButtonEnabled(i, bl);
            TabButtonComponent tabButtonComponent = this.getTabButton(i);
            if (tabButtonComponent == null || !this.hideDisabledButtons) continue;
            tabButtonComponent.setButtonVisible(bl);
        }
    }

    public int getPreviousTabIndex() {
        return this.previousTabIndex;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateButtons();
    }

    @Override
    public void setSelectedIndex(int n) {
        this.previousTabIndex = this.getSelectedIndex();
        super.setSelectedIndex(n);
    }

    @Override
    public void removeTabAt(int n) {
        super.removeTabAt(n);
        this.previousTabIndex = -1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.onlyCloseActive = GuiSettings.getCloseActiveTabOnly();
        this.updateButtons();
    }
}

