/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import workbench.db.CatalogChanger;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.WbAction;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.gui.components.ConnectionInfo;
import workbench.gui.components.ConnectionSelector;
import workbench.gui.components.FlatButton;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbToolbarButton;
import workbench.gui.dbobjects.DbExplorerWindow;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.gui.dbobjects.ProcedureListPanel;
import workbench.gui.dbobjects.TableListPanel;
import workbench.gui.dbobjects.TableSearchPanel;
import workbench.gui.dbobjects.TriggerListPanel;
import workbench.gui.dbobjects.objecttree.ObjectFinder;
import workbench.gui.sql.PanelTitleSetter;
import workbench.gui.sql.PanelType;
import workbench.interfaces.Connectable;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.MainPanel;
import workbench.interfaces.Reloadable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.HtmlUtil;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;
import workbench.util.WbProperties;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class DbExplorerPanel
extends JPanel
implements ActionListener,
MainPanel,
DbExecutionListener,
PropertyChangeListener,
Reloadable {
    private JTabbedPane tabPane;
    protected TableListPanel tables;
    protected TableSearchPanel searchPanel;
    protected ProcedureListPanel procs;
    protected TriggerListPanel triggers;
    protected JComboBox schemaSelector;
    private JComboBox catalogSelector;
    private JLabel schemaLabel;
    private JLabel catalogLabel;
    private JPanel selectorPanel;
    private WbConnection dbConnection;
    private DbExplorerWindow window;
    private WbToolbar toolbar;
    private ConnectionInfo connectionInfo;
    protected boolean retrievePending;
    private boolean schemaRetrievePending = true;
    private boolean connectionInitPending = true;
    private int internalId = 0;
    private ConnectionSelector connectionSelector;
    private JButton selectConnectionButton;
    private String tabTitle;
    private static int instanceCount = 0;
    private MainWindow mainWindow;
    private boolean busy;
    private String schemaFromWorkspace;
    private String catalogFromWorkspace;
    private boolean switchCatalog;
    private JComponent currentFocus;
    private ReloadAction reloadSchemasAction;
    private JButton reloadButton;
    private boolean locked;
    protected String tabName;
    private final ReentrantReadWriteLock busyLock = new ReentrantReadWriteLock();

    public DbExplorerPanel() {
        this((MainWindow)null);
    }

    public DbExplorerPanel(MainWindow mainWindow) {
        this.internalId = ++instanceCount;
        this.mainWindow = mainWindow;
        this.setName("dbexplorer");
        try {
            this.tables = new TableListPanel(mainWindow);
            this.tables.setName("tablelistpanel");
            this.procs = new ProcedureListPanel(mainWindow);
            this.searchPanel = new TableSearchPanel(this.tables);
            this.tabPane = new WbTabbedPane(1);
            this.tabPane.add(ResourceMgr.getString("TxtDbExplorerTables"), this.tables);
            this.tabPane.setToolTipTextAt(0, ResourceMgr.getDescription("TxtDbExplorerTables"));
            this.setDbExecutionListener(mainWindow);
            String string = Settings.getInstance().getProperty("workbench.gui.dbobjects.maintabs", "top");
            int n = 1;
            if (string.equalsIgnoreCase("bottom")) {
                n = 3;
            } else if (string.equalsIgnoreCase("left")) {
                n = 2;
            } else if (string.equalsIgnoreCase("right")) {
                n = 4;
            }
            this.tabPane.setTabPlacement(n);
            this.tabPane.add(ResourceMgr.getString("TxtDbExplorerProcs"), this.procs);
            this.tabPane.setToolTipTextAt(1, ResourceMgr.getDescription("TxtDbExplorerProcs"));
            if (DbExplorerSettings.getShowTriggerPanel()) {
                this.triggers = new TriggerListPanel(mainWindow);
                this.tabPane.add(ResourceMgr.getString("TxtDbExplorerTriggers"), this.triggers);
                this.tabPane.setToolTipTextAt(this.tabPane.getTabCount() - 1, ResourceMgr.getDescription("TxtDbExplorerTriggers"));
            }
            this.tabPane.add(ResourceMgr.getString("TxtSearchTables"), this.searchPanel);
            this.tabPane.setToolTipTextAt(this.tabPane.getTabCount() - 1, ResourceMgr.getDescription("TxtSearchTables"));
            this.tabPane.setFocusable(false);
            this.setBorder(WbSwingUtilities.EMPTY_BORDER);
            this.setLayout(new BorderLayout());
            this.reloadSchemasAction = new ReloadAction(this);
            this.reloadSchemasAction.setEnabled(false);
            this.reloadSchemasAction.setTooltip(ResourceMgr.getString("TxtReload"));
            this.reloadSchemasAction.setUseLabelIconSize(true);
            this.schemaLabel = new JLabel(ResourceMgr.getString("LblSchema"));
            this.schemaSelector = new JComboBox();
            this.schemaSelector.setMaximumRowCount(15);
            this.catalogSelector = new JComboBox();
            this.catalogSelector.setMaximumRowCount(15);
            this.catalogLabel = new JLabel("Catalog");
            this.catalogSelector.setVisible(false);
            this.catalogSelector.setEnabled(false);
            this.catalogLabel.setVisible(false);
            this.reloadButton = new FlatButton(this.reloadSchemasAction);
            this.reloadButton.setText(null);
            this.reloadButton.setMargin(WbToolbarButton.SMALL_MARGIN);
            this.selectorPanel = new JPanel(new FlowLayout(3, 5, 0));
            this.selectorPanel.add(this.schemaLabel);
            this.selectorPanel.add(this.schemaSelector);
            this.selectorPanel.add(this.catalogLabel);
            this.selectorPanel.add(this.catalogSelector);
            this.selectorPanel.add(this.reloadButton);
            this.add((Component)this.selectorPanel, "North");
            this.add((Component)this.tabPane, "Center");
            this.toolbar = new WbToolbar();
            this.toolbar.addSimpleBorder();
            this.toolbar.setLayout(new BorderLayout());
            this.connectionInfo = new ConnectionInfo(this.toolbar.getBackground());
            this.toolbar.add((Component)this.connectionInfo, "Center");
            WbToolbarButton wbToolbarButton = new WbToolbarButton(IconMgr.getInstance().getToolbarIcon("save"));
            Dimension dimension = wbToolbarButton.getPreferredSize();
            Dimension dimension2 = this.connectionInfo.getPreferredSize();
            dimension2.height = dimension.height;
            this.connectionInfo.setMinimumSize(dimension2);
            this.connectionInfo.setPreferredSize(dimension2);
            this.reloadButton.setPreferredSize(dimension);
            this.reloadButton.setMaximumSize(dimension);
            if (this.mainWindow != null) {
                this.mainWindow.addExecutionListener(this);
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addPropertyChangeListener("focusOwner", this);
            this.setMinimumSize(new Dimension(10, 10));
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize DbExplorerPanel", throwable);
        }
    }

    @Override
    public void reload() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        if (this.schemaSelector.isVisible()) {
            this.startRetrieveSchemas(false);
        } else if (this.catalogSelector.isVisible()) {
            this.readCatalogs();
        }
    }

    @Override
    public void registerObjectFinder(ObjectFinder objectFinder) {
    }

    @Override
    public boolean isModifiedAfter(long l) {
        return false;
    }

    @Override
    public boolean supportsBookmarks() {
        return false;
    }

    @Override
    public List<NamedScriptLocation> getBookmarks() {
        return null;
    }

    @Override
    public void jumpToBookmark(NamedScriptLocation namedScriptLocation) {
    }

    @Override
    public void setLocked(boolean bl) {
        this.locked = bl;
        this.updateTabTitle();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isCancelling() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isVisible()) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof JComponent && "focusOwner".equals(string)) {
            this.currentFocus = (JComponent)propertyChangeEvent.getNewValue();
        }
    }

    @Override
    public void setConnectionClient(Connectable connectable) {
    }

    public final void setDbExecutionListener(DbExecutionListener dbExecutionListener) {
        if (this.tables != null) {
            this.tables.setDbExecutionListener(dbExecutionListener);
        }
        if (this.searchPanel != null) {
            this.searchPanel.addDbExecutionListener(dbExecutionListener);
        }
    }

    public void setSwitchCatalog(boolean bl) {
        this.switchCatalog = bl && this.canSwitchCatalog();
    }

    private boolean canSwitchCatalog() {
        if (this.dbConnection == null) {
            return DbExplorerSettings.getSwitchCatalogInExplorer();
        }
        return this.dbConnection.getDbSettings().getSwitchCatalogInExplorer();
    }

    public void showConnectButton(ConnectionSelector connectionSelector) {
        this.connectionSelector = connectionSelector;
        this.selectConnectionButton = new JButton(ResourceMgr.getString("LblSelectConnection"));
        CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(1, 10, 1, 10));
        this.selectConnectionButton.setBorder(compoundBorder);
        this.selectConnectionButton.addActionListener(this);
        this.selectorPanel.add(Box.createHorizontalStrut(15));
        this.selectorPanel.add(this.selectConnectionButton);
    }

    private void setBusy(boolean bl) {
        this.busyLock.writeLock().lock();
        try {
            this.busy = bl;
            this.schemaSelector.setEnabled(!bl);
            this.catalogSelector.setEnabled(!bl);
            this.reloadButton.setEnabled(!bl);
        }
        finally {
            this.busyLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isBusy() {
        this.busyLock.readLock().lock();
        try {
            boolean bl = this.busy;
            return bl;
        }
        finally {
            this.busyLock.readLock().unlock();
        }
    }

    @Override
    public String getId() {
        return "WbExp-" + NumberStringCache.getNumberString(this.internalId);
    }

    private void startRetrieveSchemas(final boolean bl) {
        if (this.isBusy() || this.isConnectionBusy() || this.dbConnection == null || this.dbConnection.getMetadata() == null) {
            this.schemaRetrievePending = true;
            return;
        }
        if (this.connectionInitPending) {
            this.initConnection();
        }
        WbThread wbThread = new WbThread("DbExplorer schema retrieval"){

            @Override
            public void run() {
                DbExplorerPanel.this.retrieveAndShowSchemas(bl);
            }
        };
        wbThread.start();
    }

    private void retrieveAndShowSchemas(boolean bl) {
        if (this.dbConnection == null) {
            return;
        }
        if (this.dbConnection.getMetadata() == null) {
            return;
        }
        String string = this.getSelectedCatalog();
        if ("*".equals(string)) {
            string = null;
        }
        List<String> list = this.dbConnection.getMetadata().getSchemas(this.dbConnection.getSchemaFilter(), string);
        WbSwingUtilities.invoke(() -> this._showSchemas(list, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _showSchemas(List<String> list, boolean bl) {
        String string = null;
        try {
            Object object;
            this.schemaSelector.removeActionListener(this);
            this.setBusy(true);
            String string2 = null;
            boolean bl2 = false;
            if (bl && this.dbConnection.getProfile().getStoreExplorerSchema()) {
                string2 = this.schemaFromWorkspace;
                bl2 = true;
            }
            if (string2 == null) {
                string2 = this.dbConnection.getCurrentSchema();
            }
            if (string2 == null) {
                string2 = this.dbConnection.getCurrentUser();
            }
            if (list.size() > 0) {
                object = this.schemaSelector.getSelectedItem();
                if (!bl2 && object != null) {
                    string2 = object.toString();
                }
                this.schemaSelector.setEnabled(true);
                this.schemaSelector.setVisible(true);
                this.schemaLabel.setVisible(true);
                this.schemaSelector.removeAllItems();
                this.schemaSelector.addItem("*");
                if ("*".equals(string2)) {
                    string = "*";
                }
                for (String string3 : list) {
                    this.schemaSelector.addItem(string3.trim());
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    string = string3;
                }
                if (bl2 && string == null) {
                    string = this.dbConnection.getMetadata().getCurrentSchema();
                }
                if (string != null) {
                    this.schemaSelector.setSelectedItem(string);
                } else {
                    this.schemaSelector.setSelectedIndex(0);
                }
                string2 = (String)this.schemaSelector.getSelectedItem();
            } else {
                this.schemaSelector.setEnabled(false);
                this.schemaSelector.setVisible(false);
                this.schemaLabel.setVisible(false);
                string2 = null;
            }
            try {
                if (this.dbConnection.getDbSettings().supportsCatalogs()) {
                    this.readCatalogs();
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not read catalogs", exception);
            }
            object = this.getSelectedCatalog();
            this.tables.setCatalogAndSchema((String)object, string2, false);
            this.procs.setCatalogAndSchema((String)object, string2, false);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve list of schemas", throwable);
        }
        finally {
            this.schemaRetrievePending = false;
            this.setBusy(false);
        }
        if (this.schemaSelector.isVisible() || this.catalogSelector.isVisible()) {
            this.reloadButton.setVisible(true);
            this.reloadSchemasAction.setEnabled(true);
        } else {
            this.reloadButton.setVisible(false);
            this.reloadSchemasAction.setEnabled(false);
        }
        this.schemaSelector.addActionListener(this);
    }

    @Override
    public boolean isConnected() {
        return this.dbConnection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect(ConnectionProfile connectionProfile) {
        ConnectionMgr connectionMgr = ConnectionMgr.getInstance();
        WbConnection wbConnection = null;
        try {
            WbSwingUtilities.showWaitCursor(this);
            wbConnection = connectionMgr.getConnection(connectionProfile, this.getId());
            this.setConnection(wbConnection);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error getting new connection for DbExplorer tab.", exception);
            String string = ExceptionUtil.getDisplay(exception);
            WbSwingUtilities.showErrorMessage(this, string);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    public void connect(final ConnectionProfile connectionProfile) {
        if (!this.isConnected()) {
            WbThread wbThread = new WbThread("DbExplorer connection"){

                @Override
                public void run() {
                    DbExplorerPanel.this.doConnect(connectionProfile);
                }
            };
            wbThread.start();
        }
    }

    private boolean isConnectionBusy() {
        if (this.dbConnection == null) {
            return false;
        }
        if (!this.dbConnection.isShared()) {
            return this.isBusy();
        }
        return this.dbConnection.isBusy();
    }

    private void initConnection() {
        if (this.dbConnection == null) {
            return;
        }
        if (this.tables == null) {
            return;
        }
        try {
            this.tables.setConnection(this.dbConnection);
            this.procs.setConnection(this.dbConnection);
            if (this.triggers != null) {
                this.triggers.setConnection(this.dbConnection);
            }
            if (this.searchPanel != null) {
                this.searchPanel.setConnection(this.dbConnection);
            }
            this.readSchemaLabel();
            this.connectionInitPending = false;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
    }

    private void readSchemaLabel() {
        String string = this.dbConnection.getMetadata().getSchemaTerm();
        this.schemaLabel.setText(StringUtil.capitalize(string));
        this.reloadSchemasAction.setTooltip(ResourceMgr.getFormattedString("TxtReloadSchemas", string));
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.setSwitchCatalog(false);
        this.reloadSchemasAction.setEnabled(this.dbConnection != null);
        if (wbConnection == null) {
            this.reset();
            this.connectionInitPending = false;
            return;
        }
        if (this.isBusy()) {
            return;
        }
        try {
            if (this.connectionSelector != null) {
                this.setSwitchCatalog(true);
            } else if (wbConnection.getProfile() != null) {
                boolean bl = !wbConnection.isShared();
                this.setSwitchCatalog(bl);
                if (bl) {
                    ExplorerUtils.initDbExplorerConnection(this.dbConnection);
                }
            }
            this.connectionInitPending = true;
            this.schemaRetrievePending = true;
            this.retrievePending = DbExplorerSettings.getRetrieveDbExplorer();
            if (this.window != null) {
                this.window.updateTitle(wbConnection);
            }
            this.connectionInfo.setConnection(wbConnection);
            if (!this.isConnectionBusy()) {
                this.initConnection();
                if (this.isVisible() && this.retrievePending) {
                    this.retrieve();
                }
            }
        }
        catch (Throwable throwable) {
            this.retrievePending = true;
            this.schemaRetrievePending = true;
            LogMgr.logError(new CallerInfo(){}, "Error during connection init", throwable);
        }
    }

    private void readCatalogs() {
        List<String> list = this.dbConnection.getMetadata().getCatalogInformation(this.dbConnection.getCatalogFilter());
        this.catalogSelector.removeActionListener(this);
        if (list.isEmpty()) {
            this.catalogSelector.setVisible(false);
            this.catalogSelector.setEnabled(false);
            this.catalogLabel.setVisible(false);
            this.catalogFromWorkspace = null;
        } else {
            String string = StringUtil.capitalize(this.dbConnection.getMetadata().getCatalogTerm());
            String string2 = null;
            if (this.dbConnection.getProfile().getStoreExplorerSchema() && this.catalogFromWorkspace != null) {
                string2 = this.catalogFromWorkspace;
                this.catalogFromWorkspace = null;
            } else {
                Object object;
                string2 = this.catalogSelector.getItemCount() > 0 ? ((object = this.catalogSelector.getSelectedItem()) == null ? null : object.toString()) : this.dbConnection.getMetadata().getCurrentCatalog();
            }
            this.catalogSelector.removeAllItems();
            this.catalogLabel.setText(string);
            int n = 0;
            int n2 = 0;
            for (String string3 : list) {
                if (string3.equalsIgnoreCase(string2)) {
                    n2 = n;
                }
                this.catalogSelector.addItem(string3);
                ++n;
            }
            this.catalogSelector.setSelectedIndex(n2);
            this.catalogSelector.addActionListener(this);
            this.catalogSelector.setVisible(true);
            this.catalogSelector.setEnabled(true);
            this.catalogLabel.setVisible(true);
        }
        this.selectorPanel.validate();
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (!bl2 && bl) {
            if (this.retrievePending) {
                EventQueue.invokeLater(this::retrieve);
            } else if (this.schemaRetrievePending) {
                this.startRetrieveSchemas(true);
            }
            if (this.currentFocus != null) {
                WbSwingUtilities.requestFocus(this.currentFocus);
            }
        }
    }

    @Override
    public void panelSelected() {
        Component component = this.tabPane.getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component == this.tables) {
            this.tables.panelSelected();
        } else if (component == this.procs) {
            this.procs.panelSelected();
        } else if (component == this.triggers) {
            this.triggers.panelSelected();
        }
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public void reset() {
        this.setLocked(false);
        if (this.tables != null) {
            this.tables.reset();
        }
        if (this.procs != null) {
            this.procs.reset();
        }
        if (this.searchPanel != null) {
            this.searchPanel.reset();
        }
        if (this.tabPane != null && this.tabPane.getTabCount() > 0) {
            this.tabPane.setSelectedIndex(0);
        }
    }

    @Override
    public void disconnect() {
        if (this.tables != null) {
            this.tables.disconnect();
        }
        if (this.procs != null) {
            this.procs.disconnect();
        }
        if (this.triggers != null) {
            this.triggers.disconnect();
        }
        this.searchPanel.disconnect();
        this.dbConnection = null;
        this.reset();
    }

    public void saveSettings() {
        if (this.tables != null) {
            this.tables.saveSettings();
        }
        if (this.procs != null) {
            this.procs.saveSettings();
        }
        if (this.triggers != null) {
            this.triggers.saveSettings();
        }
        if (this.searchPanel != null) {
            this.searchPanel.saveSettings();
        }
    }

    public void restoreSettings() {
        if (this.tables != null) {
            this.tables.restoreSettings();
        }
        if (this.procs != null) {
            this.procs.restoreSettings();
        }
        if (this.triggers != null) {
            this.triggers.restoreSettings();
        }
        if (this.searchPanel != null) {
            this.searchPanel.restoreSettings();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.schemaSelector) {
            this.retrieve();
        } else if (actionEvent.getSource() == this.selectConnectionButton) {
            this.connectionSelector.selectConnection();
        } else if (actionEvent.getSource() == this.catalogSelector) {
            String string = this.getSelectedCatalog();
            if (this.switchCatalog && !"*".equals(string)) {
                try {
                    CatalogChanger catalogChanger = new CatalogChanger();
                    catalogChanger.setCurrentCatalog(this.dbConnection, string);
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not switch catalog", sQLException);
                    WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(sQLException));
                }
            }
            this.schemaRetrievePending = true;
            this.retrieve();
        }
    }

    protected String getSelectedCatalog() {
        if (this.catalogSelector == null) {
            return null;
        }
        return (String)this.catalogSelector.getSelectedItem();
    }

    protected void retrieve() {
        if (this.dbConnection == null) {
            return;
        }
        if (this.isBusy() || this.isConnectionBusy()) {
            this.retrievePending = true;
            return;
        }
        if (this.connectionInitPending) {
            this.initConnection();
        }
        final DbExplorerPanel dbExplorerPanel = this;
        WbSwingUtilities.showWaitCursorOnWindow(this);
        WbThread wbThread = new WbThread("SchemaChange"){

            @Override
            public void run() {
                try {
                    DbExplorerPanel.this.setBusy(true);
                    if (DbExplorerPanel.this.schemaRetrievePending) {
                        DbExplorerPanel.this.retrieveAndShowSchemas(true);
                    }
                    String string = (String)DbExplorerPanel.this.schemaSelector.getSelectedItem();
                    WbSwingUtilities.showWaitCursorOnWindow(dbExplorerPanel);
                    DbExplorerPanel.this.tables.setCatalogAndSchema(DbExplorerPanel.this.getSelectedCatalog(), string, true);
                    DbExplorerPanel.this.procs.setCatalogAndSchema(DbExplorerPanel.this.getSelectedCatalog(), string, true);
                    if (DbExplorerPanel.this.triggers != null) {
                        DbExplorerPanel.this.triggers.setCatalogAndSchema(DbExplorerPanel.this.getSelectedCatalog(), string, true);
                    }
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Could not set schema", exception);
                }
                finally {
                    DbExplorerPanel.this.retrievePending = false;
                    DbExplorerPanel.this.setBusy(false);
                    WbSwingUtilities.showDefaultCursorOnWindow(dbExplorerPanel);
                }
            }
        };
        wbThread.start();
    }

    @Override
    public void setTabName(String string) {
        this.tabTitle = string;
    }

    public String getRealTabTitle() {
        JTabbedPane jTabbedPane;
        int n;
        if (this.getParent() instanceof JTabbedPane && (n = (jTabbedPane = (JTabbedPane)this.getParent()).indexOfComponent(this)) > -1) {
            String string = jTabbedPane.getTitleAt(n);
            return string;
        }
        return this.getTabTitle();
    }

    protected void updateTabTitle() {
        PanelTitleSetter.updateTitle(this);
    }

    @Override
    public String getTabTitle() {
        return this.tabTitle == null ? ResourceMgr.getString("LblDbExplorer") : this.tabTitle;
    }

    @Override
    public void setTabTitle(JTabbedPane jTabbedPane, int n) {
        String string = this.getTabTitle();
        PanelTitleSetter.setTabTitle(jTabbedPane, this, n, string);
    }

    public DbExplorerWindow openWindow(ConnectionProfile connectionProfile) {
        if (this.window == null) {
            this.window = new DbExplorerWindow(this, connectionProfile);
        }
        this.window.setVisible(true);
        return this.window;
    }

    @Override
    public List<Object> getMenuItems() {
        return Collections.emptyList();
    }

    @Override
    public WbToolbar getToolbar(List<WbAction> list, boolean bl) {
        return this.toolbar;
    }

    @Override
    public void showLogMessage(CharSequence charSequence) {
    }

    @Override
    public void clearLog() {
    }

    @Override
    public void appendToLog(CharSequence charSequence) {
    }

    @Override
    public void showLogPanel() {
    }

    @Override
    public void showResultPanel() {
    }

    void explorerWindowClosed() {
        if (this.dbConnection != null && !this.dbConnection.isShared()) {
            try {
                this.dbConnection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dispose();
        this.disconnect();
        if (this.mainWindow != null) {
            this.mainWindow.explorerWindowClosed(this.window);
        }
        this.window = null;
    }

    @Override
    public void dispose() {
        this.reset();
        this.disconnect();
        if (this.tables != null) {
            this.tables.dispose();
            this.tables = null;
        }
        if (this.procs != null) {
            this.procs.dispose();
            this.procs = null;
        }
        if (this.triggers != null) {
            this.triggers.dispose();
            this.triggers = null;
        }
        if (this.mainWindow != null) {
            this.mainWindow.removeExecutionListener(this);
        }
    }

    @Override
    public void storeInWorkspace(WbWorkspace wbWorkspace, int n) {
        Object object = this.schemaSelector.getSelectedItem();
        WbProperties wbProperties = wbWorkspace.getSettings();
        String string = "dbexplorer" + n + ".currentschema";
        if (object != null) {
            wbProperties.setProperty(string, object.toString());
        } else if (this.schemaFromWorkspace != null) {
            wbProperties.setProperty(string, this.schemaFromWorkspace);
        }
        string = "dbexplorer" + n + ".currentcatalog";
        object = this.getSelectedCatalog();
        if (object != null) {
            wbProperties.setProperty(string, object.toString());
        } else if (this.catalogFromWorkspace != null) {
            wbProperties.setProperty(string, this.catalogFromWorkspace);
        }
        wbProperties.setProperty("dbexplorer" + n + ".locked", this.locked);
        wbProperties.setProperty("tab" + n + ".type", PanelType.dbExplorer.toString());
        wbProperties.setProperty("tab" + n + ".title", this.getTabTitle());
        this.tables.saveToWorkspace(wbWorkspace, n);
        this.searchPanel.saveToWorkspace(wbWorkspace, n);
        this.procs.saveToWorkspace(wbWorkspace, n);
        if (this.triggers != null) {
            this.triggers.saveToWorkspace(wbWorkspace, n);
        }
    }

    @Override
    public boolean isModified() {
        if (this.tables == null) {
            return false;
        }
        return this.tables.isModified();
    }

    @Override
    public boolean canClosePanel(boolean bl) {
        if (!GuiSettings.getConfirmDiscardResultSetChanges()) {
            return true;
        }
        if (!this.isModified()) {
            return true;
        }
        boolean bl2 = WbSwingUtilities.getProceedCancel(this, "MsgDiscardTabChanges", HtmlUtil.cleanHTML(this.getRealTabTitle()));
        return bl2;
    }

    @Override
    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) throws IOException {
        this.schemaFromWorkspace = null;
        this.catalogFromWorkspace = null;
        this.reset();
        try {
            WbProperties wbProperties = wbWorkspace.getSettings();
            this.schemaFromWorkspace = wbProperties.getProperty("dbexplorer" + n + ".currentschema", null);
            this.catalogFromWorkspace = wbProperties.getProperty("dbexplorer" + n + ".currentcatalog", null);
            if (this.tables != null) {
                this.tables.readFromWorkspace(wbWorkspace, n);
            }
            if (this.searchPanel != null) {
                this.searchPanel.readFromWorkspace(wbWorkspace, n);
            }
            if (this.procs != null) {
                this.procs.readFromWorkspace(wbWorkspace, n);
            }
            if (this.triggers != null) {
                this.triggers.readFromWorkspace(wbWorkspace, n);
            }
            this.setTabName(wbProperties.getProperty("tab" + n + ".title"));
            this.locked = wbProperties.getBoolProperty("dbexplorer" + n + ".locked", false);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error loading workspace", exception);
        }
        EventQueue.invokeLater(this::updateTabTitle);
    }

    @Override
    public void executionStart(WbConnection wbConnection, Object object) {
    }

    @Override
    public void executionEnd(WbConnection wbConnection, Object object) {
        if (!this.isVisible()) {
            return;
        }
        if (this.retrievePending) {
            this.retrieve();
        } else if (this.schemaRetrievePending) {
            this.startRetrieveSchemas(true);
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

