/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ExecuteSqlPanel;
import workbench.gui.editor.SearchAndReplace;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class RunScriptPanel
extends ExecuteSqlPanel {
    private JButton cancelButton;
    private JButton closeButton;
    private JButton saveAsButton;
    private JButton startButton;
    private boolean wasRun;
    private String textToHighlight;

    public RunScriptPanel(WbConnection wbConnection, String string) {
        super(wbConnection, string);
    }

    @Override
    protected JPanel getToolPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.startButton = new JButton(ResourceMgr.getString("LblStartSql"));
        this.cancelButton = new JButton(ResourceMgr.getString("LblCancelPlain"));
        this.cancelButton.setEnabled(false);
        this.closeButton = new JButton(ResourceMgr.getString("LblClose"));
        this.saveAsButton = new JButton(ResourceMgr.getString("MnuTxtFileSave"));
        this.startButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.saveAsButton.setAction(this.sqlEditor.getFileSaveAsAction());
        this.saveAsButton.setEnabled(true);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        jPanel2.add(this.saveAsButton);
        jPanel2.add(this.startButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "Before");
        jPanel.add((Component)this.closeButton, "After");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.startButton) {
            this.startSQL();
        } else if (actionEvent.getSource() == this.closeButton) {
            this.closeWindow();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancel();
        }
    }

    @Override
    protected void runSQL() {
        this.wasRun = true;
        super.runSQL();
    }

    @Override
    protected JLabel getLabel() {
        return null;
    }

    @Override
    protected String getWindowSettingsKey() {
        return "workbench.gui.runscript.window";
    }

    public boolean wasRun() {
        return this.wasRun;
    }

    @Override
    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.startButton.setEnabled(bl);
        this.cancelButton.setEnabled(!this.startButton.isEnabled());
    }

    private void highlightText(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        SearchAndReplace searchAndReplace = this.sqlEditor.getReplacer();
        searchAndReplace.setShowNotifications(false);
        int n = searchAndReplace.findFirst(string, true, true, false);
        int n2 = n + string.length();
        if (n > -1) {
            this.sqlEditor.select(n, n2);
        }
        this.sqlEditor.requestFocusInWindow();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        super.windowOpened(windowEvent);
        this.sqlEditor.setCaretPosition(0);
        this.highlightText(this.textToHighlight);
    }

    public void openWindow(Component component, String string) {
        this.openWindow(component, string, null);
    }

    public void openWindow(Component component, String string, String string2) {
        Frame frame = null;
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof Frame) {
            frame = (Frame)window;
        }
        this.openWindow(frame, string, string2);
    }

    public void openWindow(Frame frame, String string, String string2) {
        this.textToHighlight = string2;
        WbSwingUtilities.invoke(() -> this.showDialog(frame, string, true));
    }
}

