/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.db.search.ServerSideTableSearcher;
import workbench.db.search.TableDataSearcher;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.dbobjects.TableSearchCriteriaGUI;
import workbench.interfaces.PropertyStorage;
import workbench.resource.ResourceMgr;

public class ServerSideTableSearchPanel
extends JPanel
implements TableSearchCriteriaGUI {
    private JTextField columnFunction;
    private JTextField searchText;
    private ServerSideTableSearcher searcher = new ServerSideTableSearcher();

    public ServerSideTableSearchPanel() {
        super(new GridBagLayout());
        this.initComponents();
    }

    private void initComponents() {
        this.searchText = new JTextField();
        this.searchText.addMouseListener(new TextComponentMouseListener());
        String string = ResourceMgr.getDescription("LblSearchTableSqlCriteria");
        this.searchText.setToolTipText(string);
        this.columnFunction = new JTextField();
        this.columnFunction.addMouseListener(new TextComponentMouseListener());
        JLabel jLabel = new JLabel();
        this.columnFunction.setColumns(8);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.columnFunction, gridBagConstraints);
        jLabel.setText("LIKE");
        jLabel.setToolTipText(string);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 5);
        this.add((Component)this.searchText, gridBagConstraints);
    }

    @Override
    public void disableControls() {
        this.columnFunction.setEnabled(false);
        this.searchText.setEnabled(false);
    }

    @Override
    public void enableControls() {
        this.columnFunction.setEnabled(true);
        this.searchText.setEnabled(true);
    }

    @Override
    public TableDataSearcher getSearcher() {
        this.searcher.setCriteria(this.searchText.getText(), false);
        this.searcher.setColumnFunction(this.columnFunction.getText());
        return this.searcher;
    }

    @Override
    public void saveSettings(String string, PropertyStorage propertyStorage) {
        propertyStorage.setProperty(string + ".criteria", this.searchText.getText());
        propertyStorage.setProperty(string + ".column-function", this.columnFunction.getText());
    }

    @Override
    public void restoreSettings(String string, PropertyStorage propertyStorage) {
        this.searchText.setText(propertyStorage.getProperty(string + ".criteria", ""));
        this.columnFunction.setText(propertyStorage.getProperty(string + ".column-function", "$col$"));
    }

    @Override
    public void addKeyListenerForCriteria(KeyListener keyListener) {
        this.searchText.addKeyListener(keyListener);
    }
}

