/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.WbManager;
import workbench.db.DependencyNode;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbScrollPane;
import workbench.gui.dbobjects.TableLister;
import workbench.gui.renderer.DependencyTreeCellRenderer;
import workbench.interfaces.Resettable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;

public class TableDependencyTreeDisplay
extends JPanel
implements Resettable,
MouseListener {
    private WbConnection connection;
    private DependencyTreeCellRenderer renderer;
    private List<TreeNode[]> nodesToExpand;
    private boolean showExported;
    private JTree tree;
    private TableLister tables;
    private TableDependency dependencyReader;
    private boolean retrieveAll = true;

    public TableDependencyTreeDisplay(TableLister tableLister) {
        this.setLayout(new BorderLayout());
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.tables = tableLister;
    }

    public void cancelRetrieve() {
        if (this.dependencyReader != null) {
            this.dependencyReader.cancel();
        }
    }

    public void setRetrieveAll(boolean bl) {
        this.retrieveAll = bl;
    }

    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    public void readReferencedTables(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return;
        }
        this.readTree(tableIdentifier, true);
    }

    public void readReferencingTables(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return;
        }
        this.readTree(tableIdentifier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTree(TableIdentifier tableIdentifier, boolean bl) {
        this.reset();
        this.showExported = bl;
        try {
            WbSwingUtilities.showWaitCursor(this);
            this.dependencyReader = new TableDependency(this.connection, tableIdentifier);
            this.dependencyReader.setRetrieveDirectChildrenOnly(!this.retrieveAll);
            if (bl) {
                this.dependencyReader.readTreeForParents();
            } else {
                this.dependencyReader.readTreeForChildren();
            }
            DependencyNode dependencyNode = this.dependencyReader.getRootNode();
            if (dependencyNode != null) {
                this.readTreeNodes(dependencyNode);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            WbManager.getInstance().showOutOfMemoryError();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading three", exception);
        }
        finally {
            this.dependencyReader = null;
        }
        WbSwingUtilities.showDefaultCursor(this);
    }

    @Override
    public void reset() {
        this.createTree();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(), false);
        this.tree.setModel(defaultTreeModel);
    }

    private void createTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.renderer = new DependencyTreeCellRenderer();
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            this.tree.setCellRenderer(this.renderer);
            this.tree.addMouseListener(this);
            this.tree.setRowHeight(0);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            WbScrollPane wbScrollPane = new WbScrollPane(this.tree);
            this.add((Component)wbScrollPane, "Center");
        }
    }

    private void createTreeDisplay(DefaultMutableTreeNode defaultMutableTreeNode) {
        WbSwingUtilities.invoke(() -> {
            this.createTree();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, false);
            this.tree.setModel(defaultTreeModel);
            this.expandNodes();
        });
    }

    private void readTreeNodes(DependencyNode dependencyNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (dependencyNode.getChildren().size() > 0) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(dependencyNode, true);
            this.buildTree(dependencyNode, defaultMutableTreeNode);
            this.createTreeDisplay(defaultMutableTreeNode);
        } else {
            this.reset();
        }
    }

    private void buildTree(DependencyNode dependencyNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = dependencyNode.getTable().getTableName();
        this.nodesToExpand = new ArrayList<TreeNode[]>();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        String string2 = null;
        List<DependencyNode> list = dependencyNode.getChildren();
        for (DependencyNode dependencyNode2 : list) {
            TreeNode[] treeNodeArray;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(dependencyNode2, true);
            defaultMutableTreeNode2.setAllowsChildren(true);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            int n = dependencyNode2.getChildren().size();
            Map<String, String> map = dependencyNode2.getColumns();
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                string2 = dependencyNode2.getTable().getTableName();
                treeNodeArray = iterator.next();
                StringBuilder stringBuilder = new StringBuilder(100);
                stringBuilder.append("<html><b>");
                if (this.showExported) {
                    stringBuilder.append(string);
                    stringBuilder.append('.');
                    stringBuilder.append(treeNodeArray.getValue());
                } else {
                    stringBuilder.append(string2);
                    stringBuilder.append('.');
                    stringBuilder.append(treeNodeArray.getKey());
                }
                stringBuilder.append("</b> REFERENCES <b>");
                if (this.showExported) {
                    stringBuilder.append(string2);
                    stringBuilder.append('.');
                    stringBuilder.append(treeNodeArray.getKey());
                } else {
                    stringBuilder.append(string);
                    stringBuilder.append('.');
                    stringBuilder.append(treeNodeArray.getValue());
                }
                stringBuilder.append("</b></html>");
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(stringBuilder.toString());
                defaultMutableTreeNode3.setAllowsChildren(false);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            if (n > 0) {
                this.buildTree(dependencyNode2, defaultMutableTreeNode2);
                treeNodeArray = defaultMutableTreeNode2.getPath();
                this.nodesToExpand.add(treeNodeArray);
                continue;
            }
            if (this.retrieveAll) continue;
            this.nodesToExpand.add(defaultMutableTreeNode2.getPath());
        }
    }

    private void expandNodes() {
        if (this.nodesToExpand == null) {
            return;
        }
        for (Object[] objectArray : this.nodesToExpand) {
            TreePath treePath = new TreePath(objectArray);
            this.tree.expandPath(treePath);
        }
        this.nodesToExpand.clear();
        this.nodesToExpand = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            Object object = treePath.getLastPathComponent();
            if (object == this.tree.getModel().getRoot()) {
                return;
            }
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof DependencyNode) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(ResourceMgr.getString("MnuTextSelectInList"));
                DependencyNode dependencyNode = (DependencyNode)object2;
                TableIdentifier tableIdentifier = dependencyNode.getTable();
                jMenuItem.addActionListener(actionEvent -> this.tables.selectTable(tableIdentifier));
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

