/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import workbench.WbManager;
import workbench.db.ConnectionMgr;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.StopAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.interfaces.Interruptable;
import workbench.interfaces.Reloadable;
import workbench.interfaces.ToolWindow;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.wbcommands.WbRowCount;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.CollectionUtil;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class TableRowCountPanel
extends JPanel
implements WindowListener,
Reloadable,
Interruptable,
ToolWindow {
    private static int instanceCount;
    private final WbTable data;
    private final JLabel statusBar;
    private final List<TableIdentifier> tables;
    private Statement currentStatement;
    private volatile boolean cancel;
    private JFrame window;
    private WbConnection dbConnection;
    private final WbConnection sourceConnection;
    private boolean useSeparateConnection;
    private final StopAction cancelAction;
    private final JScrollPane scrollPane;

    public TableRowCountPanel(List<TableIdentifier> list, WbConnection wbConnection) {
        super(new BorderLayout(0, 0));
        this.tables = list;
        ++instanceCount;
        this.sourceConnection = wbConnection;
        this.statusBar = new JLabel();
        this.data = new WbTable(false, false, false);
        this.data.setReadOnly(true);
        this.scrollPane = new JScrollPane(this.data);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        EtchedBorder etchedBorder = new EtchedBorder(1);
        Border border = this.scrollPane.getBorder();
        CompoundBorder compoundBorder = new CompoundBorder(new EmptyBorder(3, 3, 0, 3), border);
        this.scrollPane.setBorder(compoundBorder);
        CompoundBorder compoundBorder2 = new CompoundBorder(new EmptyBorder(3, 2, 2, 3), etchedBorder);
        jPanel.setBorder(compoundBorder2);
        jPanel.add(this.statusBar);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.setBorder(new CompoundBorder(new EmptyBorder(3, 3, 3, 3), etchedBorder));
        ReloadAction reloadAction = new ReloadAction(this);
        wbToolbar.add(reloadAction);
        wbToolbar.addSeparator();
        this.cancelAction = new StopAction(this);
        this.cancelAction.setEnabled(false);
        wbToolbar.add(this.cancelAction);
        this.add((Component)wbToolbar, "First");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)jPanel, "Last");
    }

    private void checkConnection() {
        if (this.dbConnection != null) {
            return;
        }
        if (this.sourceConnection.getProfile().getUseSeparateConnectionPerTab()) {
            try {
                this.showStatusMessage(ResourceMgr.getString("MsgConnecting"));
                this.dbConnection = ConnectionMgr.getInstance().getConnection(this.sourceConnection.getProfile(), "TableRowCount-" + NumberStringCache.getNumberString(instanceCount));
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not get connection", exception);
            }
            finally {
                this.showStatusMessage("");
            }
            this.useSeparateConnection = true;
        } else {
            this.dbConnection = this.sourceConnection;
            this.useSeparateConnection = false;
        }
    }

    @Override
    public void reload() {
        this.retrieveRowCounts();
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    @Override
    public void cancelExecution() {
        this.showStatusMessage(ResourceMgr.getString("MsgCancelling"));
        this.cancel = true;
        if (this.currentStatement != null) {
            LogMgr.logDebug(new CallerInfo(){}, "Trying to cancel the current statement");
            try {
                this.currentStatement.cancel();
            }
            catch (SQLException sQLException) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not cancel statement", sQLException);
            }
        }
    }

    private void connectAndRetrieve() {
        WbThread wbThread = new WbThread("RowCountConnect"){

            @Override
            public void run() {
                TableRowCountPanel.this.checkConnection();
                TableRowCountPanel.this.doRetrieveRowCounts();
            }
        };
        wbThread.start();
    }

    public void retrieveRowCounts() {
        if (CollectionUtil.isEmpty(this.tables)) {
            return;
        }
        if (this.dbConnection == null) {
            this.connectAndRetrieve();
            return;
        }
        WbThread wbThread = new WbThread("RowCounter"){

            @Override
            public void run() {
                TableRowCountPanel.this.doRetrieveRowCounts();
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetrieveRowCounts() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        this.cancelAction.setEnabled(true);
        this.cancel = false;
        DataStore dataStore = WbRowCount.buildResultDataStore(this.dbConnection);
        DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
        this.setModel(dataStoreTableModel);
        ResultSet resultSet = null;
        try {
            this.dbConnection.setBusy(true);
            TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.dbConnection, "tabledata");
            this.currentStatement = this.dbConnection.createStatementForQuery();
            WbSwingUtilities.showWaitCursor(this.scrollPane);
            this.window.setTitle("\u00bb " + ResourceMgr.getString("TxtWindowTitleRowCount"));
            boolean bl = this.dbConnection.getDbSettings().useSavePointForDML();
            int n = this.tables.size();
            for (int i = 0; i < n; ++i) {
                if (this.cancel) {
                } else {
                    TableIdentifier tableIdentifier = this.tables.get(i);
                    this.showTable(tableIdentifier, i + 1, n);
                    String string = tableSelectBuilder.getSelectForCount(tableIdentifier);
                    resultSet = JdbcUtils.runQuery(this.dbConnection, this.currentStatement, string, bl);
                    if (resultSet != null && resultSet.next()) {
                        long l = resultSet.getLong(1);
                        this.addRowCount(tableIdentifier, l);
                    }
                    JdbcUtils.closeResult(resultSet);
                    if (!this.cancel) continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving table count", sQLException);
        }
        finally {
            JdbcUtils.closeAll(resultSet, this.currentStatement);
            this.currentStatement = null;
            this.dbConnection.setBusy(false);
            if (this.useSeparateConnection) {
                this.dbConnection.rollbackSilently();
            }
            this.showStatusMessage("");
            WbSwingUtilities.showDefaultCursor(this.scrollPane);
            this.window.setTitle(ResourceMgr.getString("TxtWindowTitleRowCount"));
            this.data.checkCopyActions();
            this.cancelAction.setEnabled(false);
        }
        dataStoreTableModel.setAllowEditing(false);
        EventQueue.invokeLater(() -> {
            SortDefinition sortDefinition = WbRowCount.getDefaultRowCountSort(this.data.getDataStore(), this.dbConnection);
            this.data.getDataStoreTableModel().setSortDefinition(sortDefinition);
            this.data.requestFocusInWindow();
        });
    }

    private void showTable(TableIdentifier tableIdentifier, int n, int n2) {
        String string = ResourceMgr.getFormattedString("MsgCalculatingRowCount", tableIdentifier.getTableExpression(), n, n2);
        this.showStatusMessage(string);
    }

    private void showStatusMessage(String string) {
        String string2 = StringUtil.isEmptyString(string) ? ResourceMgr.getFormattedString("TxtTableListObjects", this.data.getRowCount()) : string;
        WbSwingUtilities.invoke(() -> this.statusBar.setText(" " + string2));
    }

    private void addRowCount(TableIdentifier tableIdentifier, long l) {
        WbSwingUtilities.invoke(() -> {
            DataStoreTableModel dataStoreTableModel = this.data.getDataStoreTableModel();
            int n = dataStoreTableModel.addRow();
            dataStoreTableModel.setValueAt(l, n, 0);
            dataStoreTableModel.setValueAt(tableIdentifier.getTableName(), n, 1);
            dataStoreTableModel.setValueAt(tableIdentifier.getObjectType(), n, 2);
            dataStoreTableModel.setValueAt(tableIdentifier.getCatalog(), n, 3);
            dataStoreTableModel.setValueAt(tableIdentifier.getSchema(), n, 4);
            this.data.adjustRowsAndColumns();
        });
    }

    private void setModel(DataStoreTableModel dataStoreTableModel) {
        WbSwingUtilities.invoke(() -> this.data.setModel(dataStoreTableModel, true));
    }

    public void showWindow(Window window) {
        if (this.window == null) {
            this.window = new JFrame(ResourceMgr.getString("TxtWindowTitleRowCount"));
            this.window.getContentPane().setLayout(new BorderLayout());
            this.window.getContentPane().add((Component)this, "Center");
            ResourceMgr.setWindowIcons((Window)this.window, "rowcounts");
            if (!Settings.getInstance().restoreWindowSize(this.window, this.getClass().getName())) {
                this.window.setSize(500, 400);
            }
            if (!Settings.getInstance().restoreWindowPosition(this.window, this.getClass().getName())) {
                WbSwingUtilities.center(this.window, window);
            }
            this.window.addWindowListener(this);
            WbManager.getInstance().registerToolWindow(this);
        }
        this.window.setVisible(true);
        this.retrieveRowCounts();
    }

    protected void saveSettings() {
        Settings.getInstance().storeWindowPosition(this.window, this.getClass().getName());
        Settings.getInstance().storeWindowSize(this.window, this.getClass().getName());
    }

    private void doClose() {
        this.cancelExecution();
        this.saveSettings();
        this.window.setVisible(false);
        this.window.dispose();
        this.window = null;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        WbManager.getInstance().unregisterToolWindow(this);
        this.doClose();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.disconnect();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void closeWindow() {
        this.doClose();
    }

    @Override
    public void disconnect() {
        if (this.useSeparateConnection && this.dbConnection != null) {
            this.dbConnection.disconnect();
            this.dbConnection = null;
        }
    }

    @Override
    public void activate() {
        if (this.window != null) {
            this.window.requestFocus();
        }
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public JFrame getWindow() {
        return this.window;
    }
}

