/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.search.TableDataSearcher;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.EmptyTableModel;
import workbench.gui.components.FlatButton;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.dbobjects.ClientSideTableSearchPanel;
import workbench.gui.dbobjects.ServerSideTableSearchPanel;
import workbench.gui.dbobjects.TableSearchCriteriaGUI;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.DbExecutionNotifier;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.ShareableDisplay;
import workbench.interfaces.TableSearchConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.FilteredProperties;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;
import workbench.util.WbWorkspace;

public class TableSearchPanel
extends JPanel
implements TableSearchConsumer,
ListSelectionListener,
KeyListener,
DbExecutionNotifier {
    private TableModel tableListModel;
    private TableDataSearcher searcher;
    private WbConnection connection;
    private String fixedStatusText;
    private ShareableDisplay tableListSource;
    private EditorPanel sqlDisplay;
    private JButton startButton;
    private List<DbExecutionListener> execListener;
    private ClientSideTableSearchPanel clientSearcherCriteria;
    private ServerSideTableSearchPanel serverSearcherCriteria;
    private boolean initialized;
    private FilteredProperties workspaceSettings;
    private int tableCount;
    protected ButtonGroup buttonGroup1;
    protected JPanel buttonPanel;
    protected JPanel criteriaContainer;
    protected JPanel entryPanel;
    protected JCheckBox excludeClobs;
    protected Box.Filler filler1;
    protected JPanel jPanel3;
    protected JSeparator jSeparator1;
    protected JSeparator jSeparator2;
    protected JSeparator jSeparator3;
    protected JSeparator jSeparator4;
    protected JSplitPane jSplitPane1;
    protected JLabel labelRowCount;
    protected JPanel resultPanel;
    protected JScrollPane resultScrollPane;
    protected JTabbedPane resultTabPane;
    protected JTextField rowCount;
    protected JButton selectAllButton;
    protected JPanel selectButtonPanel;
    protected JButton selectNoneButton;
    protected JCheckBox serverSideSearch;
    protected JLabel statusInfo;
    protected JScrollPane tableListScrollPane;
    protected JTable tableNames;
    protected JPanel tablePane;

    public TableSearchPanel(ShareableDisplay shareableDisplay) {
        this.tableListSource = shareableDisplay;
    }

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        if (this.initialized) {
            return;
        }
        this.tableListModel = EmptyTableModel.EMPTY_MODEL;
        this.initComponents();
        JScrollBar jScrollBar = this.resultScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(25);
        jScrollBar.setBlockIncrement(125);
        this.sqlDisplay = EditorPanel.createSqlEditor();
        this.resultTabPane.addTab(ResourceMgr.getString("LblTableSearchSqlLog"), this.sqlDisplay);
        WbTable wbTable = (WbTable)this.tableNames;
        wbTable.setAdjustToColumnLabel(false);
        WbToolbar wbToolbar = new WbToolbar();
        ReloadAction reloadAction = new ReloadAction(this.tableListSource);
        reloadAction.setUseLabelIconSize(true);
        reloadAction.setTooltip(ResourceMgr.getString("TxtRefreshTableList"));
        wbToolbar.add(reloadAction);
        this.buttonPanel.add(wbToolbar);
        this.startButton = new JButton();
        this.startButton.setText(ResourceMgr.getString("LblStartSearch"));
        this.startButton.addActionListener(actionEvent -> this.startSearch());
        this.buttonPanel.add(this.startButton);
        this.tableNames.getSelectionModel().setSelectionMode(2);
        ((WbTable)this.tableNames).setRendererSetup(RendererSetup.getBaseSetup());
        this.fixedStatusText = ResourceMgr.getString("TxtSearchingTable") + " ";
        wbTable.getSelectionModel().addListSelectionListener(this);
        this.startButton.setEnabled(false);
        CompoundBorder compoundBorder = new CompoundBorder(this.statusInfo.getBorder(), new EmptyBorder(0, 2, 0, 0));
        this.statusInfo.setBorder(compoundBorder);
        this.initCriteriaPanel();
        this.initialized = true;
        this.restoreSettings();
        if (this.workspaceSettings != null) {
            this.restoreSettings(this.workspaceSettings.getFilterPrefix(), this.workspaceSettings);
            this.workspaceSettings = null;
        }
        this.setConnection(this.connection);
    }

    private TableSearchCriteriaGUI getCriteriaPanel() {
        return (TableSearchCriteriaGUI)((Object)this.criteriaContainer.getComponent(0));
    }

    private void initCriteriaPanel() {
        this.serverSearcherCriteria = new ServerSideTableSearchPanel();
        this.serverSearcherCriteria.addKeyListenerForCriteria(this);
        this.clientSearcherCriteria = new ClientSideTableSearchPanel();
        this.clientSearcherCriteria.addKeyListenerForCriteria(this);
    }

    private void showTableSearcherCriteria() {
        this.criteriaContainer.removeAll();
        if (this.serverSideSearch.isSelected()) {
            this.clientSearcherCriteria.setVisible(false);
            this.criteriaContainer.add(this.serverSearcherCriteria, "Center", 0);
            this.serverSearcherCriteria.setVisible(true);
        } else {
            this.serverSearcherCriteria.setVisible(false);
            this.criteriaContainer.add(this.clientSearcherCriteria, "Center", 0);
            this.clientSearcherCriteria.setVisible(true);
        }
        WbSwingUtilities.repaintLater(this.criteriaContainer);
    }

    private void startSearch() {
        if (this.searcher != null && this.searcher.isRunning()) {
            this.startButton.setEnabled(false);
            this.searcher.cancelSearch();
        } else {
            this.searchData();
        }
    }

    @Override
    public void tableSearched(TableIdentifier tableIdentifier, DataStore dataStore) {
        if (dataStore.getRowCount() == 0) {
            return;
        }
        ++this.tableCount;
        EventQueue.invokeLater(() -> {
            try {
                Serializable serializable;
                int n;
                WbTable wbTable = new WbTable(true, true, false);
                DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
                wbTable.setModel(dataStoreTableModel, true);
                wbTable.applyHighlightExpression(this.searcher.getSearchExpression());
                wbTable.checkCopyActions();
                ParentWidthScrollPane parentWidthScrollPane = new ParentWidthScrollPane(wbTable);
                int n2 = wbTable.getRowCount();
                String string = tableIdentifier.getTableExpression() + " " + ResourceMgr.getFormattedString("MsgRows", n2);
                TitledBorder titledBorder = new TitledBorder(" " + string);
                parentWidthScrollPane.setBorder(titledBorder);
                Font font = titledBorder.getTitleFont();
                if (font == null) {
                    UIDefaults uIDefaults = UIManager.getDefaults();
                    font = uIDefaults.getFont("Label.font");
                }
                if (font != null) {
                    font = font.deriveFont(1);
                    titledBorder.setTitleFont(font);
                }
                if ((n = this.resultPanel.getComponentCount()) > 0) {
                    serializable = this.resultPanel.getComponent(n - 1);
                    GridBagLayout gridBagLayout = (GridBagLayout)this.resultPanel.getLayout();
                    GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints((Component)serializable);
                    gridBagConstraints.weighty = 0.0;
                    gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
                }
                serializable = new GridBagConstraints();
                serializable.gridx = 0;
                serializable.fill = 2;
                serializable.weightx = 1.0;
                serializable.weighty = 1.0;
                serializable.anchor = 18;
                this.resultPanel.add((Component)parentWidthScrollPane, serializable);
                int n3 = wbTable.getRowHeight();
                int n4 = parentWidthScrollPane.getWidth();
                Dimension dimension = ((JComponent)parentWidthScrollPane).getPreferredSize();
                if (n2 > 25) {
                    n2 = 25;
                }
                dimension.setSize(n4 - 20, (n2 + 4) * n3);
                parentWidthScrollPane.setPreferredSize(dimension);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error adding result.", exception);
            }
        });
    }

    @Override
    public void error(String string) {
        EventQueue.invokeLater(() -> {
            this.sqlDisplay.appendLine(string);
            this.sqlDisplay.appendLine("\n\n");
        });
    }

    @Override
    public synchronized void setCurrentTable(String string, String string2, long l, long l2) {
        EventQueue.invokeLater(() -> {
            if (string2 == null) {
                String string3 = ResourceMgr.getFormattedString("MsgNoCharCols", string);
                this.sqlDisplay.appendLine("-- " + string3);
            } else {
                StringBuilder stringBuilder = new StringBuilder(this.fixedStatusText.length() + 25);
                stringBuilder.append(this.fixedStatusText);
                stringBuilder.append(string);
                stringBuilder.append(" (");
                stringBuilder.append(NumberStringCache.getNumberString(l));
                stringBuilder.append('/');
                stringBuilder.append(NumberStringCache.getNumberString(l2));
                stringBuilder.append(')');
                this.statusInfo.setText(stringBuilder.toString());
                this.sqlDisplay.appendLine(string2 + ";");
            }
            this.sqlDisplay.appendLine("\n\n");
        });
    }

    @Override
    public void setStatusText(String string) {
        this.statusInfo.setText(string);
    }

    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
        if (this.tableNames != null) {
            this.tableListSource.addTableListDisplayClient(this.tableNames);
        }
    }

    public void disconnect() {
        this.reset();
        this.tableListSource.removeTableListDisplayClient(this.tableNames);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.initGui();
        }
    }

    public void reset() {
        if (!this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            this.resultPanel = new JPanel(new GridBagLayout());
            this.resultScrollPane.setViewportView(this.resultPanel);
            this.sqlDisplay.setText("");
            this.setStatusText("");
        });
    }

    public void searchData() {
        int n;
        boolean bl;
        if (this.searcher != null && this.searcher.isRunning()) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.connection)) {
            return;
        }
        if (this.tableNames.getSelectedRowCount() == 0) {
            return;
        }
        if (Settings.getInstance().getBoolProperty("workbench.searchdata.warn.buffer", true) && !this.serverSideSearch.isSelected() && JdbcUtils.driverMightBufferResults(this.connection) && !(bl = WbSwingUtilities.getYesNo(this, ResourceMgr.getString("MsgTableSearchBuffered")))) {
            return;
        }
        this.reset();
        int[] nArray = this.tableNames.getSelectedRows();
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(this.tableNames.getSelectedRowCount());
        DataStore dataStore = ((WbTable)this.tableNames).getDataStore();
        for (n = 0; n < nArray.length; ++n) {
            String string = dataStore.getValueAsString(nArray[n], 2);
            String string2 = dataStore.getValueAsString(nArray[n], 3);
            String string3 = dataStore.getValueAsString(nArray[n], 0);
            String string4 = dataStore.getValueAsString(nArray[n], 1);
            TableIdentifier tableIdentifier = new TableIdentifier(string, string2, string3);
            tableIdentifier.setNeverAdjustCase(true);
            tableIdentifier.setType(string4);
            arrayList.add(tableIdentifier);
        }
        n = StringUtil.getIntValue(this.rowCount.getText(), 0);
        this.searcher = this.getCriteriaPanel().getSearcher();
        this.searcher.setConnection(this.connection);
        this.searcher.setConsumer(this);
        this.searcher.setMaxRows(n);
        this.searcher.setRetrieveLobColumns(!this.excludeClobs.isSelected());
        this.searcher.setTableNames(arrayList);
        this.fireDbExecStart();
        this.searcher.startBackgroundSearch();
    }

    private String getWorkspacePrefix(int n) {
        return "dbexplorer" + n + ".tablesearcher";
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        this.saveSettings(this.getWorkspacePrefix(n), wbWorkspace.getSettings());
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        this.restoreSettings(this.getWorkspacePrefix(n), wbWorkspace.getSettings());
    }

    public void saveSettings() {
        this.saveSettings(this.getClass().getName(), Settings.getInstance());
    }

    private void saveSettings(String string, PropertyStorage propertyStorage) {
        if (this.initialized) {
            propertyStorage.setProperty(string + ".serversearch", this.serverSideSearch.isSelected());
            propertyStorage.setProperty(string + ".divider", this.jSplitPane1.getDividerLocation());
            if (this.clientSearcherCriteria != null) {
                this.clientSearcherCriteria.saveSettings(string, propertyStorage);
            }
            if (this.serverSearcherCriteria != null) {
                this.serverSearcherCriteria.saveSettings(string, propertyStorage);
            }
            propertyStorage.setProperty(string + ".maxrows", this.rowCount.getText());
            propertyStorage.setProperty(string + ".excludelobs", this.excludeClobs.isSelected());
        } else if (this.workspaceSettings != null) {
            this.workspaceSettings.copyTo(propertyStorage, string);
        }
    }

    public void restoreSettings() {
        this.restoreSettings(this.getClass().getName(), Settings.getInstance());
    }

    private void restoreSettings(String string, PropertyStorage propertyStorage) {
        if (this.initialized) {
            int n = propertyStorage.getIntProperty(string + ".divider", 200);
            this.jSplitPane1.setDividerLocation(n);
            this.serverSideSearch.setSelected(propertyStorage.getBoolProperty(string + ".serversearch", false));
            if (this.clientSearcherCriteria != null) {
                this.clientSearcherCriteria.restoreSettings(string, propertyStorage);
            }
            if (this.serverSearcherCriteria != null) {
                this.serverSearcherCriteria.restoreSettings(string, propertyStorage);
            }
            this.rowCount.setText(propertyStorage.getProperty(string + ".maxrows", "0"));
            this.excludeClobs.setSelected(propertyStorage.getBoolProperty(string + ".excludelobs", true));
            this.showTableSearcherCriteria();
        } else {
            this.workspaceSettings = new FilteredProperties(propertyStorage, string);
        }
    }

    @Override
    public void searchEnded() {
        this.fireDbExecEnd();
        EventQueue.invokeLater(() -> {
            this.resultPanel.doLayout();
            this.getCriteriaPanel().enableControls();
            this.serverSideSearch.setEnabled(true);
            this.startButton.setText(ResourceMgr.getString("LblStartSearch"));
            this.statusInfo.setText("");
            this.startButton.setEnabled(this.tableNames.getSelectedRowCount() > 0);
            this.statusInfo.setText(ResourceMgr.getFormattedString("MsgTablesFound", this.tableCount));
        });
    }

    @Override
    public void searchStarted() {
        this.getCriteriaPanel().disableControls();
        this.serverSideSearch.setEnabled(false);
        this.startButton.setText(ResourceMgr.getString("LblCancelPlain"));
        this.tableCount = 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.initialized) {
            this.startButton.setEnabled(this.tableNames.getSelectedRowCount() > 0);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            EventQueue.invokeLater(this::searchData);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public synchronized void addDbExecutionListener(DbExecutionListener dbExecutionListener) {
        if (this.execListener == null) {
            this.execListener = Collections.synchronizedList(new ArrayList());
        }
        this.execListener.add(dbExecutionListener);
    }

    @Override
    public synchronized void removeDbExecutionListener(DbExecutionListener dbExecutionListener) {
        if (this.execListener == null) {
            return;
        }
        this.execListener.remove(dbExecutionListener);
    }

    protected synchronized void fireDbExecStart() {
        this.connection.executionStart(this.connection, this);
        if (this.execListener == null) {
            return;
        }
        for (DbExecutionListener dbExecutionListener : this.execListener) {
            if (dbExecutionListener == null) continue;
            dbExecutionListener.executionStart(this.connection, this);
        }
    }

    protected synchronized void fireDbExecEnd() {
        this.connection.executionEnd(this.connection, this);
        if (this.execListener == null) {
            return;
        }
        for (DbExecutionListener dbExecutionListener : this.execListener) {
            if (dbExecutionListener == null) continue;
            dbExecutionListener.executionEnd(this.connection, this);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.jSplitPane1 = new WbSplitPane();
        this.resultTabPane = new WbTabbedPane();
        this.resultScrollPane = new WbScrollPane();
        this.resultPanel = new JPanel();
        this.tablePane = new JPanel();
        this.tableListScrollPane = new WbScrollPane();
        this.tableNames = new WbTable(true, false, false);
        this.selectButtonPanel = new JPanel();
        this.selectAllButton = new FlatButton();
        this.filler1 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.selectNoneButton = new FlatButton();
        this.statusInfo = new WbStatusLabel();
        this.entryPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.criteriaContainer = new JPanel();
        this.serverSideSearch = new JCheckBox();
        this.excludeClobs = new JCheckBox();
        this.labelRowCount = new JLabel();
        this.rowCount = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jSplitPane1.setMinimumSize(new Dimension(30, 54));
        this.resultTabPane.setMinimumSize(new Dimension(30, 34));
        this.resultScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.resultScrollPane.setHorizontalScrollBarPolicy(31);
        this.resultPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resultPanel.setLayout(new GridBagLayout());
        this.resultScrollPane.setViewportView(this.resultPanel);
        this.resultTabPane.addTab(ResourceMgr.getString("LblTableSearchResultTab"), this.resultScrollPane);
        this.jSplitPane1.setRightComponent(this.resultTabPane);
        this.tablePane.setMinimumSize(new Dimension(30, 52));
        this.tablePane.setLayout(new BorderLayout());
        this.tableNames.setModel(this.tableListModel);
        this.tableListScrollPane.setViewportView(this.tableNames);
        this.tablePane.add((Component)this.tableListScrollPane, "Center");
        this.selectButtonPanel.setLayout(new FlowLayout(0, 0, 3));
        this.selectAllButton.setText(ResourceMgr.getString("LblSelectAll"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSearchPanel.this.selectAllButtonActionPerformed(actionEvent);
            }
        });
        this.selectButtonPanel.add(this.selectAllButton);
        this.selectButtonPanel.add(this.filler1);
        this.selectNoneButton.setText(ResourceMgr.getString("LblSelectNone"));
        this.selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSearchPanel.this.selectNoneButtonActionPerformed(actionEvent);
            }
        });
        this.selectButtonPanel.add(this.selectNoneButton);
        this.tablePane.add((Component)this.selectButtonPanel, "North");
        this.jSplitPane1.setLeftComponent(this.tablePane);
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.statusInfo, "South");
        this.entryPanel.setMinimumSize(new Dimension(30, 27));
        this.entryPanel.setPreferredSize(new Dimension(30, 27));
        this.entryPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(1, 2, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.entryPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.criteriaContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.entryPanel.add((Component)this.criteriaContainer, gridBagConstraints);
        this.serverSideSearch.setText(ResourceMgr.getString("LblSearchServer"));
        this.serverSideSearch.setToolTipText(ResourceMgr.getString("d_LblSearchServer"));
        this.serverSideSearch.setBorder(null);
        this.serverSideSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSearchPanel.this.serverSideSearchActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.entryPanel.add((Component)this.serverSideSearch, gridBagConstraints);
        this.excludeClobs.setText(ResourceMgr.getString("LblExclLobs"));
        this.excludeClobs.setToolTipText(ResourceMgr.getString("d_LblExclLobs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.entryPanel.add((Component)this.excludeClobs, gridBagConstraints);
        this.labelRowCount.setLabelFor(this.rowCount);
        this.labelRowCount.setText(ResourceMgr.getString("LblMaxRows"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.entryPanel.add((Component)this.labelRowCount, gridBagConstraints);
        this.rowCount.setColumns(4);
        this.rowCount.setHorizontalAlignment(4);
        this.rowCount.setText("0");
        this.rowCount.setMinimumSize(new Dimension(30, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 3, 2, 10);
        this.entryPanel.add((Component)this.rowCount, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.entryPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.jSeparator2.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.entryPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.jSeparator3.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.entryPanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.jSeparator4.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.entryPanel.add((Component)this.jSeparator4, gridBagConstraints);
        this.add((Component)this.entryPanel, "North");
    }

    private void selectNoneButtonActionPerformed(ActionEvent actionEvent) {
        this.tableNames.getSelectionModel().removeSelectionInterval(0, this.tableNames.getRowCount() - 1);
    }

    private void selectAllButtonActionPerformed(ActionEvent actionEvent) {
        this.tableNames.getSelectionModel().setSelectionInterval(0, this.tableNames.getRowCount() - 1);
    }

    private void serverSideSearchActionPerformed(ActionEvent actionEvent) {
        this.showTableSearcherCriteria();
    }

    static class ParentWidthScrollPane
    extends JScrollPane {
        private Dimension preferredSize = new Dimension(0, 0);

        ParentWidthScrollPane(Component component) {
            super(component);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Container container = this.getParent();
            this.preferredSize.setSize((double)container.getWidth() - 5.0, dimension.getHeight());
            return this.preferredSize;
        }
    }
}

