/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.db.TableIdentifier;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.Resettable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;

public class TriggerDisplayPanel
extends JPanel
implements ListSelectionListener,
Resettable {
    private TriggerReader reader;
    private WbTable triggers = new WbTable();
    private EditorPanel source;
    private WbSplitPane splitPane;
    private String triggerSchema;
    private String triggerCatalog;
    private TableIdentifier triggerTable;

    public TriggerDisplayPanel() {
        super(new BorderLayout());
        this.triggers.setRendererSetup(RendererSetup.getBaseSetup());
        this.source = EditorPanel.createSqlEditor();
        this.source.setEditable(false);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new WbScrollPane(this.triggers), "Center");
        this.splitPane = new WbSplitPane(0, jPanel, this.source);
        this.splitPane.setDividerSize(IconMgr.getInstance().getSizeForLabel() / 2);
        this.splitPane.setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
        this.add((Component)this.splitPane, "Center");
        this.triggers.getSelectionModel().addListSelectionListener(this);
        this.triggers.getSelectionModel().setSelectionMode(0);
    }

    public void saveSettings() {
        Settings.getInstance().setProperty(this.getClass().getName() + ".divider", this.splitPane.getDividerLocation());
    }

    public void restoreSettings() {
        int n = Settings.getInstance().getIntProperty(this.getClass().getName() + ".divider", 200);
        this.splitPane.setDividerLocation(n);
    }

    public void setConnection(WbConnection wbConnection) {
        this.reader = TriggerReaderFactory.createReader(wbConnection);
        this.source.setDatabaseConnection(wbConnection);
        this.reset();
    }

    @Override
    public void reset() {
        this.triggers.reset();
        this.source.reset();
        this.triggerSchema = null;
        this.triggerCatalog = null;
    }

    public void readTriggers(TableIdentifier tableIdentifier) {
        try {
            if (tableIdentifier == null) {
                return;
            }
            this.triggerTable = tableIdentifier;
            DataStore dataStore = this.reader.getTableTriggers(tableIdentifier);
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
            WbSwingUtilities.invoke(() -> {
                this.triggers.setModel(dataStoreTableModel, true);
                this.triggers.adjustRowsAndColumns();
                this.triggerCatalog = tableIdentifier.getCatalog();
                this.triggerSchema = tableIdentifier.getSchema();
                if (this.triggers.getRowCount() > 0) {
                    this.triggers.getSelectionModel().setSelectionInterval(0, 0);
                } else {
                    this.source.setText("");
                }
            });
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving triggers", exception);
            this.reset();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.triggers.getSelectedRow();
        if (n < 0) {
            return;
        }
        try {
            String string = this.triggers.getValueAsString(n, 0);
            String string2 = this.triggers.getValueAsString(n, 4);
            String string3 = this.reader.getTriggerSource(this.triggerCatalog, this.triggerSchema, string, this.triggerTable, string2, true);
            this.source.setText(string3);
            this.source.setCaretPosition(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.source.setText("");
        }
    }
}

